<script>
  function buildPie(echarts,chartId,title,data) {
    // 基于准备好的dom，初始化echarts图表
    var myChart = echarts.init(document.getElementById(chartId));
    var option = {
      color:['#5470c6', '#91cc75', '#fac858', '#ee6666', '#73c0de', '#3ba272', '#fc8452', '#9a60b4', '#ea7ccc'],
      title: {
        text: title,
        show: true,
        x: 'center',
        textStyle: {
          color: '#333', // 主标题文字颜色
          fontStyle: 'normal', // 主标题文字风格
          fontWeight: 'normal', // 主标题文字粗细
          fontSize: 14 // 主标题文字大小
        },
      },
      series: [
        {
          type: 'pie',
          radius: ['30%', '70%'],
          avoidLabelOverlap: false,
          label: {
            show: false,
            position: 'center'
          },
          emphasis: {
            label: {
              show: true,
              fontSize: '25',
              fontWeight: 'bold'
            }
          },
          data: data
        }
      ],
      tooltip: {
        trigger: 'item',
        formatter: "{b}: {c}人 ({d}%)" // 显示系列名，数据名，数据值和百分比
      },
    };
    // 为echarts对象加载数据
    myChart.setOption(option);
  }
</script>

[#macro pie chartId title data]
<div id="${chartId}" style="width:300px;height:150px;"></div>
<script>
require(['echarts'],function(echarts){buildPie(echarts,'${chartId}','${title}',[[#list data as k ,v ]{name:'${k}',value:${v}}[#sep],[/#list]])});
</script>
[/#macro]
