[@b.head title="${std.name} 课程成绩"/]
[@b.toolbar title="学生成绩信息"]
   bar.addClose();
[/@]
<style>
  .table-mini th{
    color:#6c757d !important;
    font-weight: normal;
  }
  .table-mini-nohead thead tr{
    visibility: collapse;
  }
  .table-mini th{
    color:#6c757d !important;
    font-weight: normal;
  }
  td.title{
    padding: 0.2rem 0rem;
    text-align: right;
    color: #6c757d !important;
  }
</style>
[#macro panel semester first=false]
<div class="card [#if first]card-primary card-outline[/#if]">
  <div class="card-header">
    <h4 class="card-title">
      <span [#if bestSemesterId>0 && semester.id=bestSemesterId]class="text-success"[/#if]
        [#if worseSemesterId>0 && semester.id=worseSemesterId]class="text-danger"[/#if]>
      ${semester.schoolYear}学年度 ${semester.name}学期
      </span>
      <span class="text-muted" style="font-size:0.8em;">(${semester.beginOn}~${semester.endOn})</span>
    </h4>
    <div class="card-tools">
      [#local semesterGpa = stdGpa.getStdTermGpa(semester)/]
      <div class="text-muted" style="display:flex;">
        <span style="width: 100px;"><i class="fa-solid fa-list"></i>课程：${semesterGpa.gradeCount}门</span>
        <span style="width: 120px;"><i class="fa-solid fa-star"></i>获得：${semesterGpa.credits}学分</span>
        <span style="width: 120px;"><i class="fa-solid fa-chart-line"></i>平均：${semesterGpa.ga}分</span>
      </div>
    </div>
  </div>
  <div class="card-body" style="padding-top:0px;padding-bottom:0px;">
  [#nested/]
  </div>
</div>
[/#macro]

[#assign bestSemesterId=0/][#assign bestGa=0/]
[#assign worseSemesterId=0/][#assign worseGa=1000/]
[#if stdGpa.semesterGpas?size>2]
  [#list stdGpa.semesterGpas as gpa]
    [#if gpa.ga=0 && gpa.credits>0] [#continue/] [/#if]
    [#if gpa.ga > bestGa]
      [#assign bestSemesterId=gpa.semester.id/][#assign bestGa=gpa.ga/]
    [/#if]
    [#if gpa.ga < worseGa]
      [#assign worseSemesterId=gpa.semester.id/][#assign worseGa=gpa.ga/]
    [/#if]
  [/#list]
[/#if]

<div class="container">

  <div class="card card-primary card-outline">
    <div class="card-header">
      <h4 class="card-title">[@ems.avatar username=std.code style="border-radius: 10%;height:30px;"/]${std.project.school.name} ${std.name} 成绩</h4>
    </div>
    <div class="card-body" style="padding-top:0px;padding-bottom:0px;">
     [#include "std-info.ftl"/]
    </div>
  </div>

  <div class="card card-primary card-outline">
    <div class="card-header">
      <h4 class="card-title">成绩统计 <span style="font-size:0.8rem;" class="text-muted">统计时间:${stdGpa.updatedAt?string("yyyy-MM-dd HH:mm")}</span></h4>
      <div class="card-tools">
        <div class="text-muted" style="display:flex;">
          <span style="width: 100px;"><i class="fa-solid fa-list"></i>课程：${stdGpa.gradeCount}门</span>
          <span style="width: 120px;"><i class="fa-solid fa-star"></i>获得：${stdGpa.credits}学分</span>
          <span style="width: 120px;"><i class="fa-solid fa-chart-line"></i>平均：${stdGpa.ga}分</span>
        </div>
      </div>
    </div>
    <div class="card-body" style="padding-top:0px;padding-bottom:0px;">
      [#include "stat.ftl"/]
    </div>
  </div>

[#list semesterGrades?keys?sort_by('beginOn')?reverse as semester]
  [@panel semester semester_index==0]
    [#assign className="table-sm table-mini-nohead"/]
    [#if semester_index==0][#assign className="table-sm table-mini"/][/#if]
    [@b.grid items=semesterGrades.get(semester)?sort_by('crn') var="courseGrade" theme="mini" style="table-layout: fixed;" class=className ]
      [@b.row]
        [@b.col title="序号" width="5%"]${courseGrade_index+1}[/@]
        [@b.col property="crn" title="课程序号" width="7%"/]
        [@b.col property="course.code" title="课程代码" width="9%"/]
        [@b.col property="course.name" title="课程名称"/]
        [@b.col property="score" title="成绩" width="7%"]
          <span [#if !courseGrade.published]style="background-color:grey" title="未发布"[/#if]>
          [#if courseGrade.passed]${(courseGrade.scoreText)?if_exists}[#else]<font color="red">${(courseGrade.scoreText)?if_exists}</font>[/#if]
          [#if courseGrade.exempt]免修[/#if]
          </span>
        [/@]
        [@b.col property="credits" title="学分" width="5%"/]
        [@b.col property="gp" title="绩点" width="5%"][#if courseGrade.passed]${(courseGrade.gp?string("#.##"))?if_exists}[#else]<font color="red">${(courseGrade.gp?string("#.##"))?if_exists}</font>[/#if][/@]
        [@b.col title="授课教师" width="10%"]
          [#if courseGrade.clazz??][#list courseGrade.clazz.teachers as t]${t.name}[#sep],[/#list][/#if]
        [/@]
        [@b.col property="courseType.name" title="课程类别" width="20%"/]
      [/@]
    [/@]
  [/@]
[/#list]
</div>
[@b.foot/]
