[#ftl/]
<table id="stat_grade" style="width:100%;">
  <tr>
    <td style="vertical-align:top;width:60%">
      <table class="table table-sm table-mini" style="width:100%;">
        <thead>
          <tr>
            <th>学年学期</th>
            <th>课程门数</th>
            <th>总学分</th>
            <th>平均分</th>
            <th>平均绩点</th>
          </tr>
        </thead>
        <tbody>
          [#list stdGpa.semesterGpas?sort_by(["semester","code"])?reverse as stdSemesterGpa]
          <tr [#if bestSemesterId>0 && stdSemesterGpa.semester.id=bestSemesterId]class="text-success"[/#if]
          [#if worseSemesterId>0 && stdSemesterGpa.semester.id=worseSemesterId]class="text-danger"[/#if]
          >
            <td>${(stdSemesterGpa.semester.schoolYear)!} ${(stdSemesterGpa.semester.name)!}</td>
            <td>${(stdSemesterGpa.gradeCount)!}</td>
            <td>${(stdSemesterGpa.credits)!}</td>
            <td>${(stdSemesterGpa.ga)!}</td>
            <td>${(stdSemesterGpa.gpa)!}</td>
          </tr>
          [/#list]
          <tr>
            <td>在校汇总</td>
            <td>${stdGpa.gradeCount!}</td>
            <td>${stdGpa.credits!}</td>
            <td>${stdGpa.ga!}</td>
            <td>${stdGpa.gpa!}</td>
          </tr>
        </tbody>
      </table>
    </td>
    <td style="vertical-align:top">
      <div id="chart-grade" style="width:500px;height:300px"></div>
    </td>
  </tr>
</table>

<script>
  require(['echarts'],initCharts);
  function initCharts(echarts) {
    // 基于准备好的dom，初始化echarts图表
    var myChart = echarts.init(document.getElementById('chart-grade'));
    var option = {
      title: {
        text: '成绩、门数分布图',
        show: true,
        x: 'center',
        textStyle: {
          color: '#333', // 主标题文字颜色
          fontStyle: 'normal', // 主标题文字风格
          fontWeight: 'normal', // 主标题文字粗细
          fontSize: 14 // 主标题文字大小
        },
      },
      xAxis: {
        data: [[#list segs.segments as seg]'${seg.min}~${seg.max}'[#sep],[/#list]],
        name: '分数',
        axisLabel: {
          rotate: 30 // 倾斜的角度
        },
      },
      yAxis: {
        type: 'value',
        name: '门数',
      },
      series: [
        {
          data: [[#list segs.segments as seg]${seg.count}[#sep],[/#list]],
          type: 'line',
          smooth: true ,
          areaStyle: {
            origin: 'start',
            color: {
              type: 'linear',
              x: 0,
              y: 0,
              x2: 0,
              y2: 1,
              colorStops: [
                { offset: 0, color: "#dc3881" },
                { offset: 1, color: "rgba(220,56,129,0)" },
              ],
              global: false,
            },
          },
        }
      ],
    };
    // 为echarts对象加载数据
    myChart.setOption(option);
  }
</script>
