/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.graduation.makeup.model;

import java.util.Date;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.openurp.base.model.Department;
import org.openurp.edu.base.model.Course;
import org.openurp.edu.base.model.ProjectBasedObject;
import org.openurp.edu.base.model.Semester;
import org.openurp.edu.base.model.Squad;
import org.openurp.edu.base.model.Teacher;
import org.openurp.edu.graduation.makeup.model.MakeupTaker;

@Entity(name="org.openurp.edu.graduation.makeup.model.MakeupCourse")
public class MakeupCourse
extends ProjectBasedObject<Long> {
    private static final long serialVersionUID = 948062786583259274L;
    @NotNull
    @Size(max=50)
    private String seqNo;
    @ManyToOne(fetch=FetchType.LAZY)
    @NotNull
    private Semester semester;
    @ManyToOne(fetch=FetchType.LAZY)
    @NotNull
    private Course course;
    @ManyToOne(fetch=FetchType.LAZY)
    @NotNull
    private Department depart;
    @OneToMany(mappedBy="task", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<MakeupTaker> takers = CollectUtils.newHashSet();
    private int stdCount;
    private boolean submitGrade;
    private boolean published;
    @ManyToOne(fetch=FetchType.LAZY)
    private Teacher teacher;
    @ManyToMany
    private Set<Squad> squads = CollectUtils.newHashSet();
    private Date inputAt;

    public void mergeWith(MakeupCourse makeupTask) {
        this.setStdCount(this.getStdCount() + makeupTask.getStdCount());
        this.getSquads().addAll(makeupTask.getSquads());
        Set<MakeupTaker> taker = makeupTask.getTakers();
        for (MakeupTaker lastMakeupTake2 : taker) {
            MakeupTaker make = new MakeupTaker(this, lastMakeupTake2.getStd(), lastMakeupTake2.getCourseType());
            this.getTakers().add(make);
        }
    }

    public Set<Squad> getSquads() {
        return this.squads;
    }

    public void setSquads(Set<Squad> squads) {
        this.squads = squads;
    }

    public Teacher getTeacher() {
        return this.teacher;
    }

    public void setTeacher(Teacher teacher) {
        this.teacher = teacher;
    }

    public String getSeqNo() {
        return this.seqNo;
    }

    public void setSeqNo(String seqNo) {
        this.seqNo = seqNo;
    }

    public Semester getSemester() {
        return this.semester;
    }

    public void setSemester(Semester semester) {
        this.semester = semester;
    }

    public Course getCourse() {
        return this.course;
    }

    public void setCourse(Course course) {
        this.course = course;
    }

    public Department getDepart() {
        return this.depart;
    }

    public void setDepart(Department depart) {
        this.depart = depart;
    }

    public int getStdCount() {
        return this.stdCount;
    }

    public void setStdCount(int stdCount) {
        this.stdCount = stdCount;
    }

    public boolean isSubmitGrade() {
        return this.submitGrade;
    }

    public void setSubmitGrade(boolean submitGrade) {
        this.submitGrade = submitGrade;
    }

    public Set<MakeupTaker> getTakers() {
        return this.takers;
    }

    public void setTakers(Set<MakeupTaker> takers) {
        this.takers = takers;
    }

    public boolean isPublished() {
        return this.published;
    }

    public void setPublished(boolean published) {
        this.published = published;
    }

    public Date getInputAt() {
        return this.inputAt;
    }

    public void setInputAt(Date inputAt) {
        this.inputAt = inputAt;
    }
}

