/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.learning.web.action;

import java.io.Serializable;
import java.net.URL;
import org.beangle.commons.codec.digest.Digests$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.ems.app.Ems$;
import org.beangle.ems.app.EmsApp$;
import org.beangle.security.Securities$;
import org.beangle.webmvc.support.ActionSupport;
import org.beangle.webmvc.view.Status$;
import org.beangle.webmvc.view.View;
import org.openurp.base.model.Project;
import org.openurp.base.model.Semester;
import org.openurp.edu.clazz.config.ScheduleSetting;
import org.openurp.edu.clazz.domain.ClazzProvider;
import org.openurp.edu.clazz.model.ClazzBulletin;
import org.openurp.edu.clazz.model.ClazzDoc;
import org.openurp.edu.clazz.model.ClazzNotice;
import org.openurp.edu.clazz.model.ClazzNoticeFile;
import org.openurp.edu.clazz.model.CourseTaker;
import org.openurp.edu.course.model.ClazzPlan;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class ClazzAction
extends ActionSupport {
    private EntityDao entityDao;
    private ClazzProvider clazzProvider;

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public ClazzProvider clazzProvider() {
        return this.clazzProvider;
    }

    public void clazzProvider_$eq(ClazzProvider x$1) {
        this.clazzProvider = x$1;
    }

    public View index() {
        CourseTaker taker = this.getTake();
        Project project = taker.clazz().project();
        Semester semester = taker.clazz().semester();
        OqlBuilder query = OqlBuilder$.MODULE$.from(ScheduleSetting.class, "setting");
        query.where("setting.project =:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project}));
        query.where("setting.semester =:semester", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semester}));
        query.cacheable(query.cacheable$default$1());
        ScheduleSetting setting = (ScheduleSetting)this.entityDao().search((QueryBuilder)query).headOption().getOrElse(ClazzAction::$anonfun$1);
        this.put("setting", (Object)setting);
        this.put("clazz", (Object)taker.clazz());
        Map avatarUrls = ((IterableOnceOps)taker.clazz().teachers().map((Function1 & Serializable)x -> Tuple2$.MODULE$.apply(x.id(), (Object)(Ems$.MODULE$.api() + "/platform/user/avatars/" + Digests$.MODULE$.md5Hex(x.code()) + ".jpg")))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.put("avatarUrls", (Object)avatarUrls);
        this.put("clazzes", this.clazzProvider().getClazzes(semester, taker.std()).map((Function1 & Serializable)_$3 -> _$3.clazz()));
        return this.forward(this.forward$default$1());
    }

    private CourseTaker getTake() {
        OqlBuilder query = OqlBuilder$.MODULE$.from(CourseTaker.class, "ct");
        query.where("ct.clazz.id=:clazzId", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.getLong("clazz.id").getOrElse(ClazzAction::getTake$$anonfun$1)}));
        query.where("ct.std.code=:code", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Securities$.MODULE$.user()}));
        return (CourseTaker)this.entityDao().search((QueryBuilder)query).head();
    }

    public View materials() {
        long clazzId = BoxesRunTime.unboxToLong((Object)this.getLong("clazz.id").getOrElse(ClazzAction::$anonfun$3));
        OqlBuilder query = OqlBuilder$.MODULE$.from(ClazzDoc.class, "doc");
        query.where("doc.clazz.id=:clazzId", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)clazzId)}));
        this.put("materials", (Object)this.entityDao().search((QueryBuilder)query));
        return this.forward(this.forward$default$1());
    }

    public View bulletin() {
        long clazzId = BoxesRunTime.unboxToLong((Object)this.getLong("clazz.id").getOrElse(ClazzAction::$anonfun$4));
        OqlBuilder query = OqlBuilder$.MODULE$.from(ClazzBulletin.class, "bulletin");
        query.where("bulletin.clazz.id=:clazzId", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)clazzId)}));
        this.put("bulletin", (Object)this.entityDao().search((QueryBuilder)query).headOption());
        return this.forward(this.forward$default$1());
    }

    public View teachingPlan() {
        long clazzId = BoxesRunTime.unboxToLong((Object)this.getLong("clazz.id").getOrElse(ClazzAction::$anonfun$5));
        OqlBuilder query = OqlBuilder$.MODULE$.from(ClazzPlan.class, "plan");
        query.where("plan.clazz.id=:clazzId", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)clazzId)}));
        this.put("plan", (Object)this.entityDao().search((QueryBuilder)query).headOption());
        return this.forward(this.forward$default$1());
    }

    public View download() {
        long noticeFileId = BoxesRunTime.unboxToLong((Object)this.getLong("noticeFile.id").getOrElse(ClazzAction::$anonfun$6));
        long materialId = BoxesRunTime.unboxToLong((Object)this.getLong("material.id").getOrElse(ClazzAction::$anonfun$7));
        long bulletinId = BoxesRunTime.unboxToLong((Object)this.getLong("bulletin.id").getOrElse(ClazzAction::$anonfun$8));
        if (noticeFileId > 0L) {
            ClazzNoticeFile noticeFile = (ClazzNoticeFile)this.entityDao().get(ClazzNoticeFile.class, (Object)BoxesRunTime.boxToLong((long)noticeFileId));
            Option path = EmsApp$.MODULE$.getBlobRepository(true).url(noticeFile.filePath());
            return this.redirect(this.to(((URL)path.get()).toString()), "x");
        }
        if (materialId > 0L) {
            ClazzDoc material = (ClazzDoc)this.entityDao().get(ClazzDoc.class, (Object)BoxesRunTime.boxToLong((long)materialId));
            Option option = material.filePath();
            if (None$.MODULE$.equals(option)) {
                return Status$.MODULE$.NotFound();
            }
            if (option instanceof Some) {
                String p = (String)((Some)option).value();
                Option path = EmsApp$.MODULE$.getBlobRepository(true).url(p);
                return this.redirect(this.to(((URL)path.get()).toString()), "x");
            }
            throw new MatchError((Object)option);
        }
        ClazzBulletin bulletin = (ClazzBulletin)this.entityDao().get(ClazzBulletin.class, (Object)BoxesRunTime.boxToLong((long)bulletinId));
        Option option = bulletin.contactQrcodePath();
        if (None$.MODULE$.equals(option)) {
            return Status$.MODULE$.NotFound();
        }
        if (option instanceof Some) {
            String p = (String)((Some)option).value();
            Option path = EmsApp$.MODULE$.getBlobRepository(true).url(p);
            return this.redirect(this.to(((URL)path.get()).toString()), "x");
        }
        throw new MatchError((Object)option);
    }

    public View notices() {
        long clazzId = BoxesRunTime.unboxToLong((Object)this.getLong("clazz.id").getOrElse(ClazzAction::$anonfun$9));
        OqlBuilder query = OqlBuilder$.MODULE$.from(ClazzNotice.class, "notice");
        query.where("notice.clazz.id=:clazzId", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)clazzId)}));
        this.put("notices", (Object)this.entityDao().search((QueryBuilder)query));
        return this.forward(this.forward$default$1());
    }

    private static final ScheduleSetting $anonfun$1() {
        return new ScheduleSetting();
    }

    private static final Object getTake$$anonfun$1() {
        return BoxesRunTime.boxToInteger((int)0);
    }

    private static final long $anonfun$3() {
        return 0L;
    }

    private static final long $anonfun$4() {
        return 0L;
    }

    private static final long $anonfun$5() {
        return 0L;
    }

    private static final long $anonfun$6() {
        return 0L;
    }

    private static final long $anonfun$7() {
        return 0L;
    }

    private static final long $anonfun$8() {
        return 0L;
    }

    private static final long $anonfun$9() {
        return 0L;
    }
}

