/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.mentor.web.action;

import java.io.Serializable;
import java.time.LocalDate;
import org.beangle.commons.bean.PropertyExtractor;
import org.beangle.commons.codec.digest.Digests$;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.doc.transfer.exporter.ExportContext;
import org.beangle.ems.app.Ems$;
import org.beangle.webmvc.annotation.ignore;
import org.beangle.webmvc.annotation.mapping;
import org.beangle.webmvc.support.EntitySupport;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.support.action.ExportSupport;
import org.beangle.webmvc.support.helper.QueryHelper$;
import org.beangle.webmvc.view.View;
import org.openurp.base.hr.model.Mentor;
import org.openurp.base.model.Project;
import org.openurp.base.service.Features;
import org.openurp.base.std.model.Graduate;
import org.openurp.base.std.model.Student;
import org.openurp.code.edu.model.EducationLevel;
import org.openurp.code.person.model.Gender;
import org.openurp.code.std.model.StudentStatus;
import org.openurp.edu.mentor.web.helper.StudentPropertyExtractor;
import org.openurp.starter.web.support.MentorSupport;
import org.openurp.std.info.model.Contact;
import org.openurp.std.info.model.Examinee;
import org.openurp.std.info.model.Home;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class StudentAction
extends MentorSupport
implements EntityAction<Student>,
ExportSupport<Student> {
    private Class entityClass;

    public StudentAction() {
        EntitySupport.$init$((EntitySupport)this);
        Statics.releaseFence();
    }

    public Class entityClass() {
        return this.entityClass;
    }

    public void org$beangle$webmvc$support$EntitySupport$_setter_$entityClass_$eq(Class x$0) {
        this.entityClass = x$0;
    }

    public View projectIndex(Mentor mentor, Project project) {
        this.put("departments", (Object)project.departments());
        this.put("studentTypes", (Object)project.stdTypes());
        this.put("levels", (Object)this.codeService().get(EducationLevel.class));
        this.put("genders", (Object)this.codeService().get(Gender.class));
        this.put("states", (Object)this.codeService().get(StudentStatus.class));
        this.put("tutorSupported", this.getConfig(Features.Std$.MODULE$.TutorSupported(), project));
        this.put("project", (Object)project);
        return this.forward(this.forward$default$1());
    }

    public View search() {
        LazyRef lazyRef = new LazyRef();
        this.put("project", (Object)this.project$1(lazyRef));
        this.put("tutorSupported", this.getConfig(Features.Std$.MODULE$.TutorSupported(), this.project$1(lazyRef)));
        Seq stds = this.entityDao().search((QueryBuilder)this.getQueryBuilder());
        this.put("students", (Object)stds);
        return this.forward(this.forward$default$1());
    }

    public OqlBuilder<Student> getQueryBuilder() {
        Mentor mentor = this.getMentor();
        Project project = this.getProject();
        OqlBuilder query = OqlBuilder$.MODULE$.from(Student.class, "student");
        query.where("(student.state.squad.mentor=:mentor or student.state.squad.master=:mentor)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{mentor.staff()}));
        query.where("student.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{project}));
        LocalDate date = LocalDate.now();
        this.get("status").foreach((Function1 & Serializable)x$1 -> {
            String string = x$1;
            switch (string == null ? 0 : string.hashCode()) {
                case -1822954745: {
                    if (!"active_unregisted".equals(string)) break;
                    return query.where("student.state.inschool=true and student.registed=false", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
                }
                case -1422950650: {
                    if (!"active".equals(string)) break;
                    return query.where("student.beginOn<= :now and student.endOn>=:now and student.registed=true and student.state.inschool = true", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{date}));
                }
                case -733902135: {
                    if (!"available".equals(string)) break;
                    return query.where("student.beginOn<= :now and student.endOn>=:now and student.registed=true ", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{date}));
                }
                case -665462704: {
                    if (!"unavailable".equals(string)) break;
                    return query.where("student.beginOn> :now or student.endOn<:now or student.registed=false", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{date}));
                }
                case -536447265: {
                    if (!"unactive".equals(string)) break;
                    return query.where("student.beginOn<= :now and student.endOn>=:now and student.registed=true and student.state.inschool = false", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{date}));
                }
                case 0: {
                    if (!"".equals(string)) break;
                    return BoxedUnit.UNIT;
                }
            }
            throw new MatchError((Object)string);
        });
        QueryHelper$.MODULE$.populate(query);
        query.limit(QueryHelper$.MODULE$.pageLimit());
        return query;
    }

    @mapping(value="{id}")
    public View info(String id) {
        Student student = (Student)this.entityDao().get(Student.class, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(id))));
        this.put("contact", (Object)this.entityDao().findBy(Contact.class, "std", (Object)student).headOption());
        this.put("home", (Object)this.entityDao().findBy(Home.class, "std", (Object)student).headOption());
        this.put("examinee", (Object)this.entityDao().findBy(Examinee.class, "std", (Object)student).headOption());
        this.put("graduate", (Object)this.entityDao().findBy(Graduate.class, "std", (Object)student).headOption());
        this.put("avatarUrl", (Object)(Ems$.MODULE$.api() + "/platform/user/avatars/" + Digests$.MODULE$.md5Hex(student.code())));
        this.put("student", (Object)student);
        return this.forward(this.forward$default$1());
    }

    public View courseTakers() {
        long stdId = this.getLongId("student");
        return this.forward(this.forward$default$1());
    }

    public View progress() {
        return this.forward(this.forward$default$1());
    }

    @ignore
    public void configExport(ExportContext context) {
        context.extractor_$eq((PropertyExtractor)new StudentPropertyExtractor(this.entityDao()));
        ExportSupport.configExport$((ExportSupport)this, (ExportContext)context);
    }

    private final Project project$lzyINIT1$1(LazyRef project$lzy1$1) {
        Project project;
        LazyRef lazyRef = project$lzy1$1;
        synchronized (lazyRef) {
            project = (Project)(project$lzy1$1.initialized() ? project$lzy1$1.value() : project$lzy1$1.initialize((Object)this.getProject()));
        }
        return project;
    }

    private final Project project$1(LazyRef project$lzy1$2) {
        return (Project)(project$lzy1$2.initialized() ? project$lzy1$2.value() : this.project$lzyINIT1$1(project$lzy1$2));
    }
}

