/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.mentor.web.helper;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.beangle.commons.bean.DefaultPropertyExtractor;
import org.beangle.commons.bean.Properties$;
import org.beangle.commons.collection.Collections$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.openurp.base.std.model.Graduate;
import org.openurp.base.std.model.Student;
import org.openurp.std.info.model.Contact;
import org.openurp.std.info.model.Examinee;
import org.openurp.std.info.model.Home;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class StudentPropertyExtractor
extends DefaultPropertyExtractor {
    private final EntityDao entityDao;
    private Student current;
    private final Map<String, Object> stdInfoMap;
    private final DateTimeFormatter sdfYMD;

    public StudentPropertyExtractor(EntityDao entityDao) {
        this.entityDao = entityDao;
        this.stdInfoMap = Collections$.MODULE$.newMap();
        this.sdfYMD = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    }

    public Object get(Object target, String property) {
        Student student = (Student)target;
        String[] secptions = property.split("_");
        String fieldName = secptions[0];
        String className = secptions[1];
        if ("std".equals(className)) {
            if ("code_std".equals(property)) {
                return student.code();
            }
            if ("labels_std".equals(property)) {
                StringBuilder labelValue = new StringBuilder();
                student.labels().keySet().foreach((Function1)(JProcedure1 & Serializable)labelType -> {
                    if (labelValue.nonEmpty()) {
                        labelValue.append(";");
                    }
                    student.labels().get(labelType).foreach((Function1 & Serializable)label -> labelValue.append(labelType.name()).append(":").append(label.name()));
                });
                return labelValue.toString();
            }
            return this.loadPropertyValue((Object)student, fieldName);
        }
        if ("person".equals(className)) {
            return this.loadPropertyValue((Object)student.person(), fieldName);
        }
        return this.loadPropertyValue(this.loadStdOtherEntity(student, className), fieldName);
    }

    private Object loadPropertyValue(Object target, String fieldName) {
        String string;
        if (target == null) {
            return "";
        }
        try {
            Object value;
            Object object;
            Object object2 = target;
            if (object2 instanceof Some) {
                Object a = ((Some)object2).value();
                object = Properties$.MODULE$.get(a, fieldName, ClassTag$.MODULE$.apply(Object.class));
            } else {
                object = Properties$.MODULE$.get(target, fieldName, ClassTag$.MODULE$.apply(Object.class));
            }
            Object object3 = value = object;
            if (object3 instanceof Boolean) {
                Boolean b = (Boolean)object3;
                string = Predef$.MODULE$.Boolean2boolean(b) ? "\u662f" : "\u5426";
            } else if (object3 instanceof LocalDate) {
                LocalDate ld = (LocalDate)object3;
                string = this.sdfYMD.format(ld);
            } else if (object3 == null) {
                string = "";
            } else if (object3 instanceof Some) {
                Object v = ((Some)object3).value();
                string = String.valueOf(v);
            } else {
                string = None$.MODULE$.equals(object3) ? "" : String.valueOf(value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return string;
    }

    private Object loadStdOtherEntity(Student student, String className) {
        String key;
        block10: {
            block12: {
                block11: {
                    key = student.id().toString() + "_" + className;
                    if (this.stdInfoMap.contains((Object)key)) break block10;
                    if (this.current == null) break block11;
                    Student student2 = this.current;
                    Student student3 = student;
                    if (!(student2 == null ? student3 != null : !student2.equals(student3))) break block12;
                }
                this.current = student;
                this.stdInfoMap.clear();
            }
            String string = className;
            String string2 = "graduate";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.stdInfoMap.put((Object)key, (Object)this.entityDao.findBy(Graduate.class, "std.id", student.id()));
            } else {
                String string3 = className;
                String string4 = "contact";
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    this.stdInfoMap.put((Object)key, this.entityDao.unique((QueryBuilder)OqlBuilder$.MODULE$.from(Contact.class, "contact").where("contact.std = :student", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{student}))));
                } else {
                    String string5 = className;
                    String string6 = "home";
                    if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                        this.stdInfoMap.put((Object)key, this.entityDao.unique((QueryBuilder)OqlBuilder$.MODULE$.from(Home.class, "home").where("home.std = :student", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{student}))));
                    } else {
                        String string7 = className;
                        String string8 = "examinee";
                        if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                            this.stdInfoMap.put((Object)key, this.entityDao.unique((QueryBuilder)OqlBuilder$.MODULE$.from(Examinee.class, "examinee").where("examinee.std = :student", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{student}))));
                        }
                    }
                }
            }
        }
        return this.stdInfoMap.get((Object)key).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }
}

