/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.course.model;

import java.io.Serializable;
import java.time.Instant;
import org.beangle.commons.collection.Collections$;
import org.beangle.data.model.LongId;
import org.beangle.data.model.pojo.Remark;
import org.beangle.data.model.pojo.Updated;
import org.openurp.base.edu.ProjectBased;
import org.openurp.base.edu.code.model.CourseType;
import org.openurp.base.edu.model.Course;
import org.openurp.base.edu.model.Project;
import org.openurp.base.edu.model.Semester;
import org.openurp.base.edu.model.Student;
import org.openurp.code.edu.model.CourseTakeType;
import org.openurp.code.edu.model.ExamMode;
import org.openurp.code.edu.model.GradeType;
import org.openurp.code.edu.model.GradeType$;
import org.openurp.code.edu.model.GradingMode;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.grade.course.model.ExamGrade;
import org.openurp.edu.grade.course.model.GaGrade;
import org.openurp.edu.grade.model.Grade;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.mutable.Buffer;
import scala.math.Ordered;
import scala.runtime.BoxesRunTime;

public class CourseGrade
extends LongId
implements ProjectBased,
Ordered,
Updated,
Grade,
Remark {
    private Project project;
    private Instant updatedAt;
    private Instant createdAt;
    private Option remark;
    private Student std;
    private Course course;
    private CourseTakeType courseTakeType;
    private Semester semester;
    private String crn;
    private CourseType courseType;
    private Option gp;
    private boolean freeListening;
    private Buffer gaGrades;
    private Buffer examGrades;
    private ExamMode examMode;
    private Option score;
    private Option scoreText;
    private boolean passed;
    private int status;
    private GradingMode gradingMode;
    private Option operator;
    private Option clazz;

    public CourseGrade() {
        ProjectBased.$init$((ProjectBased)this);
        Ordered.$init$((Ordered)this);
        Updated.$init$((Updated)this);
        Grade.$init$(this);
        Remark.$init$((Remark)this);
        this.gp = None$.MODULE$;
        this.freeListening = false;
        this.gaGrades = Collections$.MODULE$.newBuffer();
        this.examGrades = Collections$.MODULE$.newBuffer();
        this.score = None$.MODULE$;
        this.scoreText = None$.MODULE$;
        this.operator = None$.MODULE$;
        this.clazz = None$.MODULE$;
    }

    public Project project() {
        return this.project;
    }

    public void project_$eq(Project x$1) {
        this.project = x$1;
    }

    public Instant updatedAt() {
        return this.updatedAt;
    }

    public void updatedAt_$eq(Instant x$1) {
        this.updatedAt = x$1;
    }

    @Override
    public Instant createdAt() {
        return this.createdAt;
    }

    @Override
    public void createdAt_$eq(Instant x$1) {
        this.createdAt = x$1;
    }

    public Option remark() {
        return this.remark;
    }

    public void remark_$eq(Option x$1) {
        this.remark = x$1;
    }

    @Override
    public Student std() {
        return this.std;
    }

    public void std_$eq(Student x$1) {
        this.std = x$1;
    }

    public Course course() {
        return this.course;
    }

    public void course_$eq(Course x$1) {
        this.course = x$1;
    }

    public CourseTakeType courseTakeType() {
        return this.courseTakeType;
    }

    public void courseTakeType_$eq(CourseTakeType x$1) {
        this.courseTakeType = x$1;
    }

    public Semester semester() {
        return this.semester;
    }

    public void semester_$eq(Semester x$1) {
        this.semester = x$1;
    }

    public String crn() {
        return this.crn;
    }

    public void crn_$eq(String x$1) {
        this.crn = x$1;
    }

    public CourseType courseType() {
        return this.courseType;
    }

    public void courseType_$eq(CourseType x$1) {
        this.courseType = x$1;
    }

    public Option<Object> gp() {
        return this.gp;
    }

    public void gp_$eq(Option<Object> x$1) {
        this.gp = x$1;
    }

    public boolean freeListening() {
        return this.freeListening;
    }

    public void freeListening_$eq(boolean x$1) {
        this.freeListening = x$1;
    }

    public Buffer<GaGrade> gaGrades() {
        return this.gaGrades;
    }

    public void gaGrades_$eq(Buffer<GaGrade> x$1) {
        this.gaGrades = x$1;
    }

    public Buffer<ExamGrade> examGrades() {
        return this.examGrades;
    }

    public void examGrades_$eq(Buffer<ExamGrade> x$1) {
        this.examGrades = x$1;
    }

    public ExamMode examMode() {
        return this.examMode;
    }

    public void examMode_$eq(ExamMode x$1) {
        this.examMode = x$1;
    }

    @Override
    public Option<Object> score() {
        return this.score;
    }

    @Override
    public void score_$eq(Option<Object> x$1) {
        this.score = x$1;
    }

    @Override
    public Option<String> scoreText() {
        return this.scoreText;
    }

    @Override
    public void scoreText_$eq(Option<String> x$1) {
        this.scoreText = x$1;
    }

    @Override
    public boolean passed() {
        return this.passed;
    }

    @Override
    public void passed_$eq(boolean x$1) {
        this.passed = x$1;
    }

    @Override
    public int status() {
        return this.status;
    }

    @Override
    public void status_$eq(int x$1) {
        this.status = x$1;
    }

    @Override
    public GradingMode gradingMode() {
        return this.gradingMode;
    }

    @Override
    public void gradingMode_$eq(GradingMode x$1) {
        this.gradingMode = x$1;
    }

    @Override
    public Option<String> operator() {
        return this.operator;
    }

    @Override
    public void operator_$eq(Option<String> x$1) {
        this.operator = x$1;
    }

    public Option<Clazz> clazz() {
        return this.clazz;
    }

    public void clazz_$eq(Option<Clazz> x$1) {
        this.clazz = x$1;
    }

    public Option<Grade> getGrade(GradeType gradeType) {
        return gradeType.isGa() ? this.gaGrades().find((Function1 & Serializable)eg -> {
            GradeType gradeType = eg.gradeType();
            GradeType gradeType2 = gradeType;
            return !(gradeType != null ? !gradeType.equals(gradeType2) : gradeType2 != null);
        }) : this.examGrades().find((Function1 & Serializable)eg -> {
            GradeType gradeType = eg.gradeType();
            GradeType gradeType2 = gradeType;
            return !(gradeType != null ? !gradeType.equals(gradeType2) : gradeType2 != null);
        });
    }

    public Option<ExamGrade> getExamGrade(GradeType gt) {
        if (gt.isGa()) {
            throw new RuntimeException("" + gt.id() + " is not exam grade type");
        }
        return this.examGrades().find((Function1 & Serializable)eg -> {
            GradeType gradeType = eg.gradeType();
            GradeType gradeType2 = gt;
            return !(gradeType != null ? !gradeType.equals(gradeType2) : gradeType2 != null);
        });
    }

    public Option<GaGrade> getGaGrade(GradeType gt) {
        if (!gt.isGa()) {
            throw new RuntimeException("" + gt.id() + " is not ga grade type");
        }
        return this.gaGrades().find((Function1 & Serializable)eg -> {
            GradeType gradeType = eg.gradeType();
            GradeType gradeType2 = gt;
            return !(gradeType != null ? !gradeType.equals(gradeType2) : gradeType2 != null);
        });
    }

    public Option<String> getScoreText(GradeType gt) {
        Option<String> option;
        Option<Grade> option2 = this.getGrade(gt);
        if (None$.MODULE$.equals(option2)) {
            option = None$.MODULE$;
        } else if (option2 instanceof Some) {
            Grade g = (Grade)((Some)option2).value();
            option = g.scoreText();
        } else {
            throw new MatchError(option2);
        }
        return option;
    }

    public CourseGrade addExamGrade(ExamGrade examGrade) {
        this.examGrades().$plus$eq((Object)examGrade);
        examGrade.courseGrade_$eq(this);
        return this;
    }

    public CourseGrade addGaGrade(GaGrade gaGrade) {
        this.gaGrades().$plus$eq((Object)gaGrade);
        gaGrade.courseGrade_$eq(this);
        return this;
    }

    @Override
    public GradeType gradeType() {
        return new GradeType(GradeType$.MODULE$.Final());
    }

    public int compare(Grade grade) {
        if (this.score().isEmpty()) {
            return 1;
        }
        if (grade.score().isEmpty()) {
            return -1;
        }
        return Predef$.MODULE$.float2Float(BoxesRunTime.unboxToFloat((Object)grade.score().get())).compareTo(Predef$.MODULE$.float2Float(BoxesRunTime.unboxToFloat((Object)this.score().get())));
    }
}

