/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.course.model;

import java.io.Serializable;
import java.time.Instant;
import org.beangle.data.model.LongId;
import org.beangle.data.model.pojo.Updated;
import org.openurp.base.model.Project;
import org.openurp.base.model.ProjectBased;
import org.openurp.base.model.Semester;
import org.openurp.base.std.model.Student;
import org.openurp.edu.grade.course.model.GpaStat;
import org.openurp.edu.grade.course.model.StdSemesterGpa;
import org.openurp.edu.grade.course.model.StdYearGpa;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxesRunTime;

public class StdGpa
extends LongId
implements Updated,
ProjectBased,
GpaStat {
    private Instant updatedAt;
    private Project project;
    private float gpa;
    private float ga;
    private float totalCredits;
    private float credits;
    private int gradeCount;
    private Student std;
    private Buffer semesterGpas;
    private Buffer yearGpas;
    private transient Map<Semester, StdSemesterGpa> semesterGpaCache;
    private transient Map<String, StdYearGpa> yearGpaCache;

    public StdGpa() {
        Updated.$init$((Updated)this);
        ProjectBased.$init$((ProjectBased)this);
        GpaStat.$init$(this);
        this.semesterGpas = new ListBuffer();
        this.yearGpas = new ListBuffer();
    }

    public Instant updatedAt() {
        return this.updatedAt;
    }

    public void updatedAt_$eq(Instant x$1) {
        this.updatedAt = x$1;
    }

    public Project project() {
        return this.project;
    }

    public void project_$eq(Project x$1) {
        this.project = x$1;
    }

    @Override
    public float gpa() {
        return this.gpa;
    }

    @Override
    public float ga() {
        return this.ga;
    }

    @Override
    public float totalCredits() {
        return this.totalCredits;
    }

    @Override
    public float credits() {
        return this.credits;
    }

    @Override
    public int gradeCount() {
        return this.gradeCount;
    }

    @Override
    public void gpa_$eq(float x$1) {
        this.gpa = x$1;
    }

    @Override
    public void ga_$eq(float x$1) {
        this.ga = x$1;
    }

    @Override
    public void totalCredits_$eq(float x$1) {
        this.totalCredits = x$1;
    }

    @Override
    public void credits_$eq(float x$1) {
        this.credits = x$1;
    }

    @Override
    public void gradeCount_$eq(int x$1) {
        this.gradeCount = x$1;
    }

    public Student std() {
        return this.std;
    }

    public void std_$eq(Student x$1) {
        this.std = x$1;
    }

    public Buffer<StdSemesterGpa> semesterGpas() {
        return this.semesterGpas;
    }

    public void semesterGpas_$eq(Buffer<StdSemesterGpa> x$1) {
        this.semesterGpas = x$1;
    }

    public Buffer<StdYearGpa> yearGpas() {
        return this.yearGpas;
    }

    public void yearGpas_$eq(Buffer<StdYearGpa> x$1) {
        this.yearGpas = x$1;
    }

    public StdGpa(long id) {
        this();
        this.id_$eq(BoxesRunTime.boxToLong((long)id));
    }

    public StdGpa(Student std) {
        this();
        this.std_$eq(std);
        this.semesterGpas_$eq((Buffer<StdSemesterGpa>)new ListBuffer());
        this.yearGpas_$eq((Buffer<StdYearGpa>)new ListBuffer());
        this.credits_$eq(0.0f);
        this.gradeCount_$eq(0);
        this.ga_$eq(0.0f);
        this.gpa_$eq(0.0f);
    }

    public float getGpa(Semester semester) {
        StdSemesterGpa gpterm = this.getStdTermGpa(semester);
        return gpterm == null ? 0.0f : gpterm.gpa();
    }

    public StdSemesterGpa getStdTermGpa(Semester semester) {
        if (this.semesterGpaCache == null || this.semesterGpaCache.size() != this.semesterGpas().size()) {
            this.semesterGpaCache = ((IterableOnceOps)this.semesterGpas().map((Function1 & Serializable)f -> Tuple2$.MODULE$.apply((Object)f.semester(), f))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        return (StdSemesterGpa)this.semesterGpaCache.get((Object)semester).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public StdYearGpa getYearGpa(String schoolYear) {
        if (this.yearGpaCache == null || this.yearGpaCache.size() != this.yearGpas().size()) {
            this.yearGpaCache = ((IterableOnceOps)this.yearGpas().map((Function1 & Serializable)f -> Tuple2$.MODULE$.apply((Object)f.schoolYear(), f))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        return (StdYearGpa)this.yearGpaCache.get((Object)schoolYear).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public void add(StdSemesterGpa stdTermGpa) {
        stdTermGpa.stdGpa_$eq(this);
        this.semesterGpas().$plus$eq((Object)stdTermGpa);
    }

    public void add(StdYearGpa stdYearGpa) {
        stdYearGpa.stdGpa_$eq(this);
        this.yearGpas().$plus$eq((Object)stdYearGpa);
    }
}

