/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.domain;

import java.io.Serializable;
import org.beangle.data.dao.EntityDao;
import org.openurp.base.edu.code.model.StdType;
import org.openurp.base.model.Campus;
import org.openurp.base.model.Department;
import org.openurp.base.std.model.Student;
import org.openurp.base.std.model.StudentState;
import org.openurp.edu.program.domain.CoursePlanProvider;
import org.openurp.edu.program.domain.ProgramProvider;
import org.openurp.edu.program.model.CoursePlan;
import org.openurp.edu.program.model.ExecutionPlan;
import org.openurp.edu.program.model.MajorPlan;
import org.openurp.edu.program.model.Program;
import org.openurp.edu.program.model.StdPlan;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ScalaRunTime$;

public class DefaultCoursePlanProvider
implements CoursePlanProvider {
    private ProgramProvider programProvider;
    private EntityDao entityDao;

    public ProgramProvider programProvider() {
        return this.programProvider;
    }

    public void programProvider_$eq(ProgramProvider x$1) {
        this.programProvider = x$1;
    }

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    @Override
    public Option<MajorPlan> getMajorPlan(Student student) {
        Option<MajorPlan> option;
        Option<Program> option2 = this.programProvider().getProgram(student);
        if (option2 instanceof Some) {
            Program p = (Program)((Some)option2).value();
            option = this.getMajorPlan(p);
        } else if (None$.MODULE$.equals(option2)) {
            option = None$.MODULE$;
        } else {
            throw new MatchError(option2);
        }
        return option;
    }

    @Override
    public Option<ExecutionPlan> getExecutionPlan(Student student) {
        Option<ExecutionPlan> option;
        Option<Program> option2 = this.programProvider().getProgram(student);
        if (option2 instanceof Some) {
            Program p = (Program)((Some)option2).value();
            option = this.getExecutionPlan(p, student);
        } else if (None$.MODULE$.equals(option2)) {
            option = None$.MODULE$;
        } else {
            throw new MatchError(option2);
        }
        return option;
    }

    @Override
    public Option<StdPlan> getStdPlan(Student student) {
        return this.entityDao().findBy(StdPlan.class, "std", package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Student[]{student}))).headOption();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Option<CoursePlan> getCoursePlan(Student std) {
        Some some;
        Option<StdPlan> option = this.getStdPlan(std);
        if (option instanceof Some) {
            StdPlan stdPlan = (StdPlan)((Some)option).value();
            some = Some$.MODULE$.apply((Object)stdPlan);
            return some;
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            Option<Program> option2 = this.programProvider().getProgram(std);
            if (option2 instanceof Some) {
                Program p = (Program)((Some)option2).value();
                some = this.getExecutionPlan(p, std).orElse(() -> this.getCoursePlan$$anonfun$1(p));
                return some;
            } else {
                if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                some = None$.MODULE$;
            }
        }
        return some;
    }

    private Option<MajorPlan> getMajorPlan(Program p) {
        return this.entityDao().findBy(MajorPlan.class, "program", package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Program[]{p}))).headOption();
    }

    private Option<ExecutionPlan> getExecutionPlan(Program p2, Student student) {
        Seq plans = this.entityDao().findBy(ExecutionPlan.class, "program", package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Program[]{p2})));
        Seq matched = (Seq)plans.filter((Function1 & Serializable)p -> {
            Department department = p.department();
            Department department2 = ((StudentState)student.state().get()).department();
            if (department == null) {
                if (department2 != null) {
                    return false;
                }
            } else if (!department.equals(department2)) return false;
            if (!p.stdType().isEmpty()) {
                Object object = p.stdType().get();
                StdType stdType = student.stdType();
                if (object == null) {
                    if (stdType != null) {
                        return false;
                    }
                } else if (!object.equals(stdType)) return false;
            }
            if (p.campus().isEmpty()) return true;
            Object object = p.campus().get();
            Campus campus = ((StudentState)student.state().get()).campus();
            if (object == null) {
                if (campus == null) return true;
                return false;
            } else {
                if (!object.equals(campus)) return false;
                return true;
            }
        });
        return matched.headOption();
    }

    private final Option getCoursePlan$$anonfun$1(Program p$1) {
        return this.getMajorPlan(p$1);
    }
}

