/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.room.model;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.lang.time.WeekDay;
import org.beangle.commons.lang.time.WeekDay$;
import org.beangle.commons.lang.time.WeekTime;
import org.beangle.data.model.Component;
import org.beangle.data.model.pojo.DateRange;
import org.openurp.edu.room.model.CycleTime;
import org.openurp.edu.room.model.CycleTime$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class TimeRequest
implements Component,
DateRange {
    private LocalDate beginOn;
    private LocalDate endOn;
    private int minutes;
    private Option timeComment;
    private Buffer times;

    public TimeRequest() {
        DateRange.$init$((DateRange)this);
        this.minutes = 0;
        this.timeComment = None$.MODULE$;
        this.times = Collections$.MODULE$.newBuffer();
    }

    public LocalDate beginOn() {
        return this.beginOn;
    }

    public LocalDate endOn() {
        return this.endOn;
    }

    public void beginOn_$eq(LocalDate x$1) {
        this.beginOn = x$1;
    }

    public void endOn_$eq(LocalDate x$1) {
        this.endOn = x$1;
    }

    public int minutes() {
        return this.minutes;
    }

    public void minutes_$eq(int x$1) {
        this.minutes = x$1;
    }

    public Option<String> timeComment() {
        return this.timeComment;
    }

    public void timeComment_$eq(Option<String> x$1) {
        this.timeComment = x$1;
    }

    public Buffer<WeekTime> times() {
        return this.times;
    }

    public void times_$eq(Buffer<WeekTime> x$1) {
        this.times = x$1;
    }

    public void calcMinutes() {
        IntRef mins = IntRef.create((int)0);
        this.times().foreach((Function1)(JProcedure1 & Serializable)time -> {
            int n;
            int daymins = time.endAt().interval(time.beginAt());
            int count = time.weekstate().size();
            mins$1.elem = n = mins$1.elem + daymins * count;
        });
        this.minutes_$eq(mins.elem);
    }

    public String toString() {
        Buffer timeList = Collections$.MODULE$.newBuffer();
        ((SeqOps)this.times().sortBy((Function1 & Serializable)_$15 -> _$15.startOn(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).sortBy((Function1 & Serializable)_$16 -> _$16.beginAt(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        DateTimeFormatter format2 = DateTimeFormatter.ofPattern("MM-dd");
        Buffer dates = Collections$.MODULE$.newBuffer();
        if (this.times().nonEmpty()) {
            this.times().foreach((Function1)(JProcedure1 & Serializable)time -> time.dates().foreach((Function1)(JProcedure1 & Serializable)d -> {
                CycleTime cd = null;
                Iterator datesIter = dates.iterator();
                while (datesIter.hasNext() && cd == null) {
                    CycleTime cd1 = (CycleTime)datesIter.next();
                    int days = (int)cd1.endOn().until((Temporal)d, ChronoUnit.DAYS);
                    int minus_time = time.endAt().minute() - cd1.endAt().minute();
                    if (days % 7 != 0 || minus_time != 0) continue;
                    if (cd1.isOneDay()) {
                        cd1.endOn_$eq((LocalDate)d);
                        cd = cd1;
                        continue;
                    }
                    if (days != cd1.getCycleDays()) continue;
                    cd1.endOn_$eq((LocalDate)d);
                    cd = cd1;
                }
                if (cd == null) {
                    dates.$plus$eq((Object)CycleTime$.MODULE$.apply((LocalDate)d, time.beginAt(), time.endAt()));
                    return;
                }
            }));
            dates.foreach((Function1 & Serializable)cd -> {
                StringBuilder sb = new StringBuilder();
                if (cd.isOneDay()) {
                    v0 = sb.append(cd.endOn().format(format));
                } else {
                    sb.append(cd.beginOn().format(format));
                    sb.append("~");
                    StringBuilder stringBuilder = cd.beginOn().getYear() == cd.endOn().getYear() ? sb.append("").append(cd.endOn().format(format2)) : sb.append("").append(cd.endOn().format(format));
                    StringBuilder stringBuilder2 = Predef$.MODULE$.int2Integer(cd.cycleCount()) != 1 ? sb.append(" \u6bcf" + cd.cycleCount() + "\u5468\u5468") : sb.append(" \u6bcf\u5468");
                    Object[] objectArray = new Tuple2[7];
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"Mon");
                    objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"\u4e00");
                    String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Tue");
                    objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)"\u4e8c");
                    String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Wed");
                    objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)"\u4e09");
                    String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Thu");
                    objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)"\u56db");
                    String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Fri");
                    objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)"\u4e94");
                    String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Sat");
                    objectArray[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)"\u516d");
                    String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Sun");
                    objectArray[6] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, (Object)"\u65e5");
                    Map wMap = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                    WeekDay wd = WeekDay$.MODULE$.of(cd.beginOn());
                    v0 = sb.append(Strings$.MODULE$.replace((String)wMap.get((Object)wd.toString()).get(), "\u661f\u671f", ""));
                }
                sb.append(" ");
                sb.append((Object)cd.beginAt());
                sb.append("~");
                sb.append((Object)cd.endAt());
                return (Buffer)timeList.$plus$eq((Object)sb.toString());
            });
            return Strings$.MODULE$.join((Iterable)timeList, "<br>");
        }
        return "";
    }
}

