/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.clazz.domain;

import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.LocalDate;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Numbers$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.lang.time.WeekDay;
import org.beangle.commons.lang.time.WeekDay$;
import org.beangle.commons.lang.time.WeekState;
import org.beangle.commons.lang.time.WeekState$;
import org.beangle.commons.lang.time.WeekTime;
import org.beangle.commons.lang.time.WeekTime$;
import org.beangle.commons.lang.time.Weeks$;
import org.openurp.base.model.Semester;
import org.openurp.edu.clazz.domain.NumSeqParser$;
import org.openurp.edu.clazz.domain.WeekTimeBuilder;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Map;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;

public final class WeekTimeBuilder$
implements Serializable {
    public static final WeekTimeBuilder$ MODULE$ = new WeekTimeBuilder$();

    private WeekTimeBuilder$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(WeekTimeBuilder$.class);
    }

    public Iterable<WeekTime> build(Semester semester, String weekSpan) {
        IntRef startWeek = IntRef.create((int)0);
        IntRef endWeek = IntRef.create((int)0);
        if (weekSpan.contains("-")) {
            int n;
            int n2;
            startWeek.elem = n2 = Predef$.MODULE$.Integer2int(Integer.valueOf(Strings$.MODULE$.substringBefore(weekSpan, "-")));
            endWeek.elem = n = Predef$.MODULE$.Integer2int(Integer.valueOf(Strings$.MODULE$.substringAfter(weekSpan, "-")));
        } else if ("*".equals(weekSpan)) {
            int n;
            int n3;
            startWeek.elem = n3 = 1;
            endWeek.elem = n = semester.weeks();
        } else if (Numbers$.MODULE$.isDigits(weekSpan)) {
            int n;
            int n4;
            endWeek.elem = n4 = (startWeek.elem = (n = Predef$.MODULE$.Integer2int(Integer.valueOf(weekSpan))));
        }
        if (0 == startWeek.elem) {
            int n;
            startWeek.elem = n = 1;
        }
        if (0 == endWeek.elem) {
            int n;
            endWeek.elem = n = startWeek.elem;
        }
        if (startWeek.elem < 1) {
            int n;
            startWeek.elem = n = 1;
        }
        if (endWeek.elem > semester.weeks()) {
            int n;
            endWeek.elem = n = semester.weeks();
        }
        ArrayBuffer weektimes = new ArrayBuffer();
        Object object = Predef$.MODULE$.refArrayOps((Object[])WeekDay$.MODULE$.values());
        ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)wd -> weektimes.addAll(this.on(semester).build((WeekDay)wd, (Iterable<Object>)package$.MODULE$.Range().apply(startWeek$1.elem, endWeek$1.elem + 1))));
        return weektimes;
    }

    public Seq<WeekTime> build(LocalDate beginOn, LocalDate endOn, int dayInterval) {
        Map timeMap = Collections$.MODULE$.newMap();
        LocalDate newBeginOn = beginOn;
        while (!newBeginOn.isAfter(endOn)) {
            WeekTime t = WeekTime$.MODULE$.of(newBeginOn);
            Option option = timeMap.get((Object)t.startOn());
            if (option instanceof Some) {
                WeekTime existed = (WeekTime)((Some)option).value();
                existed.weekstate_$eq(existed.weekstate().$bar(t.weekstate()));
                v0 = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                v0 = timeMap.put((Object)t.startOn(), (Object)t);
            } else {
                throw new MatchError((Object)option);
            }
            newBeginOn = newBeginOn.plusDays(Int$.MODULE$.int2long(dayInterval));
        }
        Seq times = (Seq)timeMap.values().toSeq().sortBy((Function1 & Serializable)x -> x.startOn(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        return times;
    }

    public WeekTimeBuilder on(Semester semester) {
        return new WeekTimeBuilder(semester.beginOn(), semester.calendar().firstWeekday());
    }

    public String digest(WeekTime time, Semester semester) {
        if (time == null) {
            return "";
        }
        DayOfWeek dayofWeek = DayOfWeek.of(time.weekday().id());
        DayOfWeek firstDay = DayOfWeek.of(semester.calendar().firstWeekday().id());
        LocalDate beginOn = this.toDay(firstDay, semester.beginOn(), dayofWeek);
        LocalDate timeBeginOn = time.startOn();
        int weeksDistance = Weeks$.MODULE$.between(beginOn, timeBeginOn);
        long weekstate = time.weekstate().value();
        weekstate = weeksDistance < 0 ? (weekstate >>= 0 - weeksDistance) : (weekstate <<= weeksDistance);
        int[] weekIndecies = (int[])new WeekState(weekstate).weeks().toArray(ClassTag$.MODULE$.apply(Integer.TYPE));
        Iterable seqs = (Iterable)NumSeqParser$.MODULE$.digest(weekIndecies).map((Function1 & Serializable)s -> {
            if (s.step() == 1) {
                if (s.start() == s.end()) {
                    return BoxesRunTime.boxToInteger((int)s.start()).toString();
                }
                return s.start() + "-" + s.end();
            }
            if (s.step() == 2) {
                if (s.start() % 2 == 1) {
                    return s.start() + "-" + s.end() + "\u5355";
                }
                return s.start() + "-" + s.end() + "\u53cc";
            }
            return s.toString();
        });
        return seqs.mkString(" ");
    }

    public Buffer<WeekTime> mergeTimes(Buffer<WeekTime> tobeMerged, int minGap) {
        if (tobeMerged.isEmpty()) {
            return tobeMerged;
        }
        Buffer mergedTimeUnits = Collections$.MODULE$.newBuffer();
        Iterator activityIter = tobeMerged.iterator();
        WeekTime toMerged = (WeekTime)activityIter.next();
        mergedTimeUnits.$plus$eq((Object)toMerged);
        while (activityIter.hasNext()) {
            WeekTime unit = (WeekTime)activityIter.next();
            if (toMerged.mergeable(unit, minGap)) {
                toMerged.merge(unit, minGap);
                continue;
            }
            toMerged = unit;
            mergedTimeUnits.$plus$eq((Object)toMerged);
        }
        return mergedTimeUnits;
    }

    public WeekState collect(Semester semester, Iterable<LocalDate> dates) {
        DayOfWeek dayofWeek = DayOfWeek.of(semester.calendar().firstWeekday().id());
        LocalDate semesterFirstday = this.toDay(dayofWeek, semester.beginOn(), dayofWeek);
        HashSet weeks = new HashSet();
        dates.foreach((Function1 & Serializable)date -> {
            LocalDate oneday = this.toDay(dayofWeek, (LocalDate)date, dayofWeek);
            int weekIdx = 1 + Weeks$.MODULE$.between(semesterFirstday, oneday);
            return weeks.add((Object)BoxesRunTime.boxToInteger((int)weekIdx));
        });
        return WeekState$.MODULE$.of((Iterable)weeks);
    }

    private LocalDate toDay(DayOfWeek firstDay, LocalDate date, DayOfWeek day) {
        if (date.getDayOfWeek() == day) {
            return date;
        }
        if (firstDay == DayOfWeek.MONDAY) {
            return date.plusDays(Int$.MODULE$.int2long(day.getValue() - date.getDayOfWeek().getValue()));
        }
        if (firstDay == DayOfWeek.SUNDAY) {
            if (day == DayOfWeek.SUNDAY) {
                return date.plusDays(Int$.MODULE$.int2long(day.getValue() - date.getDayOfWeek().getValue() - 7));
            }
            return date.plusDays(Int$.MODULE$.int2long(day.getValue() - date.getDayOfWeek().getValue()));
        }
        throw new RuntimeException("Cannot accept first day " + firstDay);
    }
}

