/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.model;

import java.io.Serializable;
import org.beangle.data.model.LongId;
import org.beangle.data.model.pojo.Hierarchical;
import org.beangle.data.model.pojo.Named;
import org.beangle.data.model.pojo.Remark;
import org.openurp.base.edu.model.Course;
import org.openurp.code.edu.model.CourseType;
import org.openurp.edu.grade.domain.GroupResultAdapter;
import org.openurp.edu.grade.model.AuditStat;
import org.openurp.edu.grade.model.CourseAuditResult;
import org.openurp.edu.grade.model.GroupAuditResult$;
import org.openurp.edu.grade.model.PlanAuditResult;
import org.openurp.edu.program.model.CourseGroup;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordered;
import scala.runtime.function.JProcedure1;

public class GroupAuditResult
extends LongId
implements Named,
Hierarchical<GroupAuditResult>,
Remark {
    private String name;
    private String indexno;
    private Option parent;
    private Buffer children;
    private Option remark;
    private AuditStat auditStat;
    private Buffer courseResults;
    private CourseType courseType;
    private boolean passed;
    private short subCount;
    private PlanAuditResult planResult;

    public GroupAuditResult() {
        Named.$init$((Named)this);
        Ordered.$init$((Ordered)this);
        Hierarchical.$init$((Hierarchical)this);
        Remark.$init$((Remark)this);
        this.auditStat = new AuditStat();
        this.courseResults = new ListBuffer();
    }

    public String name() {
        return this.name;
    }

    public void name_$eq(String x$1) {
        this.name = x$1;
    }

    public String indexno() {
        return this.indexno;
    }

    public Option parent() {
        return this.parent;
    }

    public Buffer children() {
        return this.children;
    }

    public void indexno_$eq(String x$1) {
        this.indexno = x$1;
    }

    public void parent_$eq(Option x$1) {
        this.parent = x$1;
    }

    public void children_$eq(Buffer x$1) {
        this.children = x$1;
    }

    public Option remark() {
        return this.remark;
    }

    public void remark_$eq(Option x$1) {
        this.remark = x$1;
    }

    public AuditStat auditStat() {
        return this.auditStat;
    }

    public void auditStat_$eq(AuditStat x$1) {
        this.auditStat = x$1;
    }

    public Buffer<CourseAuditResult> courseResults() {
        return this.courseResults;
    }

    public void courseResults_$eq(Buffer<CourseAuditResult> x$1) {
        this.courseResults = x$1;
    }

    public CourseType courseType() {
        return this.courseType;
    }

    public void courseType_$eq(CourseType x$1) {
        this.courseType = x$1;
    }

    public boolean passed() {
        return this.passed;
    }

    public void passed_$eq(boolean x$1) {
        this.passed = x$1;
    }

    public short subCount() {
        return this.subCount;
    }

    public void subCount_$eq(short x$1) {
        this.subCount = x$1;
    }

    public PlanAuditResult planResult() {
        return this.planResult;
    }

    public void planResult_$eq(PlanAuditResult x$1) {
        this.planResult = x$1;
    }

    public void attachTo(PlanAuditResult pl) {
        this.planResult_$eq(pl);
        this.planResult().groupResults().$plus$eq((Object)this);
        this.children().foreach((Function1)(JProcedure1 & Serializable)groupResult -> groupResult.attachTo(this.planResult()));
    }

    public void detach() {
        if (this.planResult() != null) {
            this.planResult().groupResults().$minus$eq((Object)this);
        }
        this.planResult_$eq(null);
        this.children().foreach((Function1)(JProcedure1 & Serializable)groupResult -> groupResult.detach());
    }

    public GroupAuditResult(CourseGroup group) {
        this();
        this.name_$eq(group.name());
        this.courseType_$eq(group.courseType());
    }

    public GroupAuditResult SuperResult() {
        if (this.planResult() != null) {
            return new GroupResultAdapter(this.planResult());
        }
        return null;
    }

    public void addCourseResult(CourseAuditResult courseResult) {
        courseResult.groupResult_$eq(this);
        this.courseResults().$plus$eq((Object)courseResult);
        if (courseResult.passed()) {
            this.addPassedCourse(this, courseResult.course());
            return;
        }
    }

    public void updateCourseResult(CourseAuditResult rs) {
        if (rs.passed()) {
            this.addPassedCourse(rs.groupResult(), rs.course());
            return;
        }
    }

    private void addPassedCourse(GroupAuditResult groupResult, Course course) {
        Option option;
        while (true) {
            GroupAuditResult p;
            if (groupResult == null) {
                return;
            }
            AuditStat auditStat = groupResult.auditStat();
            if (!auditStat.passedCourses().contains((Object)course)) {
                auditStat.passedCourses().add((Object)course);
                auditStat.addCredits(course.getCredits(groupResult.planResult().std().level()));
                auditStat.addNum(1);
            }
            if (None$.MODULE$.equals(option = groupResult.parent())) {
                AuditStat planAuditStat = groupResult.planResult().auditStat();
                if (!planAuditStat.passedCourses().contains((Object)course)) {
                    planAuditStat.passedCourses().add((Object)course);
                    planAuditStat.addCredits(course.getCredits(groupResult.planResult().std().level()));
                    planAuditStat.addNum(1);
                    return;
                }
                return;
            }
            if (!(option instanceof Some)) break;
            groupResult = p = (GroupAuditResult)((Object)((Some)option).value());
        }
        throw new MatchError((Object)option);
    }

    public void addChild(GroupAuditResult gr) {
        gr.parent_$eq((Option)Some$.MODULE$.apply((Object)this));
        this.children().$plus$eq((Object)gr);
    }

    public void removeChild(GroupAuditResult gr) {
        gr.parent_$eq(null);
        this.children().$minus$eq((Object)gr);
    }

    public void checkPassed(boolean isRecursive) {
        GroupAuditResult$.MODULE$.checkPassed(this, isRecursive);
    }
}

