/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.course.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Locale;
import org.beangle.commons.collection.Collections$;
import org.beangle.data.model.LongId;
import org.beangle.data.model.pojo.Updated;
import org.openurp.base.edu.model.TeachingOffice;
import org.openurp.base.model.AuditStatus;
import org.openurp.base.model.AuditStatus$;
import org.openurp.base.model.Semester;
import org.openurp.base.model.User;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.course.model.Lesson;
import org.openurp.edu.course.model.TeachingPlanSection;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxesRunTime;

public class TeachingPlan
extends LongId
implements Updated {
    private Instant updatedAt;
    private Clazz clazz;
    private Locale docLocale;
    private Semester semester;
    private Buffer sections;
    private Buffer lessons;
    private Option filePath;
    private Option office;
    private AuditStatus status;
    private Option writer;
    private Option reviewer;
    private Option approver;
    private Option publishAt;

    public TeachingPlan() {
        Updated.$init$((Updated)this);
        this.sections = Collections$.MODULE$.newBuffer();
        this.lessons = Collections$.MODULE$.newBuffer();
        this.filePath = None$.MODULE$;
        this.office = None$.MODULE$;
        this.status = AuditStatus$.Draft;
        this.writer = None$.MODULE$;
        this.reviewer = None$.MODULE$;
        this.approver = None$.MODULE$;
        this.publishAt = None$.MODULE$;
    }

    public Instant updatedAt() {
        return this.updatedAt;
    }

    public void updatedAt_$eq(Instant x$1) {
        this.updatedAt = x$1;
    }

    public Clazz clazz() {
        return this.clazz;
    }

    public void clazz_$eq(Clazz x$1) {
        this.clazz = x$1;
    }

    public Locale docLocale() {
        return this.docLocale;
    }

    public void docLocale_$eq(Locale x$1) {
        this.docLocale = x$1;
    }

    public Semester semester() {
        return this.semester;
    }

    public void semester_$eq(Semester x$1) {
        this.semester = x$1;
    }

    public Buffer<TeachingPlanSection> sections() {
        return this.sections;
    }

    public void sections_$eq(Buffer<TeachingPlanSection> x$1) {
        this.sections = x$1;
    }

    public Buffer<Lesson> lessons() {
        return this.lessons;
    }

    public void lessons_$eq(Buffer<Lesson> x$1) {
        this.lessons = x$1;
    }

    public Option<String> filePath() {
        return this.filePath;
    }

    public void filePath_$eq(Option<String> x$1) {
        this.filePath = x$1;
    }

    public Option<TeachingOffice> office() {
        return this.office;
    }

    public void office_$eq(Option<TeachingOffice> x$1) {
        this.office = x$1;
    }

    public AuditStatus status() {
        return this.status;
    }

    public void status_$eq(AuditStatus x$1) {
        this.status = x$1;
    }

    public Option<User> writer() {
        return this.writer;
    }

    public void writer_$eq(Option<User> x$1) {
        this.writer = x$1;
    }

    public Option<User> reviewer() {
        return this.reviewer;
    }

    public void reviewer_$eq(Option<User> x$1) {
        this.reviewer = x$1;
    }

    public Option<User> approver() {
        return this.approver;
    }

    public void approver_$eq(Option<User> x$1) {
        this.approver = x$1;
    }

    public Option<Instant> publishAt() {
        return this.publishAt;
    }

    public void publishAt_$eq(Option<Instant> x$1) {
        this.publishAt = x$1;
    }

    public int getHours(String section) {
        return BoxesRunTime.unboxToInt((Object)((IterableOps)((IterableOps)this.sections().filter((Function1 & Serializable)_$4 -> {
            String string = _$4.name();
            String string2 = section;
            return !(string != null ? !string.equals(string2) : string2 != null);
        })).map((Function1 & Serializable)_$5 -> _$5.creditHours())).headOption().getOrElse(TeachingPlan::getHours$$anonfun$3));
    }

    public Option<Lesson> getLesson(int idx) {
        return this.lessons().find((Function1 & Serializable)_$6 -> _$6.idx() == idx);
    }

    public TeachingPlan(Clazz clazz) {
        this();
        this.clazz_$eq(clazz);
        this.semester_$eq(clazz.semester());
    }

    public void reserveSections(Iterable<String> names) {
        Set nameSet = names.toSet();
        Buffer removed = (Buffer)this.sections().filter((Function1 & Serializable)x -> !nameSet.contains((Object)x.name()));
        this.sections().subtractAll((IterableOnce)removed);
    }

    public void addSection(String name, int creditHours) {
        Option option = this.sections().find((Function1 & Serializable)_$7 -> {
            String string = _$7.name();
            String string2 = name;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
        if (None$.MODULE$.equals(option)) {
            TeachingPlanSection s = new TeachingPlanSection(this, name, creditHours);
            this.sections().addOne((Object)s);
            return;
        }
        if (option instanceof Some) {
            TeachingPlanSection s = (TeachingPlanSection)((Object)((Some)option).value());
            s.creditHours_$eq(creditHours);
            return;
        }
        throw new MatchError((Object)option);
    }

    public void copyTo(TeachingPlan p) {
        p.docLocale_$eq(this.docLocale());
        p.sections().clear();
        this.sections().foreach((Function1 & Serializable)h -> {
            TeachingPlanSection nh = new TeachingPlanSection();
            nh.plan_$eq(p);
            nh.name_$eq(h.name());
            nh.creditHours_$eq(h.creditHours());
            return (Buffer)p.sections().addOne((Object)nh);
        });
        p.lessons().clear();
        p.writer_$eq(this.writer());
        this.lessons().foreach((Function1 & Serializable)l -> {
            Lesson nl = new Lesson();
            nl.idx_$eq(l.idx());
            nl.contents_$eq(l.contents());
            nl.homework_$eq(l.homework());
            nl.learningHours_$eq(l.learningHours());
            nl.learning_$eq(l.learning());
            nl.forms_$eq(l.forms());
            nl.plan_$eq(p);
            return (Buffer)p.lessons().addOne((Object)nl);
        });
        p.updatedAt_$eq(Instant.now());
    }

    private static final int getHours$$anonfun$3() {
        return 0;
    }
}

