/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.domain;

import java.io.Serializable;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.openurp.base.edu.model.Course;
import org.openurp.base.std.model.Student;
import org.openurp.base.std.model.StudentState;
import org.openurp.edu.program.domain.CoursePlanProvider;
import org.openurp.edu.program.domain.DefaultProgramMatcher$;
import org.openurp.edu.program.domain.ProgramProvider;
import org.openurp.edu.program.model.CoursePlan;
import org.openurp.edu.program.model.ExecutivePlan;
import org.openurp.edu.program.model.MajorPlan;
import org.openurp.edu.program.model.PlanCourse;
import org.openurp.edu.program.model.Program;
import org.openurp.edu.program.model.SharePlan;
import org.openurp.edu.program.model.StdPlan;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class DefaultCoursePlanProvider
implements CoursePlanProvider {
    private ProgramProvider programProvider;
    private EntityDao entityDao;

    public ProgramProvider programProvider() {
        return this.programProvider;
    }

    public void programProvider_$eq(ProgramProvider x$1) {
        this.programProvider = x$1;
    }

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    @Override
    public Option<MajorPlan> getMajorPlan(Student student) {
        Option<Program> option = this.programProvider().getProgram(student);
        if (option instanceof Some) {
            Program p = (Program)((Some)option).value();
            return this.getMajorPlan(p);
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError(option);
    }

    @Override
    public Option<ExecutivePlan> getExecutivePlan(Student student) {
        Option<Program> option = this.programProvider().getProgram(student);
        if (option instanceof Some) {
            Program p = (Program)((Some)option).value();
            return this.getExecutivePlan(p, student);
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError(option);
    }

    @Override
    public Option<StdPlan> getStdPlan(Student student) {
        return this.entityDao().findBy(StdPlan.class, "std", package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Student[]{student}))).headOption();
    }

    @Override
    public Option<CoursePlan> getCoursePlan(Student std) {
        Option<StdPlan> option = this.getStdPlan(std);
        if (option instanceof Some) {
            StdPlan stdPlan = (StdPlan)((Some)option).value();
            return Some$.MODULE$.apply((Object)stdPlan);
        }
        if (None$.MODULE$.equals(option)) {
            Option<Program> option2 = this.programProvider().getProgram(std);
            if (option2 instanceof Some) {
                Program p = (Program)((Some)option2).value();
                return this.getExecutivePlan(p, std).orElse(() -> this.getCoursePlan$$anonfun$1(p));
            }
            if (None$.MODULE$.equals(option2)) {
                return None$.MODULE$;
            }
            throw new MatchError(option2);
        }
        throw new MatchError(option);
    }

    @Override
    public Option<SharePlan> getSharePlan(Student std) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(SharePlan.class, "sp");
        query.where("sp.project=:project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std.project()}));
        query.where("sp.level=:level and sp.eduType =:eduType", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std.level(), std.eduType()}));
        query.where(":grade between sp.fromGrade.code and sp.toGrade.code", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{((StudentState)std.state().get()).grade().code()}));
        query.cacheable(query.cacheable$default$1());
        return this.entityDao().search((QueryBuilder)query).headOption();
    }

    private Option<MajorPlan> getMajorPlan(Program p) {
        return this.entityDao().findBy(MajorPlan.class, "program", package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Program[]{p}))).headOption();
    }

    private Option<ExecutivePlan> getExecutivePlan(Program p2, Student student) {
        Seq plans = this.entityDao().findBy(ExecutivePlan.class, "program", package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Program[]{p2})));
        Seq matched = (Seq)plans.filter((Function1 & Serializable)p -> DefaultProgramMatcher$.MODULE$.departMatched(p.department(), ((StudentState)student.state().get()).department()));
        return matched.headOption();
    }

    @Override
    public Option<PlanCourse> getPlanCourse(Student std, Course course) {
        CoursePlan plan = (CoursePlan)this.getCoursePlan(std).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        ObjectRef planCourse = ObjectRef.create(null);
        if (plan != null) {
            plan.groups().withFilter((Function1 & Serializable)cg -> cg != null && (PlanCourse)planCourse$1.elem == null).foreach((Function1)(JProcedure1 & Serializable)cg -> cg.planCourses().find((Function1 & Serializable)_$3 -> {
                Course course = _$3.course();
                Course course2 = course;
                return !(course != null ? !course.equals(course2) : course2 != null);
            }).foreach((Function1)(JProcedure1 & Serializable)x -> {
                PlanCourse planCourse = x;
                planCourse$3.elem = planCourse;
                planCourse = null;
            }));
        }
        return Option$.MODULE$.apply((Object)((PlanCourse)planCourse.elem));
    }

    private final Option getCoursePlan$$anonfun$1(Program p$1) {
        return this.getMajorPlan(p$1);
    }
}

