/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.course.model;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Locale;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.model.LongId;
import org.beangle.data.model.pojo.TemporalOn;
import org.beangle.data.model.pojo.Updated;
import org.openurp.base.edu.model.Course;
import org.openurp.base.edu.model.Major;
import org.openurp.base.edu.model.TeachingOffice;
import org.openurp.base.edu.model.Textbook;
import org.openurp.base.model.AuditStatus;
import org.openurp.base.model.AuditStatus$;
import org.openurp.base.model.CalendarStage;
import org.openurp.base.model.Department;
import org.openurp.base.model.Semester;
import org.openurp.base.model.User;
import org.openurp.code.edu.model.CourseModule;
import org.openurp.code.edu.model.CourseNature;
import org.openurp.code.edu.model.CourseRank;
import org.openurp.code.edu.model.EducationLevel;
import org.openurp.code.edu.model.ExamMode;
import org.openurp.code.edu.model.GradeType;
import org.openurp.code.edu.model.GradeType$;
import org.openurp.code.edu.model.GradingMode;
import org.openurp.code.edu.model.TeachingNature;
import org.openurp.edu.course.model.SyllabusAssessment;
import org.openurp.edu.course.model.SyllabusCase;
import org.openurp.edu.course.model.SyllabusCreditHour;
import org.openurp.edu.course.model.SyllabusExamHour;
import org.openurp.edu.course.model.SyllabusExperiment;
import org.openurp.edu.course.model.SyllabusMethodDesign;
import org.openurp.edu.course.model.SyllabusObjective;
import org.openurp.edu.course.model.SyllabusOutcome;
import org.openurp.edu.course.model.SyllabusText;
import org.openurp.edu.course.model.SyllabusTopic;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BoxesRunTime;

public class Syllabus
extends LongId
implements Updated,
TemporalOn {
    private Instant updatedAt;
    private LocalDate beginOn;
    private Option endOn;
    private Course course;
    private Locale locale;
    private String description;
    private Semester semester;
    private Set levels;
    private Set majors;
    private int creditHours;
    private Buffer hours;
    private String methods;
    private int examCreditHours;
    private Buffer examHours;
    private float learningHours;
    private Option stage;
    private CourseModule module;
    private CourseRank rank;
    private CourseNature nature;
    private ExamMode examMode;
    private GradingMode gradingMode;
    private Option prerequisites;
    private Option corequisites;
    private Option subsequents;
    private Buffer objectives;
    private Buffer outcomes;
    private Buffer topics;
    private Buffer assessments;
    private Buffer textbooks;
    private Option bibliography;
    private Option materials;
    private Option website;
    private Buffer texts;
    private Buffer designs;
    private Buffer cases;
    private Buffer experiments;
    private Department department;
    private Option office;
    private AuditStatus status;
    private User writer;
    private Option reviewer;
    private Option approver;
    private Option publishAt;

    public Syllabus() {
        Updated.$init$((Updated)this);
        TemporalOn.$init$((TemporalOn)this);
        this.levels = Collections$.MODULE$.newSet();
        this.majors = Collections$.MODULE$.newSet();
        this.hours = Collections$.MODULE$.newBuffer();
        this.examHours = Collections$.MODULE$.newBuffer();
        this.stage = None$.MODULE$;
        this.prerequisites = None$.MODULE$;
        this.corequisites = None$.MODULE$;
        this.subsequents = None$.MODULE$;
        this.objectives = Collections$.MODULE$.newBuffer();
        this.outcomes = Collections$.MODULE$.newBuffer();
        this.topics = Collections$.MODULE$.newBuffer();
        this.assessments = Collections$.MODULE$.newBuffer();
        this.textbooks = Collections$.MODULE$.newBuffer();
        this.bibliography = None$.MODULE$;
        this.materials = None$.MODULE$;
        this.website = None$.MODULE$;
        this.texts = Collections$.MODULE$.newBuffer();
        this.designs = Collections$.MODULE$.newBuffer();
        this.cases = Collections$.MODULE$.newBuffer();
        this.experiments = Collections$.MODULE$.newBuffer();
        this.office = None$.MODULE$;
        this.status = AuditStatus$.Draft;
        this.reviewer = None$.MODULE$;
        this.approver = None$.MODULE$;
        this.publishAt = None$.MODULE$;
    }

    public Instant updatedAt() {
        return this.updatedAt;
    }

    public void updatedAt_$eq(Instant x$1) {
        this.updatedAt = x$1;
    }

    public LocalDate beginOn() {
        return this.beginOn;
    }

    public Option endOn() {
        return this.endOn;
    }

    public void beginOn_$eq(LocalDate x$1) {
        this.beginOn = x$1;
    }

    public void endOn_$eq(Option x$1) {
        this.endOn = x$1;
    }

    public Course course() {
        return this.course;
    }

    public void course_$eq(Course x$1) {
        this.course = x$1;
    }

    public Locale locale() {
        return this.locale;
    }

    public void locale_$eq(Locale x$1) {
        this.locale = x$1;
    }

    public String description() {
        return this.description;
    }

    public void description_$eq(String x$1) {
        this.description = x$1;
    }

    public Semester semester() {
        return this.semester;
    }

    public void semester_$eq(Semester x$1) {
        this.semester = x$1;
    }

    public Set<EducationLevel> levels() {
        return this.levels;
    }

    public void levels_$eq(Set<EducationLevel> x$1) {
        this.levels = x$1;
    }

    public Set<Major> majors() {
        return this.majors;
    }

    public void majors_$eq(Set<Major> x$1) {
        this.majors = x$1;
    }

    public int creditHours() {
        return this.creditHours;
    }

    public void creditHours_$eq(int x$1) {
        this.creditHours = x$1;
    }

    public Buffer<SyllabusCreditHour> hours() {
        return this.hours;
    }

    public void hours_$eq(Buffer<SyllabusCreditHour> x$1) {
        this.hours = x$1;
    }

    public String methods() {
        return this.methods;
    }

    public void methods_$eq(String x$1) {
        this.methods = x$1;
    }

    public int examCreditHours() {
        return this.examCreditHours;
    }

    public void examCreditHours_$eq(int x$1) {
        this.examCreditHours = x$1;
    }

    public Buffer<SyllabusExamHour> examHours() {
        return this.examHours;
    }

    public void examHours_$eq(Buffer<SyllabusExamHour> x$1) {
        this.examHours = x$1;
    }

    public float learningHours() {
        return this.learningHours;
    }

    public void learningHours_$eq(float x$1) {
        this.learningHours = x$1;
    }

    public Option<CalendarStage> stage() {
        return this.stage;
    }

    public void stage_$eq(Option<CalendarStage> x$1) {
        this.stage = x$1;
    }

    public CourseModule module() {
        return this.module;
    }

    public void module_$eq(CourseModule x$1) {
        this.module = x$1;
    }

    public CourseRank rank() {
        return this.rank;
    }

    public void rank_$eq(CourseRank x$1) {
        this.rank = x$1;
    }

    public CourseNature nature() {
        return this.nature;
    }

    public void nature_$eq(CourseNature x$1) {
        this.nature = x$1;
    }

    public ExamMode examMode() {
        return this.examMode;
    }

    public void examMode_$eq(ExamMode x$1) {
        this.examMode = x$1;
    }

    public GradingMode gradingMode() {
        return this.gradingMode;
    }

    public void gradingMode_$eq(GradingMode x$1) {
        this.gradingMode = x$1;
    }

    public Option<String> prerequisites() {
        return this.prerequisites;
    }

    public void prerequisites_$eq(Option<String> x$1) {
        this.prerequisites = x$1;
    }

    public Option<String> corequisites() {
        return this.corequisites;
    }

    public void corequisites_$eq(Option<String> x$1) {
        this.corequisites = x$1;
    }

    public Option<String> subsequents() {
        return this.subsequents;
    }

    public void subsequents_$eq(Option<String> x$1) {
        this.subsequents = x$1;
    }

    public Buffer<SyllabusObjective> objectives() {
        return this.objectives;
    }

    public void objectives_$eq(Buffer<SyllabusObjective> x$1) {
        this.objectives = x$1;
    }

    public Buffer<SyllabusOutcome> outcomes() {
        return this.outcomes;
    }

    public void outcomes_$eq(Buffer<SyllabusOutcome> x$1) {
        this.outcomes = x$1;
    }

    public Buffer<SyllabusTopic> topics() {
        return this.topics;
    }

    public void topics_$eq(Buffer<SyllabusTopic> x$1) {
        this.topics = x$1;
    }

    public Buffer<SyllabusAssessment> assessments() {
        return this.assessments;
    }

    public void assessments_$eq(Buffer<SyllabusAssessment> x$1) {
        this.assessments = x$1;
    }

    public Buffer<Textbook> textbooks() {
        return this.textbooks;
    }

    public void textbooks_$eq(Buffer<Textbook> x$1) {
        this.textbooks = x$1;
    }

    public Option<String> bibliography() {
        return this.bibliography;
    }

    public void bibliography_$eq(Option<String> x$1) {
        this.bibliography = x$1;
    }

    public Option<String> materials() {
        return this.materials;
    }

    public void materials_$eq(Option<String> x$1) {
        this.materials = x$1;
    }

    public Option<String> website() {
        return this.website;
    }

    public void website_$eq(Option<String> x$1) {
        this.website = x$1;
    }

    public Buffer<SyllabusText> texts() {
        return this.texts;
    }

    public void texts_$eq(Buffer<SyllabusText> x$1) {
        this.texts = x$1;
    }

    public Buffer<SyllabusMethodDesign> designs() {
        return this.designs;
    }

    public void designs_$eq(Buffer<SyllabusMethodDesign> x$1) {
        this.designs = x$1;
    }

    public Buffer<SyllabusCase> cases() {
        return this.cases;
    }

    public void cases_$eq(Buffer<SyllabusCase> x$1) {
        this.cases = x$1;
    }

    public Buffer<SyllabusExperiment> experiments() {
        return this.experiments;
    }

    public void experiments_$eq(Buffer<SyllabusExperiment> x$1) {
        this.experiments = x$1;
    }

    public Department department() {
        return this.department;
    }

    public void department_$eq(Department x$1) {
        this.department = x$1;
    }

    public Option<TeachingOffice> office() {
        return this.office;
    }

    public void office_$eq(Option<TeachingOffice> x$1) {
        this.office = x$1;
    }

    public AuditStatus status() {
        return this.status;
    }

    public void status_$eq(AuditStatus x$1) {
        this.status = x$1;
    }

    public User writer() {
        return this.writer;
    }

    public void writer_$eq(User x$1) {
        this.writer = x$1;
    }

    public Option<User> reviewer() {
        return this.reviewer;
    }

    public void reviewer_$eq(Option<User> x$1) {
        this.reviewer = x$1;
    }

    public Option<User> approver() {
        return this.approver;
    }

    public void approver_$eq(Option<User> x$1) {
        this.approver = x$1;
    }

    public Option<Instant> publishAt() {
        return this.publishAt;
    }

    public void publishAt_$eq(Option<Instant> x$1) {
        this.publishAt = x$1;
    }

    public Seq<String> teachingMethods() {
        String string = this.methods();
        if (string == null) {
            return (Seq)package$.MODULE$.Seq().empty();
        }
        String m = string;
        Object object = Predef$.MODULE$.refArrayOps((Object[])Strings$.MODULE$.split(m, new char[]{'\u3001', ',', '\uff1b', '\uff0c'}));
        return ArrayOps$.MODULE$.toSeq$extension(object);
    }

    public Seq<TeachingNature> teachingNatures() {
        return ((IterableOnceOps)this.hours().map((Function1 & Serializable)_$16 -> _$16.nature())).toSeq();
    }

    public Option<SyllabusCreditHour> getCreditHour(TeachingNature nature) {
        return this.hours().find((Function1 & Serializable)_$17 -> {
            TeachingNature teachingNature = _$17.nature();
            TeachingNature teachingNature2 = nature;
            return !(teachingNature != null ? !teachingNature.equals(teachingNature2) : teachingNature2 != null);
        });
    }

    public float getTopicCreditHours(TeachingNature nature) {
        return BoxesRunTime.unboxToFloat((Object)((IterableOnceOps)this.topics().flatMap((Function1 & Serializable)t -> t.getHour(nature).map((Function1 & Serializable)_$18 -> _$18.creditHours()))).sum((Numeric)Numeric.FloatIsFractional$.MODULE$));
    }

    public float getCreditHours(TeachingNature nature) {
        return BoxesRunTime.unboxToFloat((Object)((IterableOnceOps)this.topics().flatMap((Function1 & Serializable)t -> t.getHour(nature).map((Function1 & Serializable)_$19 -> _$19.creditHours()))).sum((Numeric)Numeric.FloatIsFractional$.MODULE$)) + BoxesRunTime.unboxToFloat((Object)this.examHours().find((Function1 & Serializable)_$20 -> {
            TeachingNature teachingNature = _$20.nature();
            TeachingNature teachingNature2 = nature;
            return !(teachingNature != null ? !teachingNature.equals(teachingNature2) : teachingNature2 != null);
        }).map((Function1 & Serializable)_$21 -> _$21.creditHours()).getOrElse(Syllabus::getCreditHours$$anonfun$4));
    }

    public int getTopicWeeks(TeachingNature nature) {
        return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.topics().flatMap((Function1 & Serializable)t -> t.getHour(nature).map((Function1 & Serializable)_$22 -> _$22.weeks()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public Option<SyllabusText> getText(String name) {
        return this.texts().find((Function1 & Serializable)_$23 -> {
            String string = _$23.name();
            String string2 = name;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    public Option<SyllabusObjective> getObjective(String code) {
        return this.objectives().find((Function1 & Serializable)_$24 -> {
            String string = _$24.code();
            String string2 = code;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    public Option<SyllabusOutcome> getOutcome(String title) {
        return this.outcomes().find((Function1 & Serializable)_$25 -> {
            String string = _$25.title();
            String string2 = title;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    public Seq<SyllabusAssessment> getAssessments(GradeType gradeType) {
        return ((IterableOnceOps)this.assessments().filter((Function1 & Serializable)x -> {
            GradeType gradeType = x.gradeType();
            GradeType gradeType2 = gradeType;
            return !(gradeType != null ? !gradeType.equals(gradeType2) : gradeType2 != null);
        })).toSeq();
    }

    public Option<SyllabusAssessment> getAssessment(GradeType gradeType, String componentName) {
        if (componentName == null) {
            return this.assessments().find((Function1 & Serializable)x -> {
                GradeType gradeType = x.gradeType();
                GradeType gradeType2 = gradeType;
                return !(gradeType != null ? !gradeType.equals(gradeType2) : gradeType2 != null) && x.component().isEmpty();
            });
        }
        return this.assessments().find((Function1 & Serializable)x -> {
            GradeType gradeType = x.gradeType();
            GradeType gradeType2 = gradeType;
            return !(gradeType != null ? !gradeType.equals(gradeType2) : gradeType2 != null) && x.component().contains((Object)componentName);
        });
    }

    public Option<SyllabusAssessment> getUsualAssessment(int index) {
        return this.assessments().find((Function1 & Serializable)x -> BoxesRunTime.unboxToInt((Object)x.gradeType().id()) == GradeType$.MODULE$.Usual() && x.component().nonEmpty() && x.idx() == index);
    }

    private static final float getCreditHours$$anonfun$4() {
        return 0.0f;
    }
}

