/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.course.model;

import java.io.Serializable;
import java.time.Instant;
import org.beangle.commons.collection.Collections$;
import org.beangle.data.model.LongId;
import org.beangle.data.model.pojo.Updated;
import org.openurp.base.edu.model.TeachingOffice;
import org.openurp.base.model.AuditStatus;
import org.openurp.base.model.AuditStatus$;
import org.openurp.base.model.Semester;
import org.openurp.base.model.User;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.course.model.Lesson;
import org.openurp.edu.course.model.TeachingPlanSection;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.function.JProcedure1;

public class TeachingPlan
extends LongId
implements Updated {
    private Instant updatedAt;
    private Clazz clazz;
    private Semester semester;
    private Buffer sections;
    private int lessonHours;
    private int examHours;
    private Buffer lessons;
    private Option filePath;
    private Option office;
    private AuditStatus status;
    private User writer;
    private Option reviewer;
    private Option approver;
    private Option publishAt;
    private Option opinions;

    public TeachingPlan() {
        Updated.$init$((Updated)this);
        this.sections = Collections$.MODULE$.newBuffer();
        this.lessons = Collections$.MODULE$.newBuffer();
        this.filePath = None$.MODULE$;
        this.office = None$.MODULE$;
        this.status = AuditStatus$.Draft;
        this.reviewer = None$.MODULE$;
        this.approver = None$.MODULE$;
        this.publishAt = None$.MODULE$;
        this.opinions = None$.MODULE$;
    }

    public Instant updatedAt() {
        return this.updatedAt;
    }

    public void updatedAt_$eq(Instant x$1) {
        this.updatedAt = x$1;
    }

    public Clazz clazz() {
        return this.clazz;
    }

    public void clazz_$eq(Clazz x$1) {
        this.clazz = x$1;
    }

    public Semester semester() {
        return this.semester;
    }

    public void semester_$eq(Semester x$1) {
        this.semester = x$1;
    }

    public Buffer<TeachingPlanSection> sections() {
        return this.sections;
    }

    public void sections_$eq(Buffer<TeachingPlanSection> x$1) {
        this.sections = x$1;
    }

    public int lessonHours() {
        return this.lessonHours;
    }

    public void lessonHours_$eq(int x$1) {
        this.lessonHours = x$1;
    }

    public int examHours() {
        return this.examHours;
    }

    public void examHours_$eq(int x$1) {
        this.examHours = x$1;
    }

    public Buffer<Lesson> lessons() {
        return this.lessons;
    }

    public void lessons_$eq(Buffer<Lesson> x$1) {
        this.lessons = x$1;
    }

    public Option<String> filePath() {
        return this.filePath;
    }

    public void filePath_$eq(Option<String> x$1) {
        this.filePath = x$1;
    }

    public Option<TeachingOffice> office() {
        return this.office;
    }

    public void office_$eq(Option<TeachingOffice> x$1) {
        this.office = x$1;
    }

    public AuditStatus status() {
        return this.status;
    }

    public void status_$eq(AuditStatus x$1) {
        this.status = x$1;
    }

    public User writer() {
        return this.writer;
    }

    public void writer_$eq(User x$1) {
        this.writer = x$1;
    }

    public Option<User> reviewer() {
        return this.reviewer;
    }

    public void reviewer_$eq(Option<User> x$1) {
        this.reviewer = x$1;
    }

    public Option<User> approver() {
        return this.approver;
    }

    public void approver_$eq(Option<User> x$1) {
        this.approver = x$1;
    }

    public Option<Instant> publishAt() {
        return this.publishAt;
    }

    public void publishAt_$eq(Option<Instant> x$1) {
        this.publishAt = x$1;
    }

    public Option<String> opinions() {
        return this.opinions;
    }

    public void opinions_$eq(Option<String> x$1) {
        this.opinions = x$1;
    }

    public int getHours(String section) {
        return BoxesRunTime.unboxToInt((Object)((IterableOps)((IterableOps)this.sections().filter((Function1 & Serializable)_$6 -> {
            String string = _$6.name();
            String string2 = section;
            return !(string != null ? !string.equals(string2) : string2 != null);
        })).map((Function1 & Serializable)_$7 -> _$7.creditHours())).headOption().getOrElse(TeachingPlan::getHours$$anonfun$3));
    }

    public Option<Lesson> getLesson(int idx) {
        return this.lessons().find((Function1 & Serializable)_$8 -> _$8.idx() == idx);
    }

    public TeachingPlan(Clazz clazz) {
        this();
        this.clazz_$eq(clazz);
        this.semester_$eq(clazz.semester());
    }

    public void reserveSections(Iterable<String> names) {
        Set nameSet = names.toSet();
        Buffer removed = (Buffer)this.sections().filter((Function1 & Serializable)x -> !nameSet.contains((Object)x.name()));
        this.sections().subtractAll((IterableOnce)removed);
    }

    public void addSection(String name, int creditHours) {
        Option option = this.sections().find((Function1 & Serializable)_$9 -> {
            String string = _$9.name();
            String string2 = name;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
        if (None$.MODULE$.equals(option)) {
            TeachingPlanSection s = new TeachingPlanSection(this, name, creditHours);
            this.sections().addOne((Object)s);
            return;
        }
        if (option instanceof Some) {
            TeachingPlanSection s = (TeachingPlanSection)((Object)((Some)option).value());
            s.creditHours_$eq(creditHours);
            return;
        }
        throw new MatchError((Object)option);
    }

    public void copyTo(TeachingPlan p) {
        Set sectionNames = ((IterableOnceOps)this.sections().map((Function1 & Serializable)_$10 -> _$10.name())).toSet();
        Buffer abandons = (Buffer)p.sections().filter((Function1 & Serializable)x -> !sectionNames.contains((Object)x.name()));
        p.sections().subtractAll((IterableOnce)abandons);
        this.sections().foreach((Function1 & Serializable)h -> {
            Option option = p.sections().find((Function1 & Serializable)x -> {
                String string = x.name();
                String string2 = h.name();
                return !(string != null ? !string.equals(string2) : string2 != null);
            });
            if (None$.MODULE$.equals(option)) {
                return p.sections().addOne((Object)new TeachingPlanSection(p, h.name(), h.creditHours()));
            }
            if (option instanceof Some) {
                TeachingPlanSection nh = (TeachingPlanSection)((Object)((Object)((Some)option).value()));
                nh.creditHours_$eq(h.creditHours());
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)option);
        });
        p.writer_$eq(this.writer());
        p.office_$eq(this.office());
        p.reviewer_$eq(this.reviewer());
        p.lessonHours_$eq(this.lessonHours());
        p.examHours_$eq(this.examHours());
        Buffer targetLessons = (Buffer)p.lessons().sortBy((Function1 & Serializable)_$11 -> _$11.idx(), (Ordering)Ordering.Int$.MODULE$);
        IntRef i = IntRef.create((int)0);
        ((IterableOnceOps)this.lessons().sortBy((Function1 & Serializable)_$12 -> _$12.idx(), (Ordering)Ordering.Int$.MODULE$)).foreach((Function1)(JProcedure1 & Serializable)l -> {
            int n;
            Lesson nl = i$1.elem < targetLessons.length() ? (Lesson)((Object)((Object)targetLessons.apply(i$1.elem))) : new Lesson(p, i$1.elem + 1);
            nl.contents_$eq(l.contents());
            nl.homework_$eq(l.homework());
            nl.learningHours_$eq(l.learningHours());
            nl.learning_$eq(l.learning());
            nl.forms_$eq(l.forms());
            if (!nl.persisted()) {
                p.lessons().addOne((Object)nl);
            }
            i$1.elem = n = i$1.elem + 1;
        });
        p.updatedAt_$eq(Instant.now());
    }

    private static final int getHours$$anonfun$3() {
        return 0;
    }
}

