/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.clazz.domain;

import java.io.Serializable;
import java.time.LocalDate;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.time.WeekDay;
import org.beangle.commons.lang.time.WeekState;
import org.beangle.commons.lang.time.WeekState$;
import org.beangle.commons.lang.time.WeekTime;
import org.beangle.commons.lang.time.WeekTime$;
import org.beangle.commons.lang.time.Weeks$;
import org.openurp.base.model.Semester;
import org.openurp.edu.clazz.domain.WeekTimeBuilder$;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction1;

public class WeekTimeBuilder {
    private final LocalDate startOn;
    private final LocalDate firstWeekEndOn;

    public static WeekState collect(Semester semester, Iterable<LocalDate> iterable) {
        return WeekTimeBuilder$.MODULE$.collect(semester, iterable);
    }

    public static String digest(WeekState weekState) {
        return WeekTimeBuilder$.MODULE$.digest(weekState);
    }

    public static String digest(WeekTime weekTime, Semester semester) {
        return WeekTimeBuilder$.MODULE$.digest(weekTime, semester);
    }

    public static Buffer<WeekTime> mergeTimes(Buffer<WeekTime> buffer, int n) {
        return WeekTimeBuilder$.MODULE$.mergeTimes(buffer, n);
    }

    public static WeekTimeBuilder on(Semester semester) {
        return WeekTimeBuilder$.MODULE$.on(semester);
    }

    public WeekTimeBuilder(LocalDate startOn, WeekDay firstDay) {
        this.startOn = startOn;
        this.firstWeekEndOn = this.calcFirstWeekEndOn(startOn, firstDay);
    }

    public LocalDate startOn() {
        return this.startOn;
    }

    public Iterable<WeekTime> build(WeekDay weekday, Iterable<Object> weeks) {
        Map times = Collections$.MODULE$.newMap();
        ObjectRef startDate = ObjectRef.create((Object)this.startOn());
        while (((LocalDate)startDate.elem).getDayOfWeek().getValue() != weekday.id()) {
            startDate.elem = ((LocalDate)startDate.elem).plusDays(1L);
        }
        int minWeek = ((LocalDate)startDate.elem).isAfter(this.firstWeekEndOn) ? 2 : 1;
        weeks.withFilter((Function1)(JFunction1.mcZI.sp & Serializable)week -> week >= minWeek).foreach((Function1)(JFunction1.mcVI.sp & Serializable)week -> {
            WeekTime weekTime;
            LocalDate oneday = ((LocalDate)startDate$1.elem).plusWeeks(Int$.MODULE$.int2long(week - 1));
            int year = oneday.getYear();
            LocalDate yearStartOn = WeekTime$.MODULE$.getStartOn(year, weekday);
            Option option = times.get((Object)BoxesRunTime.boxToInteger((int)year));
            if (None$.MODULE$.equals(option)) {
                WeekTime wt = new WeekTime();
                times.put((Object)BoxesRunTime.boxToInteger((int)year), (Object)wt);
                wt.startOn_$eq(yearStartOn);
                wt.weekstate_$eq(WeekState$.MODULE$.Zero());
                weekTime = wt;
            } else if (option instanceof Some) {
                WeekTime t;
                weekTime = t = (WeekTime)((Some)option).value();
            } else {
                throw new MatchError((Object)option);
            }
            WeekTime weektime = weekTime;
            weektime.weekstate_$eq(weektime.weekstate().$bar(WeekState$.MODULE$.of(Weeks$.MODULE$.between(yearStartOn, oneday) + 1)));
        });
        return times.values();
    }

    private LocalDate calcFirstWeekEndOn(LocalDate startOn, WeekDay firstDay) {
        LocalDate endOn = startOn;
        WeekDay weekendDay = firstDay.previous();
        while (endOn.getDayOfWeek().getValue() != weekendDay.id()) {
            endOn = endOn.plusDays(1L);
        }
        return endOn;
    }
}

