/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.domain;

import java.io.Serializable;
import java.time.Instant;
import org.beangle.commons.collection.Collections$;
import org.openurp.base.model.Semester;
import org.openurp.base.std.model.Student;
import org.openurp.code.edu.model.EducationLevel;
import org.openurp.edu.grade.domain.GpaPolicy;
import org.openurp.edu.grade.domain.WeightedMean$;
import org.openurp.edu.grade.model.CourseGrade;
import org.openurp.edu.grade.model.StdGpa;
import org.openurp.edu.grade.model.StdSemesterGpa;
import org.openurp.edu.grade.model.StdYearGpa;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.math.BigDecimal;
import scala.runtime.FloatRef;
import scala.runtime.function.JProcedure1;

public class DefaultGpaPolicy
implements GpaPolicy {
    @Override
    public BigDecimal calcGa(Iterable<CourseGrade> grades) {
        return WeightedMean$.MODULE$.calcGa(grades);
    }

    @Override
    public BigDecimal calcGpa(Iterable<CourseGrade> grades) {
        return WeightedMean$.MODULE$.calcGpa(grades);
    }

    @Override
    public StdGpa calc(Student std, Iterable<CourseGrade> grades, boolean statDetail) {
        StdGpa stdGpa = new StdGpa(std);
        if (statDetail) {
            Map gradesMap = Collections$.MODULE$.newMap();
            grades.foreach((Function1 & Serializable)grade -> {
                Buffer semesterGrades = (Buffer)gradesMap.getOrElseUpdate((Object)grade.semester(), DefaultGpaPolicy::$anonfun$1);
                return (Buffer)semesterGrades.$plus$eq(grade);
            });
            Map yearGradeMap = Collections$.MODULE$.newMap();
            gradesMap.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Semester semester = (Semester)tuple2._1();
                    Buffer semesterGrades = (Buffer)tuple2._2();
                    StdSemesterGpa stdTermGpa = new StdSemesterGpa();
                    stdTermGpa.semester_$eq(semester);
                    stdGpa.add(stdTermGpa);
                    Buffer yearGrades = (Buffer)yearGradeMap.getOrElseUpdate((Object)semester.schoolYear(), DefaultGpaPolicy::$anonfun$2);
                    yearGrades.$plus$plus$eq((IterableOnce)semesterGrades);
                    stdTermGpa.gpa_$eq(this.calcGpa((Iterable<CourseGrade>)semesterGrades).doubleValue());
                    stdTermGpa.ga_$eq(this.calcGa((Iterable<CourseGrade>)semesterGrades).doubleValue());
                    stdTermGpa.gradeCount_$eq(semesterGrades.size());
                    float[] stats = this.statCredits((Iterable<CourseGrade>)semesterGrades);
                    stdTermGpa.totalCredits_$eq(stats[0]);
                    stdTermGpa.credits_$eq(stats[1]);
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
            yearGradeMap.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String year = (String)tuple2._1();
                    Buffer yearGrades = (Buffer)tuple2._2();
                    StdYearGpa stdYearGpa = new StdYearGpa();
                    stdYearGpa.schoolYear_$eq(year);
                    stdGpa.add(stdYearGpa);
                    stdYearGpa.gpa_$eq(this.calcGpa((Iterable<CourseGrade>)yearGrades).doubleValue());
                    stdYearGpa.ga_$eq(this.calcGa((Iterable<CourseGrade>)yearGrades).doubleValue());
                    stdYearGpa.gradeCount_$eq(yearGrades.size());
                    float[] stats = this.statCredits((Iterable<CourseGrade>)yearGrades);
                    stdYearGpa.totalCredits_$eq(stats[0]);
                    stdYearGpa.credits_$eq(stats[1]);
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
        }
        stdGpa.gpa_$eq(this.calcGpa(grades).doubleValue());
        stdGpa.ga_$eq(this.calcGa(grades).doubleValue());
        Map courseMap = Collections$.MODULE$.newMap();
        grades.foreach((Function1)(JProcedure1 & Serializable)grade -> {
            boolean bl;
            Option option = courseMap.get((Object)grade.course());
            if (None$.MODULE$.equals(option)) {
                bl = true;
            } else if (option instanceof Some) {
                CourseGrade exist = (CourseGrade)((Some)option).value();
                bl = !exist.passed();
            } else {
                throw new MatchError((Object)option);
            }
            boolean add = bl;
            if (add) {
                courseMap.put((Object)grade.course(), grade);
                return;
            }
        });
        stdGpa.gradeCount_$eq(courseMap.size());
        float[] totalStats = this.statCredits((Iterable<CourseGrade>)courseMap.values());
        stdGpa.totalCredits_$eq(totalStats[0]);
        stdGpa.credits_$eq(totalStats[1]);
        stdGpa.updatedAt_$eq(Instant.now());
        return stdGpa;
    }

    private float[] statCredits(Iterable<CourseGrade> grades) {
        FloatRef passedCredits = FloatRef.create((float)0.0f);
        FloatRef allCredits = FloatRef.create((float)0.0f);
        grades.foreach((Function1)(JProcedure1 & Serializable)grade -> {
            float f;
            EducationLevel level = grade.std().level();
            float credits = grade.course().getCredits(level);
            if (grade.passed()) {
                float f2;
                passedCredits$1.elem = f2 = passedCredits$1.elem + credits;
            }
            allCredits$1.elem = f = allCredits$1.elem + credits;
        });
        return new float[]{allCredits.elem, passedCredits.elem};
    }

    private static final Buffer $anonfun$1() {
        return Collections$.MODULE$.newBuffer();
    }

    private static final Buffer $anonfun$2() {
        return Collections$.MODULE$.newBuffer();
    }
}

