/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.model;

import java.io.Serializable;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.model.LongId;
import org.beangle.data.model.pojo.Remark;
import org.openurp.base.edu.model.Course;
import org.openurp.base.edu.model.Terms;
import org.openurp.base.edu.model.Terms$;
import org.openurp.code.edu.model.CourseTakeType$;
import org.openurp.edu.grade.model.AuditGroupResult;
import org.openurp.edu.grade.model.CourseGrade;
import org.openurp.edu.grade.model.CoursePassedWay;
import org.openurp.edu.grade.model.CoursePassedWay$;
import org.openurp.edu.program.model.PlanCourse;
import org.openurp.edu.program.model.SharePlanCourse;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public class AuditCourseResult
extends LongId
implements Remark {
    private Option remark;
    private AuditGroupResult groupResult;
    private Course course;
    private String scores;
    private boolean passed;
    private Terms terms;
    private boolean compulsory;
    private boolean taking;
    private boolean predicted;
    private boolean hasGrade;
    private Option passedWay;

    public AuditCourseResult() {
        Remark.$init$((Remark)this);
        this.terms = Terms$.MODULE$.empty();
        this.passedWay = None$.MODULE$;
    }

    public Option remark() {
        return this.remark;
    }

    public void remark_$eq(Option x$1) {
        this.remark = x$1;
    }

    public AuditGroupResult groupResult() {
        return this.groupResult;
    }

    public void groupResult_$eq(AuditGroupResult x$1) {
        this.groupResult = x$1;
    }

    public Course course() {
        return this.course;
    }

    public void course_$eq(Course x$1) {
        this.course = x$1;
    }

    public String scores() {
        return this.scores;
    }

    public void scores_$eq(String x$1) {
        this.scores = x$1;
    }

    public boolean passed() {
        return this.passed;
    }

    public void passed_$eq(boolean x$1) {
        this.passed = x$1;
    }

    public Terms terms() {
        return this.terms;
    }

    public void terms_$eq(Terms x$1) {
        this.terms = x$1;
    }

    public boolean compulsory() {
        return this.compulsory;
    }

    public void compulsory_$eq(boolean x$1) {
        this.compulsory = x$1;
    }

    public boolean taking() {
        return this.taking;
    }

    public void taking_$eq(boolean x$1) {
        this.taking = x$1;
    }

    public boolean predicted() {
        return this.predicted;
    }

    public void predicted_$eq(boolean x$1) {
        this.predicted = x$1;
    }

    public boolean hasGrade() {
        return this.hasGrade;
    }

    public void hasGrade_$eq(boolean x$1) {
        this.hasGrade = x$1;
    }

    public Option<CoursePassedWay> passedWay() {
        return this.passedWay;
    }

    public void passedWay_$eq(Option<CoursePassedWay> x$1) {
        this.passedWay = x$1;
    }

    public AuditCourseResult updatePassed(Iterable<CourseGrade> grades) {
        this.hasGrade_$eq(false);
        if (Collections$.MODULE$.isEmpty(grades)) {
            this.scores_$eq("--");
        } else {
            this.hasGrade_$eq(true);
            StringBuilder sb = new StringBuilder();
            grades.foreach((Function1)(JProcedure1 & Serializable)grade -> {
                sb.append(this.getScoreText((CourseGrade)grade)).append(" ");
                if (!this.passed()) {
                    this.passed_$eq(grade.passed());
                    return;
                }
            });
            this.scores_$eq(sb.toString());
            if (this.passed()) {
                boolean isRepeat = BoxesRunTime.unboxToInt((Object)((CourseGrade)grades.head()).courseTakeType().id()) == CourseTakeType$.MODULE$.Repeat();
                this.updatePassedWay(isRepeat ? CoursePassedWay$.ByGrade : CoursePassedWay$.ByRepeat);
            }
        }
        return this;
    }

    public AuditCourseResult updatePassed(Iterable<CourseGrade> grades, Iterable<CourseGrade> substituteGrades) {
        this.updatePassed(grades);
        if (this.passed()) {
            this.updatePassedWay(CoursePassedWay$.ByGrade);
        }
        if (!this.passed() && substituteGrades.nonEmpty() && ((CourseGrade)substituteGrades.head()).passed()) {
            this.updatePassedWay(CoursePassedWay$.ByAlternative);
            Buffer r = Collections$.MODULE$.newBuffer();
            substituteGrades.foreach((Function1 & Serializable)grade -> (Buffer)r.addOne((Object)(grade.course().name() + "(" + grade.course().code() + " " + this.getScoreText((CourseGrade)grade) + ")")));
            this.addRemark(r.mkString(" "));
        }
        return this;
    }

    private String getScoreText(CourseGrade grade) {
        Option<String> option = grade.scoreText();
        if (None$.MODULE$.equals(option)) {
            if (BoxesRunTime.unboxToInt((Object)grade.courseTakeType().id()) == CourseTakeType$.MODULE$.Exemption()) {
                return grade.courseTakeType().name();
            }
            return "--";
        }
        if (option instanceof Some) {
            String s = (String)((Some)option).value();
            return s;
        }
        throw new MatchError(option);
    }

    public void updatePassedWay(CoursePassedWay way) {
        this.passed_$eq(true);
        this.passedWay_$eq((Option<CoursePassedWay>)Some$.MODULE$.apply((Object)way));
    }

    public AuditCourseResult(Course course) {
        this();
        this.course_$eq(course);
        this.scores_$eq("--");
    }

    public AuditCourseResult(PlanCourse pc) {
        this(pc.course());
        this.terms_$eq(pc.terms());
        this.compulsory_$eq(pc.compulsory());
    }

    public AuditCourseResult(SharePlanCourse pc) {
        this(pc.course());
        this.terms_$eq(pc.terms());
        this.compulsory_$eq(pc.compulsory());
    }

    public void addRemark(String remark) {
        Some some;
        Option option = this.remark();
        if (None$.MODULE$.equals(option)) {
            some = Some$.MODULE$.apply((Object)remark);
        } else if (option instanceof Some) {
            String r2 = (String)((Some)option).value();
            some = r2.contains(remark) ? Some$.MODULE$.apply((Object)r2) : Some$.MODULE$.apply((Object)(r2 + " " + remark));
        } else {
            throw new MatchError((Object)option);
        }
        this.remark_$eq((Option)some);
        this.remark().foreach((Function1)(JProcedure1 & Serializable)r -> {
            if (r.length() > 200) {
                this.remark_$eq((Option)Some$.MODULE$.apply((Object)Strings$.MODULE$.abbreviate(r, 200)));
                return;
            }
        });
    }
}

