/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.model;

import java.io.Serializable;
import org.beangle.commons.collection.Collections$;
import org.beangle.data.model.LongId;
import org.beangle.data.model.pojo.Hierarchical;
import org.beangle.data.model.pojo.Named;
import org.beangle.data.model.pojo.Remark;
import org.openurp.base.edu.model.Course;
import org.openurp.code.edu.model.CourseRank;
import org.openurp.code.edu.model.CourseRank$;
import org.openurp.code.edu.model.CourseType;
import org.openurp.code.edu.model.EducationLevel;
import org.openurp.edu.grade.model.AuditCourseLevel;
import org.openurp.edu.grade.model.AuditCourseLevel$;
import org.openurp.edu.grade.model.AuditCourseResult;
import org.openurp.edu.grade.model.AuditPlanResult;
import org.openurp.edu.program.model.CourseGroup;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Short$;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Set;
import scala.math.Numeric;
import scala.math.Ordered;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;

public class AuditGroupResult
extends LongId
implements Named,
Hierarchical<AuditGroupResult>,
Remark {
    private String name;
    private String indexno;
    private Option parent;
    private Buffer children;
    private Option remark;
    private float requiredCredits;
    private float passedCredits;
    private float owedCredits;
    private float owedCredits2;
    private float owedCredits3;
    private float convertedCredits;
    private transient Set passedCourses;
    private transient Set predictedCourses;
    private transient Set takingCourses;
    private Buffer courseResults;
    private Option rank;
    private CourseType courseType;
    private boolean passed;
    private short subCount;
    private AuditPlanResult planResult;

    public AuditGroupResult() {
        Named.$init$((Named)this);
        Ordered.$init$((Ordered)this);
        Hierarchical.$init$((Hierarchical)this);
        Remark.$init$((Remark)this);
        this.passedCourses = Collections$.MODULE$.newSet();
        this.predictedCourses = Collections$.MODULE$.newSet();
        this.takingCourses = Collections$.MODULE$.newSet();
        this.courseResults = new ListBuffer();
        this.rank = None$.MODULE$;
    }

    public String name() {
        return this.name;
    }

    public void name_$eq(String x$1) {
        this.name = x$1;
    }

    public String indexno() {
        return this.indexno;
    }

    public Option parent() {
        return this.parent;
    }

    public Buffer children() {
        return this.children;
    }

    public void indexno_$eq(String x$1) {
        this.indexno = x$1;
    }

    public void parent_$eq(Option x$1) {
        this.parent = x$1;
    }

    public void children_$eq(Buffer x$1) {
        this.children = x$1;
    }

    public Option remark() {
        return this.remark;
    }

    public void remark_$eq(Option x$1) {
        this.remark = x$1;
    }

    public float requiredCredits() {
        return this.requiredCredits;
    }

    public void requiredCredits_$eq(float x$1) {
        this.requiredCredits = x$1;
    }

    public float passedCredits() {
        return this.passedCredits;
    }

    public void passedCredits_$eq(float x$1) {
        this.passedCredits = x$1;
    }

    public float owedCredits() {
        return this.owedCredits;
    }

    public void owedCredits_$eq(float x$1) {
        this.owedCredits = x$1;
    }

    public float owedCredits2() {
        return this.owedCredits2;
    }

    public void owedCredits2_$eq(float x$1) {
        this.owedCredits2 = x$1;
    }

    public float owedCredits3() {
        return this.owedCredits3;
    }

    public void owedCredits3_$eq(float x$1) {
        this.owedCredits3 = x$1;
    }

    public float convertedCredits() {
        return this.convertedCredits;
    }

    public void convertedCredits_$eq(float x$1) {
        this.convertedCredits = x$1;
    }

    public Set<Course> passedCourses() {
        return this.passedCourses;
    }

    public void passedCourses_$eq(Set<Course> x$1) {
        this.passedCourses = x$1;
    }

    public Set<Course> predictedCourses() {
        return this.predictedCourses;
    }

    public void predictedCourses_$eq(Set<Course> x$1) {
        this.predictedCourses = x$1;
    }

    public Set<Course> takingCourses() {
        return this.takingCourses;
    }

    public void takingCourses_$eq(Set<Course> x$1) {
        this.takingCourses = x$1;
    }

    public AuditGroupResult(String indexno, String name, CourseType courseType) {
        this();
        this.indexno_$eq(indexno);
        this.name_$eq(name);
        this.courseType_$eq(courseType);
    }

    public Buffer<AuditCourseResult> courseResults() {
        return this.courseResults;
    }

    public void courseResults_$eq(Buffer<AuditCourseResult> x$1) {
        this.courseResults = x$1;
    }

    public Option<CourseRank> rank() {
        return this.rank;
    }

    public void rank_$eq(Option<CourseRank> x$1) {
        this.rank = x$1;
    }

    public CourseType courseType() {
        return this.courseType;
    }

    public void courseType_$eq(CourseType x$1) {
        this.courseType = x$1;
    }

    public boolean passed() {
        return this.passed;
    }

    public void passed_$eq(boolean x$1) {
        this.passed = x$1;
    }

    public short subCount() {
        return this.subCount;
    }

    public void subCount_$eq(short x$1) {
        this.subCount = x$1;
    }

    public AuditPlanResult planResult() {
        return this.planResult;
    }

    public void planResult_$eq(AuditPlanResult x$1) {
        this.planResult = x$1;
    }

    public void attachTo(AuditPlanResult pl) {
        this.planResult_$eq(pl);
        this.planResult().groupResults().$plus$eq((Object)this);
        this.children().foreach((Function1)(JProcedure1 & Serializable)groupResult -> groupResult.attachTo(this.planResult()));
    }

    public void detach() {
        if (this.planResult() != null) {
            this.planResult().groupResults().$minus$eq((Object)this);
        }
        this.planResult_$eq(null);
        this.children().foreach((Function1)(JProcedure1 & Serializable)groupResult -> groupResult.detach());
    }

    public AuditGroupResult(String name, CourseType courseType) {
        this();
        this.name_$eq(name);
        this.courseType_$eq(courseType);
        this.subCount_$eq((short)0);
    }

    public AuditGroupResult(CourseGroup group) {
        this(group.name(), group.courseType());
        this.subCount_$eq(group.subCount());
    }

    public boolean optional() {
        Option<CourseRank> option = this.rank();
        if (option instanceof Some) {
            CourseRank r = (CourseRank)((Some)option).value();
            return BoxesRunTime.unboxToInt((Object)r.id()) != CourseRank$.MODULE$.Compulsory();
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError(option);
    }

    public void addCourseResult(AuditCourseResult cr) {
        cr.groupResult_$eq(this);
        if (!this.courseResults().exists((Function1 & Serializable)_$11 -> {
            Course course = _$11.course();
            Course course2 = cr.course();
            return !(course != null ? !course.equals(course2) : course2 != null);
        })) {
            this.courseResults().$plus$eq((Object)cr);
        }
        if (cr.passed()) {
            this.addCourse(this, cr.course(), AuditCourseLevel$.Passed);
            return;
        }
        if (cr.predicted()) {
            this.addCourse(this, cr.course(), AuditCourseLevel$.Predicted);
            return;
        }
        if (cr.taking()) {
            this.addCourse(this, cr.course(), AuditCourseLevel$.Taking);
            return;
        }
    }

    public Option<AuditCourseResult> getCourseResult(Course course) {
        return this.courseResults().find((Function1 & Serializable)_$12 -> {
            Course course = _$12.course();
            Course course2 = course;
            return !(course != null ? !course.equals(course2) : course2 != null);
        });
    }

    private void addCourse(AuditGroupResult gr, Course course, AuditCourseLevel level) {
        EducationLevel eduLevel = gr.planResult().std().level();
        float credits = course.getCredits(eduLevel);
        AuditCourseLevel auditCourseLevel = level;
        AuditCourseLevel auditCourseLevel2 = AuditCourseLevel$.Passed;
        AuditCourseLevel auditCourseLevel3 = auditCourseLevel;
        if (!(auditCourseLevel2 != null ? !auditCourseLevel2.equals(auditCourseLevel3) : auditCourseLevel3 != null)) {
            v1 = gr.passedCourses().add((Object)course);
        } else {
            AuditCourseLevel auditCourseLevel4 = AuditCourseLevel$.Predicted;
            AuditCourseLevel auditCourseLevel5 = auditCourseLevel;
            if (!(auditCourseLevel4 != null ? !auditCourseLevel4.equals(auditCourseLevel5) : auditCourseLevel5 != null)) {
                v1 = gr.predictedCourses().add((Object)course);
            } else {
                AuditCourseLevel auditCourseLevel6 = AuditCourseLevel$.Taking;
                AuditCourseLevel auditCourseLevel7 = auditCourseLevel;
                if (!(auditCourseLevel6 != null ? !auditCourseLevel6.equals(auditCourseLevel7) : auditCourseLevel7 != null)) {
                    v1 = gr.takingCourses().add((Object)course);
                } else {
                    throw new MatchError((Object)auditCourseLevel);
                }
            }
        }
        gr.parent().foreach((Function1)(JProcedure1 & Serializable)p -> this.addCourse((AuditGroupResult)((Object)p), course, level));
    }

    public void addChild(AuditGroupResult gr) {
        gr.parent_$eq((Option)Some$.MODULE$.apply((Object)this));
        this.children().$plus$eq((Object)gr);
    }

    public void removeChild(AuditGroupResult gr) {
        gr.parent_$eq(null);
        this.children().$minus$eq((Object)gr);
    }

    public void stat() {
        boolean sonPassed = true;
        float sonOwedCredits = 0.0f;
        float sonOwedCredits2 = 0.0f;
        float sonOwedCredits3 = 0.0f;
        ObjectRef childOwedList = ObjectRef.create((Object)Collections$.MODULE$.newBuffer());
        ObjectRef childOwedList2 = ObjectRef.create((Object)Collections$.MODULE$.newBuffer());
        ObjectRef childOwedList3 = ObjectRef.create((Object)Collections$.MODULE$.newBuffer());
        if (this.children().nonEmpty()) {
            this.children().foreach((Function1)(JProcedure1 & Serializable)_$13 -> _$13.stat());
            short requiredNum = this.subCount() >= 0 ? this.subCount() : (short)this.children().size();
            IntRef passedCnt = IntRef.create((int)0);
            this.children().foreach((Function1)(JProcedure1 & Serializable)childResult -> {
                if (childResult.passed()) {
                    int n;
                    passedCnt$1.elem = n = passedCnt$1.elem + 1;
                }
                if (requiredNum > 0 && childResult.requiredCredits() > 0.0f) {
                    ((Buffer)childOwedList$1.elem).addOne((Object)childResult);
                    ((Buffer)childOwedList2$1.elem).addOne((Object)childResult);
                    ((Buffer)childOwedList3$1.elem).addOne((Object)childResult);
                    return;
                }
            });
            Buffer buffer = (Buffer)((IterableOps)((Buffer)childOwedList.elem).sortBy((Function1 & Serializable)_$14 -> _$14.owedCredits(), (Ordering)Ordering.DeprecatedFloatOrdering$.MODULE$)).take(Short$.MODULE$.short2int(requiredNum));
            childOwedList.elem = buffer;
            buffer = null;
            Buffer buffer2 = (Buffer)((IterableOps)((Buffer)childOwedList2.elem).sortBy((Function1 & Serializable)_$15 -> _$15.owedCredits2(), (Ordering)Ordering.DeprecatedFloatOrdering$.MODULE$)).take(Short$.MODULE$.short2int(requiredNum));
            childOwedList2.elem = buffer2;
            buffer2 = null;
            Buffer buffer3 = (Buffer)((IterableOps)((Buffer)childOwedList3.elem).sortBy((Function1 & Serializable)_$16 -> _$16.owedCredits3(), (Ordering)Ordering.DeprecatedFloatOrdering$.MODULE$)).take(Short$.MODULE$.short2int(requiredNum));
            childOwedList3.elem = buffer3;
            buffer3 = null;
            sonPassed = passedCnt.elem >= requiredNum;
            sonOwedCredits = BoxesRunTime.unboxToFloat((Object)((IterableOnceOps)((Buffer)childOwedList.elem).map((Function1 & Serializable)_$17 -> _$17.owedCredits())).sum((Numeric)Numeric.FloatIsFractional$.MODULE$));
            sonOwedCredits2 = BoxesRunTime.unboxToFloat((Object)((IterableOnceOps)((Buffer)childOwedList2.elem).map((Function1 & Serializable)_$18 -> _$18.owedCredits2())).sum((Numeric)Numeric.FloatIsFractional$.MODULE$));
            sonOwedCredits3 = BoxesRunTime.unboxToFloat((Object)((IterableOnceOps)((Buffer)childOwedList3.elem).map((Function1 & Serializable)_$19 -> _$19.owedCredits3())).sum((Numeric)Numeric.FloatIsFractional$.MODULE$));
        }
        EducationLevel eduLevel = this.planResult().std().level();
        this.passedCredits_$eq(BoxesRunTime.unboxToFloat((Object)((IterableOnceOps)this.passedCourses().toSeq().map((Function1 & Serializable)_$20 -> _$20.getCredits(eduLevel))).sum((Numeric)Numeric.FloatIsFractional$.MODULE$)));
        float passedCredits2 = BoxesRunTime.unboxToFloat((Object)((IterableOnceOps)this.predictedCourses().toSeq().map((Function1 & Serializable)_$21 -> _$21.getCredits(eduLevel))).sum((Numeric)Numeric.FloatIsFractional$.MODULE$));
        float passedCredits3 = BoxesRunTime.unboxToFloat((Object)((IterableOnceOps)this.takingCourses().toSeq().map((Function1 & Serializable)_$22 -> _$22.getCredits(eduLevel))).sum((Numeric)Numeric.FloatIsFractional$.MODULE$));
        Buffer cp = (Buffer)this.courseResults().filter((Function1 & Serializable)_$23 -> _$23.compulsory());
        float cpOwedCredits = BoxesRunTime.unboxToFloat((Object)((IterableOnceOps)((IterableOps)cp.filter((Function1 & Serializable)_$24 -> !_$24.passed())).map((Function1 & Serializable)_$25 -> _$25.course().getCredits(eduLevel))).sum((Numeric)Numeric.FloatIsFractional$.MODULE$));
        float cpOwedCredits2 = BoxesRunTime.unboxToFloat((Object)((IterableOnceOps)((IterableOps)cp.filter((Function1 & Serializable)x -> !x.passed() && !x.predicted())).map((Function1 & Serializable)_$26 -> _$26.course().getCredits(eduLevel))).sum((Numeric)Numeric.FloatIsFractional$.MODULE$));
        float cpOwedCredits3 = BoxesRunTime.unboxToFloat((Object)((IterableOnceOps)((IterableOps)cp.filter((Function1 & Serializable)x -> !x.passed() && !x.predicted() && !x.taking())).map((Function1 & Serializable)_$27 -> _$27.course().getCredits(eduLevel))).sum((Numeric)Numeric.FloatIsFractional$.MODULE$));
        float totalOwed = this.requiredCredits() - this.convertedCredits() - (cpOwedCredits + sonOwedCredits + this.passedCredits());
        float totalOwed2 = this.requiredCredits() - this.convertedCredits() - (cpOwedCredits2 + sonOwedCredits2 + this.passedCredits() + passedCredits2);
        float totalOwed3 = this.requiredCredits() - this.convertedCredits() - (cpOwedCredits3 + sonOwedCredits3 + this.passedCredits() + passedCredits2 + passedCredits3);
        this.owedCredits_$eq(cpOwedCredits + sonOwedCredits + (totalOwed < 0.0f ? 0.0f : totalOwed));
        this.owedCredits2_$eq(cpOwedCredits2 + sonOwedCredits2 + (totalOwed2 < 0.0f ? 0.0f : totalOwed2));
        this.owedCredits3_$eq(cpOwedCredits3 + sonOwedCredits3 + (totalOwed3 < 0.0f ? 0.0f : totalOwed3));
        this.passed_$eq(sonPassed && this.owedCredits() <= 0.0f);
    }

    public int neededGroups() {
        return this.subCount() - this.children().count((Function1 & Serializable)_$28 -> _$28.passed());
    }

    public boolean predicted() {
        return this.owedCredits2() <= 0.0f;
    }

    public void reduceRequired(float credits) {
        this.requiredCredits_$eq(Math.max(this.requiredCredits() - credits, 0.0f));
        if (this.parent().nonEmpty()) {
            ((AuditGroupResult)((Object)this.parent().get())).reduceRequired(credits);
            return;
        }
    }
}

