/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.domain;

import java.io.Serializable;
import org.beangle.commons.collection.Collections$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.openurp.base.model.Semester;
import org.openurp.base.service.SemesterService;
import org.openurp.base.std.model.Student;
import org.openurp.edu.grade.domain.CourseGradeProvider;
import org.openurp.edu.grade.model.CourseGrade;
import org.openurp.edu.grade.model.Grade$Status$;
import org.openurp.edu.his.model.HisCourseGrade;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class DefaultCourseGradeProvider
implements CourseGradeProvider {
    private EntityDao entityDao;
    private SemesterService semesterService;

    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public SemesterService semesterService() {
        return this.semesterService;
    }

    public void semesterService_$eq(SemesterService x$1) {
        this.semesterService = x$1;
    }

    public Seq<CourseGrade> getPublished(Student std, Iterable<Semester> semesters) {
        return this.get(std, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)Grade$Status$.MODULE$.Published())), semesters);
    }

    public Seq<CourseGrade> getAll(Student std, Iterable<Semester> semesters) {
        return this.get(std, (Option<Object>)None$.MODULE$, semesters);
    }

    @Override
    public Map<Object, Object> getPassedStatus(Student std) {
        Tuple2 terms = this.semesterService().get(std.project(), std.beginOn(), std.endOn());
        Buffer rs = Collections$.MODULE$.newBuffer();
        if (((SeqOps)terms._2()).isEmpty()) {
            v0 = (Buffer)rs.addAll(this.getHisPassedStatus(std, (Iterable<Object>)((IterableOnceOps)((IterableOps)terms._1()).map((Function1 & Serializable)_$3 -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(_$3.schoolYear().substring(0, 4))))).toSet()));
        } else if (((SeqOps)terms._1()).isEmpty()) {
            v0 = (Buffer)rs.addAll(this.getCurPassedStatus(std));
        } else {
            rs.addAll(this.getHisPassedStatus(std, (Iterable<Object>)((IterableOnceOps)((IterableOps)terms._1()).map((Function1 & Serializable)_$4 -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(_$4.schoolYear().substring(0, 4))))).toSet()));
            v0 = (Buffer)rs.addAll(this.getCurPassedStatus(std));
        }
        scala.collection.mutable.Map courseMap = Collections$.MODULE$.newMap();
        rs.foreach((Function1 & Serializable)obj -> {
            long courseId = ((Number)obj[0]).longValue();
            if (obj[1] != null) {
                if (!courseMap.contains((Object)BoxesRunTime.boxToLong((long)courseId)) || !courseMap.apply$mcZJ$sp(courseId)) {
                    courseMap.put((Object)BoxesRunTime.boxToLong((long)courseId), (Object)BoxesRunTime.boxToBoolean((boolean)((Boolean)obj[1])));
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            }
            return courseMap.put((Object)BoxesRunTime.boxToLong((long)courseId), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        });
        return courseMap;
    }

    private Seq<CourseGrade> get(Student std, Option<Object> status, Iterable<Semester> semesters) {
        Tuple2 terms;
        Tuple2 tuple2 = terms = semesters.isEmpty() ? this.semesterService().get(std.project(), std.beginOn(), std.endOn()) : semesters.partition((Function1 & Serializable)_$5 -> _$5.archived());
        if (((IterableOnceOps)terms._2()).isEmpty()) {
            return this.getHisGrades(std, status, semesters, (Iterable<Object>)((IterableOnceOps)((IterableOps)terms._1()).map((Function1 & Serializable)_$6 -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(_$6.schoolYear().substring(0, 4))))).toSet());
        }
        if (((IterableOnceOps)terms._1()).isEmpty()) {
            return this.getCurGrades(std, status, semesters);
        }
        return (Seq)this.getHisGrades(std, status, semesters, (Iterable<Object>)((IterableOnceOps)((IterableOps)terms._1()).map((Function1 & Serializable)_$7 -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(_$7.schoolYear().substring(0, 4))))).toSet()).$plus$plus(this.getCurGrades(std, status, semesters));
    }

    private Seq<Object[]> getCurPassedStatus(Student std) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(CourseGrade.class, "grade");
        query.where("grade.std = :std", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std}));
        query.where("grade.project = :project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std.project()}));
        query.where("grade.status = :status", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Grade$Status$.MODULE$.Published())}));
        query.select("grade.course.id,grade.passed");
        return this.entityDao().search((QueryBuilder)query);
    }

    private Seq<Object[]> getHisPassedStatus(Student std, Iterable<Object> schoolYears) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(HisCourseGrade.class, "grade");
        query.where("grade.std = :std", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std}));
        query.where("grade.project = :project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std.project()}));
        query.where("grade.status = :status", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Grade$Status$.MODULE$.Published())}));
        query.where("grade.schoolYear in (:schoolYears)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{schoolYears}));
        query.select("grade.course.id,grade.passed");
        return this.entityDao().search((QueryBuilder)query);
    }

    private Seq<CourseGrade> getCurGrades(Student std, Option<Object> status, Iterable<Semester> semesters) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(CourseGrade.class, "grade");
        query.where("grade.std = :std", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std}));
        query.where("grade.project = :project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std.project()}));
        status.foreach((Function1 & Serializable)s -> DefaultCourseGradeProvider.getCurGrades$$anonfun$1(query, BoxesRunTime.unboxToInt((Object)s)));
        if (semesters.nonEmpty()) {
            query.where("grade.semester in(:semesters)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semesters}));
        }
        return (Seq)this.entityDao().search((QueryBuilder)query).sortBy((Function1 & Serializable)_$8 -> _$8.semester().beginOn(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
    }

    private Seq<CourseGrade> getHisGrades(Student std, Option<Object> status, Iterable<Semester> semesters, Iterable<Object> schoolYears) {
        OqlBuilder query = OqlBuilder$.MODULE$.from(HisCourseGrade.class, "grade");
        query.where("grade.std = :std", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std}));
        query.where("grade.project = :project", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{std.project()}));
        query.where("grade.schoolYear in (:schoolYears)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{schoolYears}));
        status.foreach((Function1 & Serializable)s -> DefaultCourseGradeProvider.getHisGrades$$anonfun$1(query, BoxesRunTime.unboxToInt((Object)s)));
        if (semesters.nonEmpty()) {
            query.where("grade.semester in(:semesters)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{semesters}));
        }
        return (Seq)((SeqOps)this.entityDao().search((QueryBuilder)query).map((Function1 & Serializable)_$9 -> _$9.convert())).sortBy((Function1 & Serializable)_$10 -> _$10.semester().beginOn(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
    }

    private static final /* synthetic */ OqlBuilder getCurGrades$$anonfun$1(OqlBuilder query$1, int s) {
        return (OqlBuilder)query$1.where("grade.status =:status", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)s)}));
    }

    private static final /* synthetic */ OqlBuilder getHisGrades$$anonfun$1(OqlBuilder query$2, int s) {
        return (OqlBuilder)query$2.where("grade.status =:status", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)s)}));
    }
}

