/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.model;

import java.io.Serializable;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Numbers$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.model.LongId;
import org.beangle.data.model.pojo.Hierarchical;
import org.beangle.data.model.pojo.Remark;
import org.openurp.base.edu.model.Course;
import org.openurp.base.edu.model.Terms;
import org.openurp.base.edu.model.Terms$;
import org.openurp.base.model.CalendarStage;
import org.openurp.code.edu.model.CourseModule;
import org.openurp.code.edu.model.CourseModule$;
import org.openurp.code.edu.model.CourseRank;
import org.openurp.code.edu.model.CourseRank$;
import org.openurp.code.edu.model.CourseType;
import org.openurp.code.edu.model.TeachingNature;
import org.openurp.edu.program.model.AbstractPlanCourse;
import org.openurp.edu.program.model.CourseGroup;
import org.openurp.edu.program.model.CoursePlan;
import org.openurp.edu.program.model.CreditHours$;
import org.openurp.edu.program.model.PlanCourse;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordered;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public abstract class AbstractCourseGroup
extends LongId
implements CourseGroup,
Cloneable,
Hierarchical<CourseGroup>,
Remark {
    private String indexno;
    private Option parent;
    private Buffer children;
    private Option remark;
    private CoursePlan plan;
    private Buffer planCourses;
    private Option givenName;
    private CourseType courseType;
    private float credits;
    private int creditHours;
    private Option weeks;
    private String hourRatios;
    private short subCount;
    private String termCredits;
    private Option rank;
    private boolean required;
    private Terms terms;
    private Option stage;

    public AbstractCourseGroup() {
        Ordered.$init$((Ordered)this);
        Hierarchical.$init$((Hierarchical)this);
        Remark.$init$((Remark)this);
        this.planCourses = new ListBuffer();
        this.givenName = None$.MODULE$;
        this.weeks = None$.MODULE$;
        this.subCount = (short)-1;
        this.rank = None$.MODULE$;
        this.required = true;
        this.terms = Terms$.MODULE$.empty();
        this.stage = None$.MODULE$;
    }

    @Override
    public String indexno() {
        return this.indexno;
    }

    public Option parent() {
        return this.parent;
    }

    public Buffer children() {
        return this.children;
    }

    public void indexno_$eq(String x$1) {
        this.indexno = x$1;
    }

    public void parent_$eq(Option x$1) {
        this.parent = x$1;
    }

    public void children_$eq(Buffer x$1) {
        this.children = x$1;
    }

    public Option remark() {
        return this.remark;
    }

    public void remark_$eq(Option x$1) {
        this.remark = x$1;
    }

    @Override
    public CoursePlan plan() {
        return this.plan;
    }

    public void plan_$eq(CoursePlan x$1) {
        this.plan = x$1;
    }

    public Buffer<PlanCourse> planCourses() {
        return this.planCourses;
    }

    public void planCourses_$eq(Buffer<PlanCourse> x$1) {
        this.planCourses = x$1;
    }

    public Option<String> givenName() {
        return this.givenName;
    }

    public void givenName_$eq(Option<String> x$1) {
        this.givenName = x$1;
    }

    @Override
    public CourseType courseType() {
        return this.courseType;
    }

    public void courseType_$eq(CourseType x$1) {
        this.courseType = x$1;
    }

    @Override
    public float credits() {
        return this.credits;
    }

    public void credits_$eq(float x$1) {
        this.credits = x$1;
    }

    @Override
    public int creditHours() {
        return this.creditHours;
    }

    public void creditHours_$eq(int x$1) {
        this.creditHours = x$1;
    }

    public Option<Object> weeks() {
        return this.weeks;
    }

    public void weeks_$eq(Option<Object> x$1) {
        this.weeks = x$1;
    }

    @Override
    public String hourRatios() {
        return this.hourRatios;
    }

    public void hourRatios_$eq(String x$1) {
        this.hourRatios = x$1;
    }

    @Override
    public short subCount() {
        return this.subCount;
    }

    public void subCount_$eq(short x$1) {
        this.subCount = x$1;
    }

    @Override
    public String termCredits() {
        return this.termCredits;
    }

    public void termCredits_$eq(String x$1) {
        this.termCredits = x$1;
    }

    @Override
    public Option<CourseRank> rank() {
        return this.rank;
    }

    public void rank_$eq(Option<CourseRank> x$1) {
        this.rank = x$1;
    }

    public boolean required() {
        return this.required;
    }

    public void required_$eq(boolean x$1) {
        this.required = x$1;
    }

    @Override
    public Terms terms() {
        return this.terms;
    }

    public void terms_$eq(Terms x$1) {
        this.terms = x$1;
    }

    @Override
    public Option<CalendarStage> stage() {
        return this.stage;
    }

    public void stage_$eq(Option<CalendarStage> x$1) {
        this.stage = x$1;
    }

    @Override
    public boolean autoAddup() {
        Option<CourseRank> option = this.rank();
        if (option instanceof Some) {
            CourseRank r = (CourseRank)((Some)option).value();
            return BoxesRunTime.unboxToInt((Object)r.id()) == CourseRank$.MODULE$.Compulsory();
        }
        if (None$.MODULE$.equals(option)) {
            return true;
        }
        throw new MatchError(option);
    }

    @Override
    public boolean allowUnplanned() {
        Option<CourseRank> option = this.rank();
        if (option instanceof Some) {
            CourseRank r = (CourseRank)((Some)option).value();
            return BoxesRunTime.unboxToInt((Object)r.id()) == CourseRank$.MODULE$.Selective() || BoxesRunTime.unboxToInt((Object)r.id()) == CourseRank$.MODULE$.FreeSelective();
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError(option);
    }

    @Override
    public boolean optional() {
        Option<CourseRank> option = this.rank();
        if (option instanceof Some) {
            CourseRank r = (CourseRank)((Some)option).value();
            return BoxesRunTime.unboxToInt((Object)r.id()) != CourseRank$.MODULE$.Compulsory();
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError(option);
    }

    public boolean practical() {
        Option option = this.courseType().module();
        if (option instanceof Some) {
            CourseModule r = (CourseModule)((Some)option).value();
            return BoxesRunTime.unboxToInt((Object)r.id()) == CourseModule$.MODULE$.Practical();
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError((Object)option);
    }

    @Override
    public String name() {
        StringBuilder sb = new StringBuilder();
        if (this.courseType() != null) {
            sb.append(this.courseType().name());
        }
        this.givenName().foreach((Function1 & Serializable)x -> sb.append(" ").append(x));
        return sb.toString();
    }

    public String shortName() {
        Option<String> option = this.givenName();
        if (None$.MODULE$.equals(option)) {
            return (String)this.courseType().shortName().getOrElse(this::shortName$$anonfun$1);
        }
        if (option instanceof Some) {
            String gn = (String)((Some)option).value();
            return gn;
        }
        throw new MatchError(option);
    }

    public int index() {
        int idx;
        String index = Strings$.MODULE$.substringAfterLast(this.indexno(), ".");
        if (Strings$.MODULE$.isEmpty((CharSequence)index)) {
            index = this.indexno();
        }
        if ((idx = Numbers$.MODULE$.toInt(index, Numbers$.MODULE$.toInt$default$2())) <= 0) {
            idx = 1;
        }
        return idx;
    }

    public void addGroup(AbstractCourseGroup group) {
        group.parent_$eq((Option)Some$.MODULE$.apply((Object)this));
        this.children().$plus$eq((Object)group);
    }

    public void addCourse(AbstractPlanCourse planCourse) {
        if (!this.planCourses().exists((Function1 & Serializable)_$7 -> {
            Course course = _$7.course();
            Course course2 = planCourse.course();
            return !(course != null ? !course.equals(course2) : course2 != null);
        })) {
            planCourse.group_$eq(this);
            this.planCourses().$plus$eq((Object)planCourse);
            return;
        }
    }

    public void removeCourse(PlanCourse pc) {
        this.planCourses().$minus$eq((Object)pc);
    }

    public void addCourses(Iterable<AbstractPlanCourse> planCourses) {
        planCourses.foreach((Function1)(JProcedure1 & Serializable)element -> this.addCourse((AbstractPlanCourse)element));
    }

    public void follow(CoursePlan plan) {
        this.plan_$eq(plan);
        this.children().foreach((Function1)(JProcedure1 & Serializable)c -> ((AbstractCourseGroup)c).follow(plan));
    }

    public scala.collection.immutable.Seq<CourseGroup> parents() {
        Buffer ps = Collections$.MODULE$.newBuffer();
        Option<CourseGroup> p = this.parent();
        while (p.isDefined()) {
            ps.insert(0, p.get());
            p = ((CourseGroup)p.get()).parent();
        }
        return ps.toSeq();
    }

    public scala.collection.immutable.Seq<CourseGroup> path() {
        Buffer ps = Collections$.MODULE$.newBuffer();
        Option<CourseGroup> p = this.parent();
        while (p.isDefined()) {
            ps.insert(0, p.get());
            p = ((CourseGroup)p.get()).parent();
        }
        ps.addOne((Object)this);
        return ps.toSeq();
    }

    public Seq<PlanCourse> getTermCourses(Terms terms) {
        if (Strings$.MODULE$.isEmpty(null)) {
            return this.planCourses().toList();
        }
        return (Seq)this.planCourses().filter((Function1 & Serializable)pc -> pc.matchTerm(terms));
    }

    public int compare(CourseGroup o) {
        return this.indexno().compareTo(o.indexno());
    }

    @Override
    public boolean isLeaf() {
        return this.children().isEmpty() && this.planCourses().isEmpty();
    }

    @Override
    public Map<TeachingNature, Object> getHours(Seq<TeachingNature> natures) {
        if (this.courseType() == null) {
            return Predef$.MODULE$.Map().empty();
        }
        boolean practical = this.courseType().module().exists((Function1 & Serializable)_$8 -> _$8.practical());
        return CreditHours$.MODULE$.toHours(this.creditHours(), this.hourRatios(), natures, practical);
    }

    public boolean isTermCreditsEmpty() {
        if (Strings$.MODULE$.isEmpty((CharSequence)this.termCredits())) {
            return true;
        }
        Object object = Predef$.MODULE$.refArrayOps((Object[])Strings$.MODULE$.split(this.termCredits(), ","));
        Set credits = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$9 -> _$9.trim(), ClassTag$.MODULE$.apply(String.class))).toSet();
        if (credits.size() == 1) {
            Object object2 = credits.head();
            String string = "0";
            return !(object2 != null ? !object2.equals(string) : string != null);
        }
        return false;
    }

    public scala.collection.immutable.Seq<Object> termCreditSeq() {
        if (Strings$.MODULE$.isEmpty((CharSequence)this.termCredits())) {
            return (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        }
        Object object = Predef$.MODULE$.refArrayOps((Object[])Strings$.MODULE$.split(this.termCredits(), ","));
        Object object2 = Predef$.MODULE$.doubleArrayOps((double[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$10 -> StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(_$10)), ClassTag$.MODULE$.apply(Double.TYPE)));
        return ArrayOps$.MODULE$.toIndexedSeq$extension(object2);
    }

    public String toString() {
        return this.indexno() + " " + this.name();
    }

    private final String shortName$$anonfun$1() {
        return this.courseType().name();
    }
}

