/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.exam.model;

import java.io.Serializable;
import java.time.LocalDate;
import org.beangle.commons.collection.Collections$;
import org.beangle.data.model.LongId;
import org.beangle.data.model.pojo.Remark;
import org.openurp.base.model.Campus;
import org.openurp.base.model.Department;
import org.openurp.base.model.Project;
import org.openurp.base.model.Semester;
import org.openurp.base.model.User;
import org.openurp.edu.exam.model.InvigilationQuotaDetail;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Set;
import scala.collection.mutable.Buffer;
import scala.runtime.DoubleRef;
import scala.runtime.FloatRef;
import scala.runtime.function.JProcedure1;

public class InvigilationQuota
extends LongId
implements Remark {
    private Option remark;
    private Project project;
    private Semester semester;
    private User invigilator;
    private int amount;
    private Buffer details;
    private Buffer excludes;

    public InvigilationQuota() {
        Remark.$init$((Remark)this);
        this.details = Collections$.MODULE$.newBuffer();
        this.excludes = Collections$.MODULE$.newBuffer();
    }

    public Option remark() {
        return this.remark;
    }

    public void remark_$eq(Option x$1) {
        this.remark = x$1;
    }

    public Project project() {
        return this.project;
    }

    public void project_$eq(Project x$1) {
        this.project = x$1;
    }

    public Semester semester() {
        return this.semester;
    }

    public void semester_$eq(Semester x$1) {
        this.semester = x$1;
    }

    public User invigilator() {
        return this.invigilator;
    }

    public void invigilator_$eq(User x$1) {
        this.invigilator = x$1;
    }

    public int amount() {
        return this.amount;
    }

    public void amount_$eq(int x$1) {
        this.amount = x$1;
    }

    public Buffer<InvigilationQuotaDetail> details() {
        return this.details;
    }

    public void details_$eq(Buffer<InvigilationQuotaDetail> x$1) {
        this.details = x$1;
    }

    public Buffer<LocalDate> excludes() {
        return this.excludes;
    }

    public void excludes_$eq(Buffer<LocalDate> x$1) {
        this.excludes = x$1;
    }

    public InvigilationQuotaDetail addQuota(Campus campus, Department depart, float amount) {
        InvigilationQuotaDetail result = null;
        Option option = this.details().find((Function1 & Serializable)x -> {
            Campus campus = x.campus();
            Campus campus2 = campus;
            if (campus == null) {
                if (campus2 != null) {
                    return false;
                }
            } else if (!campus.equals(campus2)) return false;
            Department department = x.depart();
            Department department2 = depart;
            if (department == null) {
                if (department2 == null) return true;
                return false;
            } else {
                if (!department.equals(department2)) return false;
                return true;
            }
        });
        if (None$.MODULE$.equals(option)) {
            InvigilationQuotaDetail detail = new InvigilationQuotaDetail(campus, depart, amount);
            detail.quota_$eq(this);
            this.details().$plus$eq((Object)detail);
            result = detail;
        } else if (option instanceof Some) {
            InvigilationQuotaDetail detail = (InvigilationQuotaDetail)((Object)((Some)option).value());
            detail.amount_$eq(detail.amount() + amount);
            result = detail;
        } else {
            throw new MatchError((Object)option);
        }
        FloatRef sum = FloatRef.create((float)0.0f);
        this.details().foreach((Function1)(JProcedure1 & Serializable)iq -> sum$1.elem += iq.amount());
        this.amount_$eq(Math.round(sum.elem));
        return result;
    }

    public void clearQuota() {
        this.amount_$eq(0);
        this.details().foreach((Function1)(JProcedure1 & Serializable)iq -> iq.amount_$eq(0.0f));
    }

    public boolean cleanup() {
        Buffer removed = Collections$.MODULE$.newBuffer();
        DoubleRef sum = DoubleRef.create((double)0.0);
        this.details().foreach((Function1)(JProcedure1 & Serializable)iq -> {
            if (Float.compare(0.0f, iq.amount()) == 0) {
                removed.$plus$eq((Object)iq);
            }
            iq.amount_$eq(Math.round(iq.amount()));
            sum$2.elem += (double)iq.amount();
        });
        this.amount_$eq((int)sum.elem);
        int oldSize = this.details().size();
        this.details().$minus$minus$eq((IterableOnce)removed);
        return this.details().size() < oldSize;
    }

    public Set<Department> departs() {
        return ((IterableOnceOps)this.details().map((Function1 & Serializable)_$5 -> _$5.depart())).toSet();
    }

    public Set<Campus> campuses() {
        return ((IterableOnceOps)this.details().map((Function1 & Serializable)_$6 -> _$6.campus())).toSet();
    }

    public int getCampusQuota(Campus campus) {
        DoubleRef sum = DoubleRef.create((double)0.0);
        this.details().foreach((Function1)(JProcedure1 & Serializable)iq -> {
            Campus campus = iq.campus();
            Campus campus2 = campus;
            if (!(campus != null ? !campus.equals(campus2) : campus2 != null)) {
                sum$3.elem += (double)iq.amount();
                return;
            }
        });
        return (int)sum.elem;
    }
}

