/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.domain;

import java.io.Serializable;
import java.time.Instant;
import org.beangle.commons.collection.Collections$;
import org.openurp.edu.grade.domain.AuditPlanContext;
import org.openurp.edu.grade.domain.DefaultAuditGroupResultBuilder$;
import org.openurp.edu.grade.domain.PlanAuditor;
import org.openurp.edu.grade.model.AuditCourseResult;
import org.openurp.edu.grade.model.AuditGroupResult;
import org.openurp.edu.grade.model.AuditPlanResult;
import org.openurp.edu.grade.model.CourseGrade;
import org.openurp.edu.program.model.CourseGroup;
import org.openurp.edu.program.model.CoursePlan;
import org.openurp.edu.program.model.PlanCourse;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.runtime.FloatRef;
import scala.runtime.function.JProcedure1;

public class DefaultPlanAuditor
implements PlanAuditor {
    @Override
    public AuditPlanResult audit(AuditPlanContext context) {
        AuditPlanResult apr = new AuditPlanResult(context.std());
        apr.passed_$eq(false);
        apr.remark_$eq(null);
        apr.updatedAt_$eq(Instant.now());
        context.result_$eq(apr);
        CoursePlan plan = context.coursePlan();
        if (plan == null || context.stdGrade() == null) {
            return context.result();
        }
        float creditsRequired = context.coursePlan().credits();
        apr.requiredCredits_$eq(creditsRequired);
        plan.topGroups().foreach((Function1)(JProcedure1 & Serializable)g -> {
            AuditGroupResult topResult = DefaultAuditGroupResultBuilder$.MODULE$.buildResult(context, (CourseGroup)g);
            apr.addGroupResult(topResult);
            this.initResult(context, (CourseGroup)g, topResult);
        });
        apr.buildGroupCache();
        context.listeners().foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.start(context));
        plan.topGroups().foreach((Function1)(JProcedure1 & Serializable)g -> this.auditGroup(context, (CourseGroup)g, (AuditGroupResult)((Object)((Object)apr.getGroupResult(g.name()).get()))));
        context.listeners().foreach((Function1)(JProcedure1 & Serializable)_$2 -> _$2.end(context));
        apr.stat(apr.stat$default$1());
        context.coursePlan().program().offsetType().foreach((Function1)(JProcedure1 & Serializable)offsetType -> apr.getGroupResult(offsetType.name()).foreach((Function1)(JProcedure1 & Serializable)lastTarget -> {
            this.processConvertCredits((AuditGroupResult)((Object)((Object)lastTarget)), apr);
            if (lastTarget.passedCredits() == 0.0f && lastTarget.requiredCredits() == 0.0f && lastTarget.courseResults().isEmpty()) {
                apr.removeGroupResult((AuditGroupResult)((Object)((Object)lastTarget)));
                return;
            }
        }));
        this.cleanupElectiveCourses(apr);
        return apr;
    }

    private void initResult(AuditPlanContext context, CourseGroup courseGroup, AuditGroupResult gr) {
        AuditPlanResult result = context.result();
        courseGroup.children().foreach((Function1)(JProcedure1 & Serializable)child -> {
            AuditGroupResult childResult = DefaultAuditGroupResultBuilder$.MODULE$.buildResult(context, (CourseGroup)child);
            gr.addChild(childResult);
            result.addGroupResult(childResult);
            this.initResult(context, (CourseGroup)child, childResult);
        });
    }

    private void auditGroup(AuditPlanContext context, CourseGroup courseGroup, AuditGroupResult gr) {
        AuditPlanResult result = context.result();
        courseGroup.planCourses().foreach((Function1)(JProcedure1 & Serializable)pc -> {
            AuditCourseResult cr = new AuditCourseResult((PlanCourse)pc);
            Option<CourseGrade> courseGrades = context.stdGrade().useGrade(pc.course());
            cr.updatePassed((Iterable<CourseGrade>)Option$.MODULE$.option2Iterable(courseGrades));
            gr.addCourseResult(cr);
        });
        courseGroup.children().foreach((Function1)(JProcedure1 & Serializable)child -> {
            AuditGroupResult childResult = (AuditGroupResult)((Object)((Object)context.result().getGroupResult(child.name()).get()));
            if (context.listeners().exists((Function1 & Serializable)_$3 -> !_$3.startGroup(context, (CourseGroup)child, childResult))) {
                result.reduceRequired(childResult.requiredCredits());
                childResult.reduceRequired(childResult.requiredCredits());
                return;
            }
            this.auditGroup(context, (CourseGroup)child, childResult);
        });
    }

    public void processConvertCredits(AuditGroupResult target, AuditPlanResult result) {
        Set parents = Collections$.MODULE$.newSet();
        Set sibling = Collections$.MODULE$.newSet();
        AuditGroupResult start = (AuditGroupResult)((Object)target.parent().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        while (start != null && !parents.contains((Object)start)) {
            parents.add((Object)start);
            start = (AuditGroupResult)((Object)start.parent().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        }
        target.parent().foreach((Function1 & Serializable)p -> {
            sibling.$plus$plus$eq((IterableOnce)p.children());
            return sibling.remove((Object)target);
        });
        FloatRef otherConverted = FloatRef.create((float)0.0f);
        FloatRef siblingConverted = FloatRef.create((float)0.0f);
        result.groupResults().foreach((Function1)(JProcedure1 & Serializable)gr -> {
            AuditGroupResult auditGroupResult = gr;
            AuditGroupResult auditGroupResult2 = target;
            if ((auditGroupResult == null ? auditGroupResult2 != null : !((Object)((Object)auditGroupResult)).equals((Object)auditGroupResult2)) && !parents.contains((Object)gr)) {
                float rest = gr.passedCredits() - gr.requiredCredits();
                if (sibling.contains((Object)gr)) {
                    siblingConverted$1.elem = siblingConverted$1.elem + (rest > 0.0f ? rest : 0.0f);
                    return;
                }
                if (gr.parent().isEmpty()) {
                    otherConverted$1.elem = otherConverted$1.elem + (rest > 0.0f ? rest : 0.0f);
                    return;
                }
                return;
            }
        });
        target.convertedCredits_$eq(otherConverted.elem + siblingConverted.elem);
        parents.foreach((Function1)(JProcedure1 & Serializable)r -> r.convertedCredits_$eq(otherConverted$2.elem));
        target.stat();
        result.stat(false);
    }

    public void cleanupElectiveCourses(AuditPlanResult result) {
        result.groupResults().withFilter((Function1 & Serializable)gr -> gr.optional() || gr.passed()).foreach((Function1 & Serializable)gr -> {
            Buffer empties = (Buffer)gr.courseResults().filter((Function1 & Serializable)x -> !x.compulsory() && !x.passed() && !x.predicted() && !x.taking() && !x.hasGrade());
            return (Buffer)gr.courseResults().subtractAll((IterableOnce)empties);
        });
    }
}

