/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.model;

import java.io.Serializable;
import java.time.Instant;
import org.beangle.commons.collection.Collections$;
import org.beangle.data.model.LongId;
import org.beangle.data.model.pojo.Remark;
import org.beangle.data.model.pojo.Updated;
import org.openurp.base.edu.model.Course;
import org.openurp.base.std.model.Student;
import org.openurp.edu.grade.model.AuditCourseResult;
import org.openurp.edu.grade.model.AuditGroupResult;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public class AuditPlanResult
extends LongId
implements Updated,
Remark {
    private Instant updatedAt;
    private Option remark;
    private Student std;
    private Buffer groupResults;
    private boolean passed;
    private boolean predicted;
    private float requiredCredits;
    private float passedCredits;
    private float owedCredits;
    private float owedCredits2;
    private float owedCredits3;
    private Option updates;
    private boolean archived;
    private transient Map<String, AuditGroupResult> groupCache;

    public AuditPlanResult() {
        Updated.$init$((Updated)this);
        Remark.$init$((Remark)this);
        this.groupResults = Collections$.MODULE$.newBuffer();
        this.updates = None$.MODULE$;
        this.archived = false;
    }

    public Instant updatedAt() {
        return this.updatedAt;
    }

    public void updatedAt_$eq(Instant x$1) {
        this.updatedAt = x$1;
    }

    public Option remark() {
        return this.remark;
    }

    public void remark_$eq(Option x$1) {
        this.remark = x$1;
    }

    public Student std() {
        return this.std;
    }

    public void std_$eq(Student x$1) {
        this.std = x$1;
    }

    public Buffer<AuditGroupResult> groupResults() {
        return this.groupResults;
    }

    public void groupResults_$eq(Buffer<AuditGroupResult> x$1) {
        this.groupResults = x$1;
    }

    public boolean passed() {
        return this.passed;
    }

    public void passed_$eq(boolean x$1) {
        this.passed = x$1;
    }

    public boolean predicted() {
        return this.predicted;
    }

    public void predicted_$eq(boolean x$1) {
        this.predicted = x$1;
    }

    public float requiredCredits() {
        return this.requiredCredits;
    }

    public void requiredCredits_$eq(float x$1) {
        this.requiredCredits = x$1;
    }

    public float passedCredits() {
        return this.passedCredits;
    }

    public void passedCredits_$eq(float x$1) {
        this.passedCredits = x$1;
    }

    public float owedCredits() {
        return this.owedCredits;
    }

    public void owedCredits_$eq(float x$1) {
        this.owedCredits = x$1;
    }

    public float owedCredits2() {
        return this.owedCredits2;
    }

    public void owedCredits2_$eq(float x$1) {
        this.owedCredits2 = x$1;
    }

    public float owedCredits3() {
        return this.owedCredits3;
    }

    public void owedCredits3_$eq(float x$1) {
        this.owedCredits3 = x$1;
    }

    public Option<String> updates() {
        return this.updates;
    }

    public void updates_$eq(Option<String> x$1) {
        this.updates = x$1;
    }

    public boolean archived() {
        return this.archived;
    }

    public void archived_$eq(boolean x$1) {
        this.archived = x$1;
    }

    public void buildGroupCache() {
        this.groupCache = ((IterableOnceOps)this.groupResults().map((Function1 & Serializable)x -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)x.name());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)x);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Seq<AuditGroupResult> topGroupResults() {
        ListBuffer results = new ListBuffer();
        this.groupResults().withFilter((Function1 & Serializable)result -> result.parent().isEmpty()).foreach((Function1 & Serializable)result -> (ListBuffer)results.$plus$eq((Object)result));
        return results;
    }

    public void addGroupResult(AuditGroupResult rs) {
        rs.planResult_$eq(this);
        this.groupResults().$plus$eq((Object)rs);
    }

    public void removeGroupResult(AuditGroupResult rs) {
        rs.planResult_$eq(null);
        this.groupResults().$minus$eq((Object)rs);
    }

    public Option<AuditGroupResult> getGroupResult(String name) {
        if (this.groupResults() == null) {
            return None$.MODULE$;
        }
        if (this.groupCache == null) {
            return this.groupResults().find((Function1 & Serializable)_$10 -> {
                String string = _$10.name();
                String string2 = name;
                return !(string != null ? !string.equals(string2) : string2 != null);
            });
        }
        return this.groupCache.get((Object)name);
    }

    public Option<AuditCourseResult> getCourseResult(Course course) {
        if (this.groupResults() == null) {
            return None$.MODULE$;
        }
        Iterator gIter = this.groupResults().iterator();
        None$ result = None$.MODULE$;
        while (gIter.hasNext() && result.isEmpty()) {
            AuditGroupResult g = (AuditGroupResult)((Object)gIter.next());
            result = g.courseResults().find((Function1 & Serializable)_$11 -> {
                Course course = _$11.course();
                Course course2 = course;
                return !(course != null ? !course.equals(course2) : course2 != null);
            });
        }
        return result;
    }

    public AuditPlanResult(Student student) {
        this();
        this.std_$eq(student);
    }

    public void stat(boolean cascade) {
        Seq<AuditGroupResult> tops = this.topGroupResults();
        if (cascade) {
            tops.foreach((Function1)(JProcedure1 & Serializable)_$12 -> _$12.stat());
        }
        this.owedCredits_$eq(BoxesRunTime.unboxToFloat((Object)((IterableOnceOps)tops.map((Function1 & Serializable)_$13 -> _$13.owedCredits())).sum((Numeric)Numeric.FloatIsFractional$.MODULE$)));
        this.owedCredits2_$eq(BoxesRunTime.unboxToFloat((Object)((IterableOnceOps)tops.map((Function1 & Serializable)_$14 -> _$14.owedCredits2())).sum((Numeric)Numeric.FloatIsFractional$.MODULE$)));
        this.owedCredits3_$eq(BoxesRunTime.unboxToFloat((Object)((IterableOnceOps)tops.map((Function1 & Serializable)_$15 -> _$15.owedCredits3())).sum((Numeric)Numeric.FloatIsFractional$.MODULE$)));
        Seq inplanTops = (Seq)tops.filter((Function1 & Serializable)_$16 -> {
            String string = _$16.name();
            String string2 = "\u8ba1\u5212\u5916";
            return string == null ? string2 != null : !string.equals(string2);
        });
        this.passedCredits_$eq(BoxesRunTime.unboxToFloat((Object)((IterableOnceOps)((IterableOps)inplanTops.flatMap((Function1 & Serializable)_$17 -> _$17.passedCourses())).map((Function1 & Serializable)x -> x.getCredits(this.std().level()))).sum((Numeric)Numeric.FloatIsFractional$.MODULE$)));
        this.passed_$eq(inplanTops.count((Function1 & Serializable)_$18 -> _$18.passed()) == inplanTops.size() && this.owedCredits() <= 1.0E-8f);
        this.predicted_$eq(this.owedCredits2() <= 1.0E-8f);
    }

    public boolean stat$default$1() {
        return true;
    }

    public void reduceRequired(float credits) {
        this.requiredCredits_$eq(Math.max(this.requiredCredits() - credits, 0.0f));
    }

    public scala.collection.immutable.Seq<AuditGroupResult> failedGroups(int category) {
        Buffer failed = Collections$.MODULE$.newBuffer();
        this.topGroupResults().foreach((Function1)(JProcedure1 & Serializable)g -> this.collectFailed(category, (AuditGroupResult)((Object)g), (Buffer<AuditGroupResult>)failed));
        return ((IterableOnceOps)failed.sortBy((Function1 & Serializable)_$19 -> _$19.indexno(), (Ordering)Ordering.String$.MODULE$)).toSeq();
    }

    public int failedGroups$default$1() {
        return 1;
    }

    private void collectFailed(int category, AuditGroupResult g, Buffer<AuditGroupResult> failed) {
        int n = category;
        boolean passed = switch (n) {
            case 1 -> g.passed();
            case 2 -> g.predicted();
            case 3 -> {
                if (g.owedCredits3() <= 0.0f) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
        if (!passed) {
            if (g.children().isEmpty()) {
                failed.addOne((Object)g);
                return;
            }
            int n2 = category;
            float owed = switch (n2) {
                case 1 -> g.owedCredits() - BoxesRunTime.unboxToFloat((Object)((IterableOnceOps)g.children().map((Function1 & Serializable)_$20 -> _$20.owedCredits())).sum((Numeric)Numeric.FloatIsFractional$.MODULE$));
                case 2 -> g.owedCredits2() - BoxesRunTime.unboxToFloat((Object)((IterableOnceOps)g.children().map((Function1 & Serializable)_$21 -> _$21.owedCredits2())).sum((Numeric)Numeric.FloatIsFractional$.MODULE$));
                case 3 -> g.owedCredits3() - BoxesRunTime.unboxToFloat((Object)((IterableOnceOps)g.children().map((Function1 & Serializable)_$22 -> _$22.owedCredits3())).sum((Numeric)Numeric.FloatIsFractional$.MODULE$));
                default -> 1.0f;
            };
            if ((double)Math.abs(owed) < 0.01) {
                g.children().foreach((Function1)(JProcedure1 & Serializable)c -> this.collectFailed(category, (AuditGroupResult)((Object)c), failed));
                return;
            }
            failed.addOne((Object)g);
            return;
        }
    }
}

