/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.his.model;

import java.io.Serializable;
import java.time.Instant;
import org.beangle.commons.collection.Collections$;
import org.beangle.data.model.LongId;
import org.beangle.data.model.annotation.archive;
import org.beangle.data.model.pojo.Remark;
import org.beangle.data.model.pojo.Updated;
import org.openurp.base.edu.model.Course;
import org.openurp.base.model.ArchivedByYear;
import org.openurp.base.model.Project;
import org.openurp.base.model.ProjectBased;
import org.openurp.base.model.Semester;
import org.openurp.base.std.model.Student;
import org.openurp.code.edu.model.CourseTakeType;
import org.openurp.code.edu.model.CourseType;
import org.openurp.code.edu.model.ExamMode;
import org.openurp.code.edu.model.GradeType;
import org.openurp.code.edu.model.GradeType$;
import org.openurp.code.edu.model.GradingMode;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.grade.model.CourseGrade;
import org.openurp.edu.grade.model.ExamGrade;
import org.openurp.edu.grade.model.GaGrade;
import org.openurp.edu.grade.model.Grade;
import org.openurp.edu.his.model.HisExamGrade;
import org.openurp.edu.his.model.HisGaGrade;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.mutable.Buffer;
import scala.math.Ordered;

@archive
public class HisCourseGrade
extends LongId
implements ProjectBased,
Ordered,
Updated,
Grade,
Remark,
ArchivedByYear {
    private Project project;
    private Instant updatedAt;
    private Instant createdAt;
    private Option remark;
    private int schoolYear;
    private Student std;
    private Course course;
    private CourseTakeType courseTakeType;
    private Semester semester;
    private String crn;
    private CourseType courseType;
    private Option gp;
    private boolean freeListening;
    private Buffer gaGrades;
    private Buffer examGrades;
    private ExamMode examMode;
    private Option score;
    private Option scoreText;
    private boolean passed;
    private int status;
    private GradingMode gradingMode;
    private Option operator;
    private Option clazz;
    private Option provider;

    public HisCourseGrade() {
        ProjectBased.$init$((ProjectBased)this);
        Ordered.$init$((Ordered)this);
        Updated.$init$((Updated)this);
        Grade.$init$(this);
        Remark.$init$((Remark)this);
        ArchivedByYear.$init$((ArchivedByYear)this);
        this.gp = None$.MODULE$;
        this.freeListening = false;
        this.gaGrades = Collections$.MODULE$.newBuffer();
        this.examGrades = Collections$.MODULE$.newBuffer();
        this.score = None$.MODULE$;
        this.scoreText = None$.MODULE$;
        this.operator = None$.MODULE$;
        this.clazz = None$.MODULE$;
        this.provider = None$.MODULE$;
    }

    public Project project() {
        return this.project;
    }

    public void project_$eq(Project x$1) {
        this.project = x$1;
    }

    public Instant updatedAt() {
        return this.updatedAt;
    }

    public void updatedAt_$eq(Instant x$1) {
        this.updatedAt = x$1;
    }

    @Override
    public Instant createdAt() {
        return this.createdAt;
    }

    @Override
    public void createdAt_$eq(Instant x$1) {
        this.createdAt = x$1;
    }

    public Option remark() {
        return this.remark;
    }

    public void remark_$eq(Option x$1) {
        this.remark = x$1;
    }

    public int schoolYear() {
        return this.schoolYear;
    }

    public void schoolYear_$eq(int x$1) {
        this.schoolYear = x$1;
    }

    @Override
    public Student std() {
        return this.std;
    }

    public void std_$eq(Student x$1) {
        this.std = x$1;
    }

    public Course course() {
        return this.course;
    }

    public void course_$eq(Course x$1) {
        this.course = x$1;
    }

    public CourseTakeType courseTakeType() {
        return this.courseTakeType;
    }

    public void courseTakeType_$eq(CourseTakeType x$1) {
        this.courseTakeType = x$1;
    }

    public Semester semester() {
        return this.semester;
    }

    public void semester_$eq(Semester x$1) {
        this.semester = x$1;
    }

    public String crn() {
        return this.crn;
    }

    public void crn_$eq(String x$1) {
        this.crn = x$1;
    }

    public CourseType courseType() {
        return this.courseType;
    }

    public void courseType_$eq(CourseType x$1) {
        this.courseType = x$1;
    }

    public Option<Object> gp() {
        return this.gp;
    }

    public void gp_$eq(Option<Object> x$1) {
        this.gp = x$1;
    }

    public boolean freeListening() {
        return this.freeListening;
    }

    public void freeListening_$eq(boolean x$1) {
        this.freeListening = x$1;
    }

    public Buffer<HisGaGrade> gaGrades() {
        return this.gaGrades;
    }

    public void gaGrades_$eq(Buffer<HisGaGrade> x$1) {
        this.gaGrades = x$1;
    }

    public Buffer<HisExamGrade> examGrades() {
        return this.examGrades;
    }

    public void examGrades_$eq(Buffer<HisExamGrade> x$1) {
        this.examGrades = x$1;
    }

    public ExamMode examMode() {
        return this.examMode;
    }

    public void examMode_$eq(ExamMode x$1) {
        this.examMode = x$1;
    }

    @Override
    public Option<Object> score() {
        return this.score;
    }

    @Override
    public void score_$eq(Option<Object> x$1) {
        this.score = x$1;
    }

    @Override
    public Option<String> scoreText() {
        return this.scoreText;
    }

    @Override
    public void scoreText_$eq(Option<String> x$1) {
        this.scoreText = x$1;
    }

    @Override
    public boolean passed() {
        return this.passed;
    }

    @Override
    public void passed_$eq(boolean x$1) {
        this.passed = x$1;
    }

    @Override
    public int status() {
        return this.status;
    }

    @Override
    public void status_$eq(int x$1) {
        this.status = x$1;
    }

    @Override
    public GradingMode gradingMode() {
        return this.gradingMode;
    }

    @Override
    public void gradingMode_$eq(GradingMode x$1) {
        this.gradingMode = x$1;
    }

    @Override
    public Option<String> operator() {
        return this.operator;
    }

    @Override
    public void operator_$eq(Option<String> x$1) {
        this.operator = x$1;
    }

    public Option<Clazz> clazz() {
        return this.clazz;
    }

    public void clazz_$eq(Option<Clazz> x$1) {
        this.clazz = x$1;
    }

    public Option<String> provider() {
        return this.provider;
    }

    public void provider_$eq(Option<String> x$1) {
        this.provider = x$1;
    }

    public CourseGrade convert() {
        CourseGrade cg = new CourseGrade();
        cg.std_$eq(this.std());
        cg.course_$eq(this.course());
        cg.courseTakeType_$eq(this.courseTakeType());
        cg.semester_$eq(this.semester());
        cg.crn_$eq(this.crn());
        cg.courseType_$eq(this.courseType());
        cg.gp_$eq(this.gp());
        cg.freeListening_$eq(this.freeListening());
        cg.examMode_$eq(this.examMode());
        cg.score_$eq(this.score());
        cg.scoreText_$eq(this.scoreText());
        cg.passed_$eq(this.passed());
        cg.status_$eq(this.status());
        cg.gradingMode_$eq(this.gradingMode());
        cg.operator_$eq(this.operator());
        cg.clazz_$eq(this.clazz());
        cg.provider_$eq(this.provider());
        cg.gaGrades_$eq((Buffer<GaGrade>)((Buffer)this.gaGrades().map((Function1 & Serializable)_$11 -> _$11.convert())));
        cg.examGrades_$eq((Buffer<ExamGrade>)((Buffer)this.examGrades().map((Function1 & Serializable)_$12 -> _$12.convert())));
        return cg;
    }

    public float credits() {
        if (this.std() == null || this.course() == null) {
            return 0.0f;
        }
        return this.course().getCredits(this.std().level());
    }

    public Option<HisExamGrade> getExamGrade(GradeType gt) {
        if (gt.isGa()) {
            throw new RuntimeException(gt.id() + " is not exam grade type");
        }
        return this.examGrades().find((Function1 & Serializable)eg -> {
            GradeType gradeType = eg.gradeType();
            GradeType gradeType2 = gt;
            return !(gradeType != null ? !gradeType.equals(gradeType2) : gradeType2 != null);
        });
    }

    public Option<HisGaGrade> getGaGrade(GradeType gt) {
        if (!gt.isGa()) {
            throw new RuntimeException(gt.id() + " is not ga grade type");
        }
        return this.gaGrades().find((Function1 & Serializable)eg -> {
            GradeType gradeType = eg.gradeType();
            GradeType gradeType2 = gt;
            return !(gradeType != null ? !gradeType.equals(gradeType2) : gradeType2 != null);
        });
    }

    public Option<String> getScoreText(GradeType gt) {
        Option<Grade> option = this.getGrade(gt);
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            Grade g = (Grade)((Some)option).value();
            return g.scoreText();
        }
        throw new MatchError(option);
    }

    public Option<Grade> getGrade(GradeType gradeType) {
        if (gradeType.isGa()) {
            return this.gaGrades().find((Function1 & Serializable)eg -> {
                GradeType gradeType = eg.gradeType();
                GradeType gradeType2 = gradeType;
                return !(gradeType != null ? !gradeType.equals(gradeType2) : gradeType2 != null);
            });
        }
        return this.examGrades().find((Function1 & Serializable)eg -> {
            GradeType gradeType = eg.gradeType();
            GradeType gradeType2 = gradeType;
            return !(gradeType != null ? !gradeType.equals(gradeType2) : gradeType2 != null);
        });
    }

    @Override
    public GradeType gradeType() {
        return new GradeType(GradeType$.MODULE$.Final());
    }
}

