/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.model;

import java.io.Serializable;
import java.time.Instant;
import org.beangle.commons.json.JsonArray;
import org.beangle.commons.json.JsonObject;
import org.beangle.data.model.LongId;
import org.beangle.data.model.pojo.Updated;
import org.openurp.base.std.model.Student;
import org.openurp.edu.clazz.model.Clazz;
import org.openurp.edu.grade.model.RegularGrade$;
import org.openurp.edu.grade.model.RegularGrade$Test$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class RegularGrade
extends LongId
implements Updated {
    private Instant updatedAt;
    private Clazz clazz;
    private Student std;
    private float score;
    private JsonArray testsJson;
    private int status;

    public static Test fromJson(JsonObject jsonObject) {
        return RegularGrade$.MODULE$.fromJson(jsonObject);
    }

    public RegularGrade() {
        Updated.$init$((Updated)this);
        this.testsJson = new JsonArray();
    }

    public Instant updatedAt() {
        return this.updatedAt;
    }

    public void updatedAt_$eq(Instant x$1) {
        this.updatedAt = x$1;
    }

    public Clazz clazz() {
        return this.clazz;
    }

    public void clazz_$eq(Clazz x$1) {
        this.clazz = x$1;
    }

    public Student std() {
        return this.std;
    }

    public void std_$eq(Student x$1) {
        this.std = x$1;
    }

    public float score() {
        return this.score;
    }

    public void score_$eq(float x$1) {
        this.score = x$1;
    }

    public JsonArray testsJson() {
        return this.testsJson;
    }

    public void testsJson_$eq(JsonArray x$1) {
        this.testsJson = x$1;
    }

    public int status() {
        return this.status;
    }

    public void status_$eq(int x$1) {
        this.status = x$1;
    }

    public Map<String, Test> tests() {
        return ((IterableOnceOps)this.testsJson().map((Function1 & Serializable)t -> {
            Test test = RegularGrade$.MODULE$.fromJson((JsonObject)t);
            return Tuple2$.MODULE$.apply((Object)test.name(), (Object)test);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Option<Test> getTest(String name) {
        return this.findTestJson(name).map((Function1 & Serializable)x -> RegularGrade$.MODULE$.fromJson((JsonObject)x));
    }

    private Option<JsonObject> findTestJson(String name) {
        return this.testsJson().find((Function1 & Serializable)t -> {
            JsonObject g = (JsonObject)t;
            String string = g.getString("name", g.getString$default$2());
            String string2 = name;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    public void updateTest(String name, float score, int weight, Option<String> details) {
        Option<JsonObject> option = this.findTestJson(name);
        if (None$.MODULE$.equals(option)) {
            this.testsJson().add((Object)RegularGrade$Test$.MODULE$.apply(name, score, weight, details).toJson());
            return;
        }
        if (option instanceof Some) {
            JsonObject t = (JsonObject)((Some)option).value();
            t.add("name", (Object)name);
            t.add("score", (Object)BoxesRunTime.boxToFloat((float)score));
            t.add("weight", (Object)BoxesRunTime.boxToInteger((int)weight));
            t.add("details", details.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            return;
        }
        throw new MatchError(option);
    }

    public Option<String> updateTest$default$4() {
        return None$.MODULE$;
    }

    public void removeTest(String name) {
        this.findTestJson(name).foreach((Function1 & Serializable)t -> this.testsJson().substractOne(t));
    }

    public void changeName(String oldName, String newName) {
        this.findTestJson(oldName).foreach((Function1 & Serializable)t -> t.update("name", (Object)newName));
    }

    public static class Test
    implements Product,
    Serializable {
        private final String name;
        private final float score;
        private final int weight;
        private final Option details;

        public static Test apply(String string, float f, int n, Option<String> option) {
            return RegularGrade$Test$.MODULE$.apply(string, f, n, option);
        }

        public static Test fromProduct(Product product) {
            return RegularGrade$Test$.MODULE$.fromProduct(product);
        }

        public static Test unapply(Test test) {
            return RegularGrade$Test$.MODULE$.unapply(test);
        }

        public static Option<String> $lessinit$greater$default$4() {
            return RegularGrade$Test$.MODULE$.$lessinit$greater$default$4();
        }

        public Test(String name, float score, int weight, Option<String> details) {
            this.name = name;
            this.score = score;
            this.weight = weight;
            this.details = details;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)Statics.floatHash((float)this.score()));
            n = Statics.mix((int)n, (int)this.weight());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.details()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Test)) return false;
            Test test = (Test)object;
            if (this.score() != test.score()) return false;
            if (this.weight() != test.weight()) return false;
            String string = this.name();
            String string2 = test.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Option<String> option = this.details();
            Option<String> option2 = test.details();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!test.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Test;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "Test";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToFloat((float)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "name";
                }
                case 1: {
                    return "score";
                }
                case 2: {
                    return "weight";
                }
                case 3: {
                    return "details";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String name() {
            return this.name;
        }

        public float score() {
            return this.score;
        }

        public int weight() {
            return this.weight;
        }

        public Option<String> details() {
            return this.details;
        }

        public JsonObject toJson() {
            JsonObject j = new JsonObject();
            j.add("name", (Object)this.name());
            j.add("score", (Object)BoxesRunTime.boxToFloat((float)this.score()));
            j.add("weight", (Object)BoxesRunTime.boxToInteger((int)this.weight()));
            return j.add("details", this.details());
        }

        public Test copy(String name, float score, int weight, Option<String> details) {
            return new Test(name, score, weight, details);
        }

        public String copy$default$1() {
            return this.name();
        }

        public float copy$default$2() {
            return this.score();
        }

        public int copy$default$3() {
            return this.weight();
        }

        public Option<String> copy$default$4() {
            return this.details();
        }

        public String _1() {
            return this.name();
        }

        public float _2() {
            return this.score();
        }

        public int _3() {
            return this.weight();
        }

        public Option<String> _4() {
            return this.details();
        }
    }
}

