/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.domain;

import java.io.Serializable;
import org.beangle.commons.collection.Collections$;
import org.openurp.base.edu.model.Course;
import org.openurp.base.std.model.Student;
import org.openurp.code.edu.model.CourseType;
import org.openurp.edu.grade.domain.AuditPlanListener;
import org.openurp.edu.grade.domain.AuditTypeMatchPolicy;
import org.openurp.edu.grade.domain.DefaultAuditTypeMatchPolicy$;
import org.openurp.edu.grade.domain.StdGrade;
import org.openurp.edu.grade.model.AuditPlanResult;
import org.openurp.edu.program.model.CourseGroup;
import org.openurp.edu.program.model.CoursePlan;
import org.openurp.edu.program.model.SharePlan;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.Seq;
import scala.collection.mutable.Map;

public class AuditPlanContext {
    private final Student std;
    private final CoursePlan coursePlan;
    private final Option sharePlan;
    private final StdGrade stdGrade;
    private final Seq listeners;
    private AuditPlanResult result;
    private AuditTypeMatchPolicy typeMatchPolicy;
    private final Map params;
    private scala.collection.immutable.Map shareCourses;

    public AuditPlanContext(Student std, CoursePlan coursePlan, Option<SharePlan> sharePlan, StdGrade stdGrade, Seq<AuditPlanListener> listeners) {
        this.std = std;
        this.coursePlan = coursePlan;
        this.sharePlan = sharePlan;
        this.stdGrade = stdGrade;
        this.listeners = listeners;
        this.typeMatchPolicy = DefaultAuditTypeMatchPolicy$.MODULE$;
        this.params = Collections$.MODULE$.newMap();
        this.shareCourses = (scala.collection.immutable.Map)sharePlan.map((Function1 & Serializable)_$2 -> _$2.course2Types()).getOrElse(AuditPlanContext::$init$$$anonfun$2);
    }

    public Student std() {
        return this.std;
    }

    public CoursePlan coursePlan() {
        return this.coursePlan;
    }

    public Option<SharePlan> sharePlan() {
        return this.sharePlan;
    }

    public StdGrade stdGrade() {
        return this.stdGrade;
    }

    public Seq<AuditPlanListener> listeners() {
        return this.listeners;
    }

    public AuditPlanResult result() {
        return this.result;
    }

    public void result_$eq(AuditPlanResult x$1) {
        this.result = x$1;
    }

    public AuditTypeMatchPolicy typeMatchPolicy() {
        return this.typeMatchPolicy;
    }

    public void typeMatchPolicy_$eq(AuditTypeMatchPolicy x$1) {
        this.typeMatchPolicy = x$1;
    }

    public Map<String, Object> params() {
        return this.params;
    }

    public scala.collection.immutable.Map<Course, CourseType> shareCourses() {
        return this.shareCourses;
    }

    public void shareCourses_$eq(scala.collection.immutable.Map<Course, CourseType> x$1) {
        this.shareCourses = x$1;
    }

    public <T> T getParam(String paramName, Class<T> clazz) {
        return (T)this.params().get((Object)paramName).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Option<CourseGroup> getGroup(Course course, CourseType suggestType) {
        Option<CourseGroup> option = this.coursePlan().getGroup(course);
        if (option instanceof Some) {
            CourseGroup g = (CourseGroup)((Some)option).value();
            return Some$.MODULE$.apply((Object)g);
        }
        if (None$.MODULE$.equals(option)) {
            Option<CourseGroup> option2 = this.getGroupByType((Option<CourseType>)Some$.MODULE$.apply((Object)suggestType));
            if (option2 instanceof Some) {
                CourseGroup g = (CourseGroup)((Some)option2).value();
                return Some$.MODULE$.apply((Object)g);
            }
            if (None$.MODULE$.equals(option2)) {
                Option<CourseGroup> option3 = this.getGroupBySharePlan(course);
                if (None$.MODULE$.equals(option3)) {
                    return this.getGroupByType((Option<CourseType>)course.courseType());
                }
                if (option3 instanceof Some) {
                    CourseGroup g = (CourseGroup)((Some)option3).value();
                    return Some$.MODULE$.apply((Object)g);
                }
                throw new MatchError(option3);
            }
            throw new MatchError(option2);
        }
        throw new MatchError(option);
    }

    private Option<CourseGroup> getGroupByType(Option<CourseType> suggestType) {
        Option option;
        block4: {
            Option<CourseGroup> option2;
            while (true) {
                if (None$.MODULE$.equals(option = suggestType)) {
                    return None$.MODULE$;
                }
                if (!(option instanceof Some)) break block4;
                CourseType ct = (CourseType)((Some)option).value();
                option2 = this.coursePlan().getGroup(ct.name());
                if (option2 instanceof Some) {
                    CourseGroup g = (CourseGroup)((Some)option2).value();
                    if (this.typeMatchPolicy().allowMatchType(g)) {
                        return Some$.MODULE$.apply((Object)g);
                    }
                    suggestType = ct.parent();
                    continue;
                }
                if (!None$.MODULE$.equals(option2)) break;
                suggestType = ct.parent();
            }
            throw new MatchError(option2);
        }
        throw new MatchError(option);
    }

    private Option<CourseGroup> getGroupBySharePlan(Course course) {
        Option option = this.shareCourses().get((Object)course);
        if (option instanceof Some) {
            CourseType ct = (CourseType)((Some)option).value();
            return this.coursePlan().getGroup(ct.name());
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    private static final scala.collection.immutable.Map $init$$$anonfun$2() {
        return Predef$.MODULE$.Map().empty();
    }
}

