/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.app.util;

import java.security.Key;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class AesEncryptor {
    static String defaultSecretKey = "changeit";
    static String ALGORITHM = "AES";
    private Key secretKeySpec;

    public static void main(String[] args) throws Exception {
        if (args.length == 1 || args.length == 2) {
            String secretKey = args.length == 2 ? args[1] : null;
            System.out.println(args[0] + ":" + new AesEncryptor(secretKey).decrypt(args[0]));
        } else {
            System.out.println("USAGE: java AesEncryptor string-to-encrypt [secretKey]");
        }
    }

    public AesEncryptor(String initKey) {
        this.secretKeySpec = this.generateKey(initKey);
    }

    private Key generateKey(String keyStr) {
        try {
            String secretKey = keyStr == null ? defaultSecretKey : keyStr;
            byte[] key = secretKey.getBytes("UTF-8");
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            key = sha.digest(key);
            key = Arrays.copyOf(key, 16);
            return new SecretKeySpec(key, ALGORITHM);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String encrypt(String plain) throws Exception {
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(1, this.secretKeySpec);
        return this.asHexString(cipher.doFinal(plain.getBytes("UTF-8")));
    }

    public String decrypt(String encrypted) throws Exception {
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, this.secretKeySpec);
        return new String(cipher.doFinal(this.toByteArray(encrypted)));
    }

    private byte[] toByteArray(String hexString) {
        int arrLength = hexString.length() >> 1;
        byte[] buf = new byte[arrLength];
        for (int ii = 0; ii < arrLength; ++ii) {
            int index = ii << 1;
            String l_digit = hexString.substring(index, index + 2);
            buf[ii] = (byte)Integer.parseInt(l_digit, 16);
        }
        return buf;
    }

    private String asHexString(byte[] buf) {
        StringBuilder strbuf = new StringBuilder(buf.length * 2);
        for (int i = 0; i < buf.length; ++i) {
            if ((buf[i] & 0xFF) < 16) {
                strbuf.append("0");
            }
            strbuf.append(Long.toString(buf[i] & 0xFF, 16));
        }
        return strbuf.toString();
    }
}

