/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.audit.model;

import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.hibernate.annotations.NaturalId;
import org.openurp.base.model.NumberIdTimeObject;
import org.openurp.edu.base.code.model.CourseType;
import org.openurp.edu.base.model.Student;
import org.openurp.edu.grade.audit.model.AuditStat;
import org.openurp.edu.grade.audit.model.GroupAuditResult;

@Entity(name="org.openurp.edu.grade.audit.model.PlanAuditResult")
public class PlanAuditResult
extends NumberIdTimeObject<Long> {
    private static final long serialVersionUID = -3096429906586836701L;
    @NotNull
    @NaturalId
    @ManyToOne(fetch=FetchType.LAZY)
    private Student std;
    @Embedded
    private AuditStat auditStat = new AuditStat();
    @OneToMany(mappedBy="planResult", orphanRemoval=true, cascade={CascadeType.ALL})
    @OrderBy(value="indexno")
    private List<GroupAuditResult> groupResults = CollectUtils.newArrayList();
    private boolean passed;
    private Float gpa;
    @Size(max=500)
    private String remark;
    @Size(max=500)
    private String departOpinion;
    @Size(max=500)
    private String finalOpinion;
    @Size(max=1000)
    private String updates;
    private boolean published = false;
    @Size(max=60)
    private String auditor;
    private boolean partial;

    public PlanAuditResult() {
    }

    public PlanAuditResult(Student student) {
        this.setStd(student);
    }

    public List<GroupAuditResult> getTopGroupResults() {
        List results = CollectUtils.newArrayList();
        for (GroupAuditResult result : this.groupResults) {
            if (null != result.getParent()) continue;
            results.add(result);
        }
        return results;
    }

    public List<GroupAuditResult> getGroupResults() {
        return this.groupResults;
    }

    public void setGroupResults(List<GroupAuditResult> groupAuditResults) {
        this.groupResults = groupAuditResults;
    }

    public AuditStat getAuditStat() {
        return this.auditStat;
    }

    public void setAuditStat(AuditStat auditStat) {
        this.auditStat = auditStat;
    }

    public void addGroupResult(GroupAuditResult rs) {
        rs.setPlanResult(this);
        this.groupResults.add(rs);
    }

    public void removeGroupResult(GroupAuditResult rs) {
        rs.setPlanResult(null);
        this.groupResults.remove((Object)rs);
    }

    public GroupAuditResult getGroupResult(CourseType type) {
        if (null == this.groupResults) {
            return null;
        }
        for (GroupAuditResult groupAuditResult : this.groupResults) {
            GroupAuditResult res = this.getGroupResult(groupAuditResult, type);
            if (null == res) continue;
            return res;
        }
        return null;
    }

    private GroupAuditResult getGroupResult(GroupAuditResult groupResult, CourseType type) {
        if (type.equals((Object)groupResult.getCourseType())) {
            return groupResult;
        }
        for (GroupAuditResult childResult : groupResult.getChildren()) {
            GroupAuditResult res = this.getGroupResult(childResult, type);
            if (null == res) continue;
            return res;
        }
        return null;
    }

    public Student getStd() {
        return this.std;
    }

    public void setStd(Student student) {
        this.std = student;
    }

    public boolean isPassed() {
        return this.passed;
    }

    public void setPassed(boolean passed) {
        this.passed = passed;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public boolean isPartial() {
        return this.partial;
    }

    public void setPartial(boolean partial) {
        this.partial = partial;
    }

    public String getDepartOpinion() {
        return this.departOpinion;
    }

    public void setDepartOpinion(String departOpinion) {
        this.departOpinion = departOpinion;
    }

    public String getFinalOpinion() {
        return this.finalOpinion;
    }

    public void setFinalOpinion(String finalOpinion) {
        this.finalOpinion = finalOpinion;
    }

    public String getUpdates() {
        return this.updates;
    }

    public void setUpdates(String updates) {
        this.updates = updates;
    }

    public boolean isPublished() {
        return this.published;
    }

    public void setPublished(boolean published) {
        this.published = published;
    }

    public Float getGpa() {
        return this.gpa;
    }

    public void setGpa(Float gpa) {
        this.gpa = gpa;
    }

    public String getAuditor() {
        return this.auditor;
    }

    public void setAuditor(String auditor) {
        this.auditor = auditor;
    }
}

