/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.lesson.model;

import java.sql.Date;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.beangle.commons.lang.Objects;
import org.beangle.commons.lang.time.WeekTime;
import org.beangle.commons.lang.time.WeekTimes;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.openurp.edu.base.model.Classroom;
import org.openurp.edu.base.model.Teacher;
import org.openurp.edu.lesson.model.Activity;
import org.openurp.edu.lesson.model.Lesson;

@Entity(name="org.openurp.edu.lesson.model.CourseActivity")
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="eams.teach")
public class CourseActivity
extends LongIdObject
implements Comparable<CourseActivity>,
Activity {
    private static final long serialVersionUID = 2498530728105897805L;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    protected Lesson lesson;
    @Embedded
    protected WeekTime time;
    @ManyToMany
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="eams.teach")
    private Set<Teacher> teachers = CollectUtils.newHashSet();
    @ManyToMany
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="eams.teach")
    private Set<Classroom> rooms = CollectUtils.newHashSet();
    @Size(max=500)
    private String remark;

    public CourseActivity() {
    }

    public Date getFirstActivityTime() {
        if (null != this.time) {
            return this.time.getFirstDay();
        }
        return null;
    }

    public CourseActivity(Teacher teacher, Classroom room, WeekTime time) {
        if (teacher != null) {
            this.getTeachers().add(teacher);
        }
        this.getRooms().add(room);
        this.setTime(new WeekTime(time));
    }

    public Object clone() {
        CourseActivity activity = new CourseActivity();
        activity.getRooms().addAll(this.getRooms());
        activity.setTime(new WeekTime(this.getTime()));
        activity.setLesson(this.lesson);
        activity.getTeachers().addAll(this.getTeachers());
        return activity;
    }

    public boolean canMergerWith(CourseActivity activity) {
        if (!this.getTeachers().equals(activity.getTeachers())) {
            return false;
        }
        if (!this.getRooms().equals(activity.getRooms())) {
            return false;
        }
        if (this.getRemark() != null && activity.getRemark() != null && !this.getRemark().equals(activity.getRemark()) || this.getRemark() == null && activity.getRemark() != null || activity.getRemark() == null && this.getRemark() != null) {
            return false;
        }
        return WeekTimes.canMergerWith(this.getTime(), activity.getTime());
    }

    public void mergeWith(CourseActivity other) {
        WeekTimes.mergeWith(this.getTime(), other.getTime());
    }

    public static List<CourseActivity> mergeActivites(List<CourseActivity> tobeMerged) {
        List mergedActivityList = CollectUtils.newArrayList();
        if (CollectUtils.isEmpty(tobeMerged)) {
            return mergedActivityList;
        }
        Collections.sort(tobeMerged);
        Iterator<CourseActivity> activityIter = tobeMerged.iterator();
        CourseActivity toMerged = activityIter.next();
        mergedActivityList.add(toMerged);
        while (activityIter.hasNext()) {
            CourseActivity activity = activityIter.next();
            if (toMerged.canMergerWith(activity)) {
                toMerged.mergeWith(activity);
                continue;
            }
            toMerged = activity;
            mergedActivityList.add(toMerged);
        }
        return mergedActivityList;
    }

    @Override
    public int compareTo(CourseActivity activity) {
        int rs = 0;
        if (rs == 0) {
            rs = this.getTeachers().size() - activity.getTeachers().size();
        }
        if (rs == 0) {
            rs = this.getRooms().size() - activity.getRooms().size();
        }
        if (rs == 0) {
            rs = this.getTime().getWeekstate().compareTo(activity.getTime().getWeekstate());
        }
        if (rs == 0) {
            rs = this.getTime().getStartOn().compareTo(activity.getTime().getStartOn());
        }
        if (rs == 0) {
            rs = this.getTime().getBeginAt().value - activity.getTime().getBeginAt().value;
        }
        return rs;
    }

    public String toString() {
        return Objects.toStringBuilder((Object)this).add("rooms", this.getRooms()).add("time", (Object)this.getTime()).add("teachers", this.getTeachers()).add("id", (Object)this.id).toString();
    }

    public Lesson getLesson() {
        return this.lesson;
    }

    public void setLesson(Lesson lesson) {
        this.lesson = lesson;
    }

    public Set<Teacher> getTeachers() {
        return this.teachers;
    }

    public void setTeachers(Set<Teacher> teachers) {
        this.teachers = teachers;
    }

    public Set<Classroom> getRooms() {
        return this.rooms;
    }

    public void setRooms(Set<Classroom> rooms) {
        this.rooms = rooms;
    }

    public WeekTime getTime() {
        return this.time;
    }

    public void setTime(WeekTime time) {
        this.time = time;
    }

    @Override
    public java.util.Date getBeginAt() {
        if (null != this.time) {
            return this.time.getFirstDay();
        }
        return null;
    }

    @Override
    public java.util.Date getEndAt() {
        return null;
    }

    @Override
    public boolean contains(java.util.Date oneDay) {
        return false;
    }

    @Override
    public String getContent() {
        return this.lesson.getNo();
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}

