/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.lesson.model;

import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.openurp.edu.lesson.model.CourseLimitGroup;
import org.openurp.edu.lesson.model.CourseLimitMeta;

@Entity(name="org.openurp.edu.lesson.model.CourseLimitItem")
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="eams.teach")
public class CourseLimitItem
extends LongIdObject
implements Cloneable {
    private static final long serialVersionUID = -6697398004696236934L;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private CourseLimitMeta meta;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private CourseLimitGroup group;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private CourseLimitMeta.Operator operator;
    @NotNull
    private String content;

    public CourseLimitItem() {
    }

    public CourseLimitItem(CourseLimitMeta meta, CourseLimitMeta.Operator operator, String content) {
        this.meta = meta;
        this.operator = operator;
        this.content = content;
    }

    public CourseLimitMeta getMeta() {
        return this.meta;
    }

    public void setMeta(CourseLimitMeta meta) {
        this.meta = meta;
    }

    public CourseLimitMeta.Operator getOperator() {
        return this.operator;
    }

    public void setOperator(CourseLimitMeta.Operator operator) {
        this.operator = operator;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public CourseLimitGroup getGroup() {
        return this.group;
    }

    public void setGroup(CourseLimitGroup group) {
        this.group = group;
    }

    public Object clone() {
        try {
            CourseLimitItem clone = (CourseLimitItem)super.clone();
            CourseLimitMeta meta = new CourseLimitMeta();
            meta.setId((Long)this.getMeta().getId());
            clone.setMeta(meta);
            clone.setId(null);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public String getContentForHql() {
        if (null != this.content && null != this.meta && "GRADE".equals(this.meta.getName())) {
            this.content = "'" + this.content + "'";
        }
        return this.content;
    }

    public String toString() {
        return this.content;
    }
}

