/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.lesson.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.Component;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;
import org.openurp.base.model.Department;
import org.openurp.edu.base.code.model.CourseAbilityRate;
import org.openurp.edu.base.code.model.ExamType;
import org.openurp.edu.base.model.Student;
import org.openurp.edu.lesson.model.CourseLimitGroup;
import org.openurp.edu.lesson.model.CourseTaker;
import org.openurp.edu.lesson.model.ExamTaker;
import org.openurp.edu.lesson.model.Lesson;
import org.openurp.edu.lesson.util.GenderRatio;

@Embeddable
public class Teachclass
implements Component,
Cloneable,
Serializable {
    private static final long serialVersionUID = 895173901324223302L;
    @NotNull
    @Size(max=4000)
    @Column(name="class_name")
    private String name;
    private String grade;
    @NotNull
    @Type(type="org.beangle.data.jpa.hibernate.udt.GenderRatioType")
    private GenderRatio genderRatio = GenderRatio.empty;
    @ManyToOne(fetch=FetchType.LAZY)
    private Department depart;
    @NotNull
    private int stdCount;
    private int limitCount;
    private boolean limitLocked;
    private int reservedCount;
    @OneToMany(mappedBy="lesson", cascade={CascadeType.ALL})
    private Set<CourseTaker> courseTakers = new HashSet<CourseTaker>();
    @ManyToMany
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="eams.teach")
    private List<CourseAbilityRate> abilityRates = new ArrayList<CourseAbilityRate>();
    @OneToMany(mappedBy="lesson", cascade={CascadeType.ALL})
    private Set<ExamTaker> examTakers = new HashSet<ExamTaker>();
    @OneToMany(mappedBy="lesson", orphanRemoval=true, cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="eams.teach")
    @OrderBy(value="id")
    private List<CourseLimitGroup> limitGroups = CollectUtils.newArrayList();

    public List<ExamTaker> getExamTakers(ExamType examType) {
        if (CollectUtils.isEmpty(this.getExamTakers())) {
            return Collections.emptyList();
        }
        List rs = CollectUtils.newArrayList();
        for (ExamTaker taker : this.getExamTakers()) {
            if (!examType.equals((Object)taker.getExamType())) continue;
            rs.add(taker);
        }
        return rs;
    }

    public int calcExamCount(ExamType examType) {
        return this.getExamTakers(examType).size();
    }

    public Teachclass clone() {
        try {
            Teachclass clone = (Teachclass)super.clone();
            clone.setLimitGroups(new ArrayList<CourseLimitGroup>());
            for (CourseLimitGroup group : this.getLimitGroups()) {
                CourseLimitGroup clone_group = (CourseLimitGroup)group.clone();
                clone.getLimitGroups().add(clone_group);
            }
            clone.setCourseTakers(new HashSet<CourseTaker>());
            for (CourseTaker taker : this.getCourseTakers()) {
                CourseTaker clone_taker = (CourseTaker)taker.clone();
                clone.getCourseTakers().add(clone_taker);
            }
            clone.setAbilityRates(new ArrayList<CourseAbilityRate>(this.getAbilityRates()));
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public CourseTaker getCourseTaker(Long stdId) {
        for (CourseTaker taker : this.getCourseTakers()) {
            if (!((Long)taker.getStd().getId()).equals(stdId)) continue;
            return taker;
        }
        return null;
    }

    public Set<CourseTaker> getNormalCourseTakers() {
        Set normalTakers = CollectUtils.newHashSet();
        if (CollectUtils.isNotEmpty(this.courseTakers)) {
            for (CourseTaker courseTaker : this.courseTakers) {
                if (courseTaker.isFreeListening()) continue;
                normalTakers.add(courseTaker);
            }
        }
        return normalTakers;
    }

    public void addLimitGroups(Lesson lesson, List<CourseLimitGroup> groups) {
        for (CourseLimitGroup group : groups) {
            group.setLesson(lesson);
            this.limitGroups.add(group);
        }
    }

    public void addLimitGroups(Lesson lesson, CourseLimitGroup ... groups) {
        for (CourseLimitGroup group : groups) {
            group.setLesson(lesson);
            this.limitGroups.add(group);
        }
    }

    public CourseLimitGroup getOrCreateDefaultLimitGroup() {
        for (CourseLimitGroup limitGroup : this.limitGroups) {
            if (!limitGroup.isForClass()) continue;
            return limitGroup;
        }
        CourseLimitGroup forClassGroup = new CourseLimitGroup();
        forClassGroup.setForClass(true);
        this.getLimitGroups().add(forClassGroup);
        return forClassGroup;
    }

    public CourseTaker getCourseTaker(Student std) {
        return this.getCourseTaker((Long)std.getId());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getStdCount() {
        return this.stdCount;
    }

    public void setStdCount(int stdCount) {
        this.stdCount = stdCount;
    }

    public Set<CourseTaker> getCourseTakers() {
        return this.courseTakers;
    }

    public void setCourseTakers(Set<CourseTaker> courseTakers) {
        this.courseTakers = courseTakers;
    }

    public int getLimitCount() {
        return this.limitCount;
    }

    public void setLimitCount(int limitCount) {
        this.limitCount = limitCount;
    }

    public String getGrade() {
        return this.grade;
    }

    public void setGrade(String year) {
        this.grade = year;
    }

    public Department getDepart() {
        return this.depart;
    }

    public void setDepart(Department depart) {
        this.depart = depart;
    }

    public Set<ExamTaker> getExamTakers() {
        return this.examTakers;
    }

    public void setExamTakers(Set<ExamTaker> examTakers) {
        this.examTakers = examTakers;
    }

    public boolean isLimitLocked() {
        return this.limitLocked;
    }

    public void setLimitLocked(boolean limitLocked) {
        this.limitLocked = limitLocked;
    }

    public List<CourseLimitGroup> getLimitGroups() {
        return this.limitGroups;
    }

    public void setLimitGroups(List<CourseLimitGroup> limitGroups) {
        this.limitGroups = limitGroups;
    }

    public int getReservedCount() {
        return this.reservedCount;
    }

    public void setReservedCount(int reservedCount) {
        this.reservedCount = reservedCount;
    }

    public GenderRatio getGenderRatio() {
        return this.genderRatio;
    }

    public void setGenderRatio(GenderRatio genderRatio) {
        this.genderRatio = genderRatio;
    }

    public List<CourseAbilityRate> getAbilityRates() {
        return this.abilityRates;
    }

    public void setAbilityRates(List<CourseAbilityRate> abilityRates) {
        this.abilityRates = abilityRates;
    }
}

