/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.base.model;

import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.openurp.base.model.AbstractBaseInfo;
import org.openurp.base.model.Building;
import org.openurp.base.model.Campus;
import org.openurp.base.model.Department;
import org.openurp.base.model.School;
import org.openurp.code.asset.model.RoomType;

@Entity(name="org.openurp.base.model.Room")
@Cacheable
@Cache(region="eams.base", usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class Room
extends AbstractBaseInfo {
    private static final long serialVersionUID = 3229044942979160250L;
    @NotNull
    private int capacity;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Campus campus;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private School school;
    @ManyToOne(fetch=FetchType.LAZY)
    private Building building;
    @ManyToOne(fetch=FetchType.LAZY)
    private RoomType roomType;
    @ManyToOne(fetch=FetchType.LAZY)
    private Department department;
    private int floor;

    public School getSchool() {
        return this.school;
    }

    public void setSchool(School school2) {
        this.school = school2;
    }

    public Room() {
    }

    public Room(Integer id) {
        super(id);
    }

    public Room(String code) {
        super(Integer.valueOf(code));
        this.setCode(code);
    }

    public Room(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    public Building getBuilding() {
        return this.building;
    }

    public void setBuilding(Building building) {
        this.building = building;
    }

    public int getFloor() {
        return this.floor;
    }

    public void setFloor(int floor) {
        this.floor = floor;
    }

    public Campus getCampus() {
        return this.campus;
    }

    public void setCampus(Campus campus) {
        this.campus = campus;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public RoomType getRoomType() {
        return this.roomType;
    }

    public void setRoomType(RoomType type) {
        this.roomType = type;
    }

    public Department getDepartment() {
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }
}

