/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.base.time;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.lang.Numbers;
import org.beangle.commons.lang.Strings;

public class Terms
implements Serializable,
Comparable<Terms> {
    private static final long serialVersionUID = -8846980902784025935L;
    public static final Terms Empty = new Terms(0);
    public final int value;

    private static int valuesOf(String terms) {
        if (terms.equals("*") || terms.equals("")) {
            return 0;
        }
        int result = 0;
        for (String t : Strings.split((String)terms, (String)",")) {
            result |= 1 << Numbers.toInt((String)t);
        }
        return result;
    }

    public Terms(int value) {
        this.value = value;
    }

    public Terms(String values) {
        this(Terms.valuesOf(values));
    }

    public boolean contains(int term) {
        return (this.value & 1 << term) > 0;
    }

    public List<Integer> getTermList() {
        String str = Integer.toBinaryString(this.value);
        List termList = CollectUtils.newArrayList();
        if (this.value > 0) {
            for (int i = str.length() - 1; i >= 0; --i) {
                if (str.charAt(i) != '1') continue;
                termList.add(str.length() - i - 1);
            }
            return termList;
        }
        return Collections.emptyList();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        List<Integer> terms = this.getTermList();
        for (Integer a : terms) {
            sb.append(a).append(',');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    public int compareTo(Terms o) {
        return this.value - o.value;
    }

    public boolean equals(Object obj) {
        return ((Terms)obj).value == this.value;
    }

    public int hashCode() {
        return this.value;
    }
}

