/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.code.geo.model;

import java.util.Collection;
import java.util.List;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.pojo.Code;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.openurp.code.nation;

@Entity(name="org.openurp.code.geo.model.Division")
@Cacheable
@Cache(region="eams.base", usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@nation
public class Division
extends Code<Integer> {
    private static final long serialVersionUID = -8303016071363886718L;
    @OneToMany(mappedBy="parent")
    private List<Division> children = CollectUtils.newArrayList();
    @ManyToOne(fetch=FetchType.LAZY)
    private Division parent;

    public Division() {
    }

    public Division(Integer id) {
        super((Number)id);
    }

    public Division getParent() {
        return this.parent;
    }

    public Division getTop() {
        Division belongDivision;
        for (belongDivision = this; null != belongDivision && null != belongDivision.getParent(); belongDivision = belongDivision.getParent()) {
        }
        return belongDivision;
    }

    public void setParent(Division superDivision) {
        this.parent = superDivision;
    }

    public boolean hasSubDivision() {
        return this.children.isEmpty();
    }

    public List<Division> getChildren() {
        return this.children;
    }

    public void setChildren(List<Division> subDivisions) {
        this.children = subDivisions;
    }

    public boolean addSubDivision(Division subDivision) {
        return this.children.add(subDivision);
    }

    public boolean removeSubDivision(Division subDivision) {
        return this.children.remove((Object)subDivision);
    }

    public boolean addSubDivisions(Collection<? extends Division> subDivisions) {
        return this.children.addAll(subDivisions);
    }

    public boolean removeSubDivisions(Collection<? extends Division> subDivisions) {
        return this.children.removeAll(subDivisions);
    }

    public void clearSubDivisions() {
        this.children.clear();
    }
}

