/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade.course.model;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.NaturalId;
import org.openurp.base.model.NumberIdTimeObject;
import org.openurp.edu.base.code.model.ExamStatus;
import org.openurp.edu.base.code.model.GradeType;
import org.openurp.edu.base.code.model.ScoreMarkStyle;
import org.openurp.edu.base.model.Student;
import org.openurp.edu.grade.Grade;
import org.openurp.edu.grade.course.model.CourseGrade;

@Entity(name="org.openurp.edu.grade.course.model.ExamGrade")
public class ExamGrade
extends NumberIdTimeObject<Long>
implements Grade {
    private static final long serialVersionUID = 3737090012804400743L;
    @NaturalId
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private GradeType gradeType;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private ScoreMarkStyle markStyle;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private ExamStatus examStatus;
    private Float score;
    private String scoreText;
    @NaturalId
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private CourseGrade courseGrade;
    protected int status;
    private boolean passed;
    @Size(max=50)
    private String operator;
    private Short percent;

    public ExamGrade() {
    }

    public ExamGrade(GradeType gradeType, Float score) {
        this.gradeType = gradeType;
        this.score = score;
    }

    public ExamGrade(GradeType gradeType, ExamStatus examStatus, Float score) {
        this.gradeType = gradeType;
        this.examStatus = examStatus;
        this.score = score;
    }

    public CourseGrade getCourseGrade() {
        return this.courseGrade;
    }

    public void setCourseGrade(CourseGrade courseGrade) {
        this.courseGrade = courseGrade;
    }

    public GradeType getGradeType() {
        return this.gradeType;
    }

    public void setGradeType(GradeType gradeType) {
        this.gradeType = gradeType;
    }

    @Override
    public Float getScore() {
        return this.score;
    }

    @Override
    public void setScore(Float score) {
        this.score = score;
    }

    @Override
    public String getScoreText() {
        return this.scoreText;
    }

    @Override
    public void setScoreText(String scoreText) {
        this.scoreText = scoreText;
    }

    @Override
    public boolean isPublished() {
        return this.getStatus() == 2;
    }

    @Override
    public boolean isConfirmed() {
        return this.getStatus() >= 1;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public int compareTo(Grade grade) {
        if (null == this.getScore()) {
            return 1;
        }
        if (null == grade.getScore()) {
            return -1;
        }
        return grade.getScore().compareTo(this.getScore());
    }

    @Override
    public boolean isPassed() {
        return this.passed;
    }

    @Override
    public void setPassed(boolean isPass) {
        this.passed = isPass;
    }

    public ExamStatus getExamStatus() {
        return this.examStatus;
    }

    public void setExamStatus(ExamStatus examStatus) {
        this.examStatus = examStatus;
    }

    @Override
    public ScoreMarkStyle getMarkStyle() {
        return this.markStyle;
    }

    @Override
    public void setMarkStyle(ScoreMarkStyle markStyle) {
        this.markStyle = markStyle;
    }

    @Override
    public String getOperator() {
        return this.operator;
    }

    @Override
    public void setOperator(String operator) {
        this.operator = operator;
    }

    public Short getPercent() {
        return this.percent;
    }

    public void setPercent(Short percent) {
        this.percent = percent;
    }

    @Override
    public Student getStd() {
        return null == this.courseGrade ? null : this.courseGrade.getStd();
    }
}

