/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.lesson.model;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.validation.constraints.NotNull;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.openurp.edu.lesson.model.CourseLimitItem;
import org.openurp.edu.lesson.model.Lesson;

@Entity(name="org.openurp.edu.lesson.model.CourseLimitGroup")
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="eams.teach")
public class CourseLimitGroup
extends LongIdObject
implements Cloneable {
    private static final long serialVersionUID = -6284931594985772061L;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Lesson lesson;
    @OneToMany(mappedBy="group", orphanRemoval=true, cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="eams.teach")
    private List<CourseLimitItem> items = CollectUtils.newArrayList();
    @NotNull
    private int maxCount;
    @NotNull
    private int curCount;
    private boolean forClass = true;

    public List<CourseLimitItem> getItems() {
        return this.items;
    }

    public void setItems(List<CourseLimitItem> items) {
        this.items = items;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public int getCurCount() {
        return this.curCount;
    }

    public void setCurCount(int curCount) {
        this.curCount = curCount;
    }

    public Lesson getLesson() {
        return this.lesson;
    }

    public void setLesson(Lesson lesson) {
        this.lesson = lesson;
    }

    public Object clone() {
        try {
            CourseLimitGroup clone = (CourseLimitGroup)super.clone();
            clone.setId(null);
            clone.setLesson(null);
            clone.setItems(new ArrayList<CourseLimitItem>());
            for (CourseLimitItem item : this.getItems()) {
                CourseLimitItem clone_item = (CourseLimitItem)item.clone();
                clone_item.setGroup(clone);
                clone.getItems().add(clone_item);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public boolean isForClass() {
        return this.forClass;
    }

    public void setForClass(boolean forClass) {
        this.forClass = forClass;
    }
}

