/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.lesson.model;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.metadata.Model;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Target;
import org.openurp.base.model.Campus;
import org.openurp.base.model.Department;
import org.openurp.base.model.Semester;
import org.openurp.edu.base.code.model.CourseType;
import org.openurp.edu.base.code.model.TeachLangType;
import org.openurp.edu.base.model.AuditState;
import org.openurp.edu.base.model.Course;
import org.openurp.edu.base.model.ProjectBasedObject;
import org.openurp.edu.base.model.Teacher;
import org.openurp.edu.lesson.code.model.LessonTag;
import org.openurp.edu.lesson.model.CourseActivity;
import org.openurp.edu.lesson.model.CourseLimitGroup;
import org.openurp.edu.lesson.model.CourseSchedule;
import org.openurp.edu.lesson.model.CourseTaker;
import org.openurp.edu.lesson.model.ExamSchedule;
import org.openurp.edu.lesson.model.ExamTaker;
import org.openurp.edu.lesson.model.LessonGroup;
import org.openurp.edu.lesson.model.Teachclass;

@Entity(name="org.openurp.edu.lesson.model.Lesson")
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"no", "semester_id", "project_id"})})
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="eams.teach")
public class Lesson
extends ProjectBasedObject<Long>
implements Cloneable {
    private static final long serialVersionUID = 1071972497531228225L;
    @Size(max=32)
    private String no;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Course course;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private CourseType courseType;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Department teachDepart;
    @ManyToMany
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="eams.teach")
    @OrderColumn(name="idx", insertable=true, updatable=true, nullable=false)
    private List<Teacher> teachers = new ArrayList<Teacher>();
    @ManyToMany
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="eams.teach")
    private List<LessonTag> tags = new ArrayList<LessonTag>();
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Campus campus;
    @Target(value=Teachclass.class)
    private Teachclass teachclass;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Semester semester;
    private CourseSchedule courseSchedule;
    private ExamSchedule examSchedule;
    @Size(max=500)
    private String remark;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private TeachLangType langType;
    @ManyToOne(fetch=FetchType.LAZY)
    private LessonGroup group;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private AuditState auditStatus = AuditState.UNSUBMITTED;

    public Lesson() {
    }

    public Lesson(Long lessonId) {
        this.id = lessonId;
    }

    public static Lesson getDefault() {
        Lesson task = (Lesson)Model.newInstance(Lesson.class);
        task.setTeachclass(new Teachclass());
        task.setCourseSchedule(new CourseSchedule());
        task.setExamSchedule(new ExamSchedule());
        return task;
    }

    public Date getFirstCourseTime() {
        if (null != this.semester && this.semester.isPersisted()) {
            Date date = null;
            if (null != this.getCourseSchedule().getActivities()) {
                for (CourseActivity courseActivity : this.getCourseSchedule().getActivities()) {
                    Date myDate = courseActivity.getFirstActivityTime();
                    if (date != null && !myDate.before(date)) continue;
                    date = myDate;
                }
            }
            return date;
        }
        return null;
    }

    public Semester getSemester() {
        return this.semester;
    }

    public void setSemester(Semester semester) {
        this.semester = semester;
    }

    public Course getCourse() {
        return this.course;
    }

    public void setCourse(Course course) {
        this.course = course;
    }

    public String getNo() {
        return this.no;
    }

    public void setNo(String no) {
        this.no = no;
    }

    public CourseType getCourseType() {
        return this.courseType;
    }

    public void setCourseType(CourseType courseType) {
        this.courseType = courseType;
    }

    public Teachclass getTeachclass() {
        return this.teachclass;
    }

    public void setTeachclass(Teachclass teachclass) {
        this.teachclass = teachclass;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String toString() {
        return " [id:" + this.getId() + "]  " + this.getCourse().getName() + " " + this.getTeachclass().getName();
    }

    public CourseSchedule getCourseSchedule() {
        return this.courseSchedule;
    }

    public void setCourseSchedule(CourseSchedule courseSchedule) {
        this.courseSchedule = courseSchedule;
    }

    public List<Teacher> getTeachers() {
        return this.teachers;
    }

    public void setTeachers(List<Teacher> teachers) {
        this.teachers = teachers;
    }

    public ExamSchedule getExamSchedule() {
        return this.examSchedule;
    }

    public void setExamSchedule(ExamSchedule examSchedule) {
        this.examSchedule = examSchedule;
    }

    public Campus getCampus() {
        return this.campus;
    }

    public void setCampus(Campus campus) {
        this.campus = campus;
    }

    public String getTeacherNames() {
        if (null != this.getTeachers() && !this.getTeachers().isEmpty()) {
            StringBuffer buf = new StringBuffer(10);
            for (Teacher teacher : this.getTeachers()) {
                buf.append(teacher.getName()).append(",");
            }
            buf.deleteCharAt(buf.length() - 1);
            return buf.toString();
        }
        return "";
    }

    public String getTeacherNamesWithCode() {
        if (null != this.getTeachers() && !this.getTeachers().isEmpty()) {
            StringBuffer buf = new StringBuffer(10);
            for (Teacher teacher : this.getTeachers()) {
                buf.append(teacher.getName()).append("[").append(teacher.getCode()).append("]").append(",");
            }
            buf.deleteCharAt(buf.length() - 1);
            return buf.toString();
        }
        return "";
    }

    public Department getTeachDepart() {
        return this.teachDepart;
    }

    public void setTeachDepart(Department teachDepart) {
        this.teachDepart = teachDepart;
    }

    public TeachLangType getLangType() {
        return this.langType;
    }

    public void setLangType(TeachLangType langType) {
        this.langType = langType;
    }

    public List<LessonTag> getTags() {
        return this.tags;
    }

    public void setTags(List<LessonTag> tags) {
        this.tags = tags;
    }

    public LessonGroup getGroup() {
        return this.group;
    }

    public void setGroup(LessonGroup group) {
        this.group = group;
    }

    public AuditState getAuditStatus() {
        return this.auditStatus;
    }

    public void setAuditStatus(AuditState auditStatus) {
        this.auditStatus = auditStatus;
    }

    public Lesson clone() {
        try {
            Lesson one = (Lesson)super.clone();
            one.setId(null);
            one.setNo(null);
            one.setGroup(null);
            one.setTags(new ArrayList<LessonTag>());
            one.getTags().addAll(this.getTags());
            one.setTeachers(CollectUtils.newArrayList());
            one.getTeachers().addAll(this.getTeachers());
            one.setCourseSchedule(this.getCourseSchedule().clone());
            one.setExamSchedule(this.getExamSchedule().clone());
            one.setTeachclass(this.getTeachclass().clone());
            for (CourseTaker taker : one.getTeachclass().getCourseTakers()) {
                taker.setLesson(one);
            }
            for (CourseLimitGroup group : one.getTeachclass().getLimitGroups()) {
                group.setLesson(one);
            }
            one.getTeachclass().setExamTakers(new HashSet<ExamTaker>());
            Date createdAt = new Date(System.currentTimeMillis());
            one.setUpdatedAt(createdAt);
            return one;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

