/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.lesson.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.NaturalId;
import org.openurp.edu.base.model.Textbook;
import org.openurp.edu.lesson.model.Lesson;

@Entity(name="org.openurp.edu.lesson.model.LessonMaterial")
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="eams.teach")
public class LessonMaterial
extends LongIdObject {
    private static final long serialVersionUID = 5112094284404799375L;
    @NaturalId
    @ManyToOne(fetch=FetchType.LAZY)
    private Lesson lesson;
    @ManyToMany
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="eams.teach")
    private List<Textbook> books = CollectUtils.newArrayList();
    @Size(max=500)
    private String referenceBooks;
    @Size(max=500)
    private String extra;
    private Boolean passed;
    private Date auditAt;
    @Size(max=200)
    private String remark;
    @Size(max=500)
    private String useExplain;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private LessonMaterialStatus status = LessonMaterialStatus.ASSIGNED;

    public Date getAuditAt() {
        return this.auditAt;
    }

    public void setAuditAt(Date auditAt) {
        this.auditAt = auditAt;
    }

    public String getUseExplain() {
        return this.useExplain;
    }

    public void setUseExplain(String useExplain) {
        this.useExplain = useExplain;
    }

    public Lesson getLesson() {
        return this.lesson;
    }

    public void setLesson(Lesson lesson) {
        this.lesson = lesson;
    }

    public List<Textbook> getBooks() {
        return this.books;
    }

    public boolean addBook(Textbook book) {
        return this.books.add(book);
    }

    public boolean addBooks(Collection<Textbook> textbooks) {
        return this.books.addAll(textbooks);
    }

    public boolean removeBook(Textbook book) {
        return this.books.remove((Object)book);
    }

    public boolean removeBooks(Collection<Textbook> textbooks) {
        return this.books.removeAll(textbooks);
    }

    public void setBooks(List<Textbook> books) {
        this.books = books;
    }

    public String getReferenceBooks() {
        return this.referenceBooks;
    }

    public void setReferenceBooks(String referenceBooks) {
        this.referenceBooks = referenceBooks;
    }

    public String getExtra() {
        return this.extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public Boolean getPassed() {
        return this.passed;
    }

    public void setPassed(Boolean passed) {
        this.passed = passed;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public LessonMaterialStatus getStatus() {
        return this.status;
    }

    public void setStatus(LessonMaterialStatus status) {
        this.status = status;
    }

    public static enum LessonMaterialStatus {
        PUBLISHED("\u6559\u6750\u5df2\u53d1"),
        DONT_ASSIGNED("\u4e0d\u9700\u6559\u6750"),
        ASSIGNED("\u5df2\u6307\u5b9a");

        private String fullName;

        private LessonMaterialStatus() {
        }

        private LessonMaterialStatus(String fullName) {
            this.fullName = fullName;
        }

        public String getFullName() {
            return this.fullName;
        }
    }
}

