/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.subst.model;

import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.openurp.base.model.Department;
import org.openurp.edu.base.code.model.Education;
import org.openurp.edu.base.code.model.StdType;
import org.openurp.edu.base.model.Course;
import org.openurp.edu.base.model.Direction;
import org.openurp.edu.base.model.Major;
import org.openurp.edu.base.model.Project;
import org.openurp.edu.program.subst.model.AbstractCourseSubstitution;

@Entity(name="org.openurp.edu.program.subst.model.MajorCourseSubstitution")
@Table(name="major_course_subs")
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="eams.teach")
public class MajorCourseSubstitution
extends AbstractCourseSubstitution {
    private static final long serialVersionUID = 5820298588618272410L;
    @NotNull
    @Size(max=100)
    private String fromGrade;
    @NotNull
    @Size(max=100)
    private String toGrade;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Education education;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Project project;
    @ManyToOne(fetch=FetchType.LAZY)
    private Department department;
    @ManyToOne(fetch=FetchType.LAZY)
    private StdType stdType;
    @ManyToOne(fetch=FetchType.LAZY)
    private Major major;
    @ManyToOne(fetch=FetchType.LAZY)
    private Direction direction;
    @Size(max=300)
    private String remark;
    @ManyToMany
    @JoinColumn(nullable=false)
    @JoinTable(name="major_course_subs_olds")
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="eams.teach")
    private Set<Course> origins = CollectUtils.newHashSet();
    @ManyToMany
    @JoinColumn(nullable=false)
    @JoinTable(name="major_course_subs_news")
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="eams.teach")
    private Set<Course> substitutes = CollectUtils.newHashSet();

    public String getFromGrade() {
        return this.fromGrade;
    }

    public void setFromGrade(String fromGrade) {
        this.fromGrade = fromGrade;
    }

    public String getToGrade() {
        return this.toGrade;
    }

    public void setToGrade(String toGrade) {
        this.toGrade = toGrade;
    }

    public Major getMajor() {
        return this.major;
    }

    public void setMajor(Major major) {
        this.major = major;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public Education getEducation() {
        return this.education;
    }

    public void setEducation(Education education) {
        this.education = education;
    }

    public StdType getStdType() {
        return this.stdType;
    }

    public void setStdType(StdType stdType) {
        this.stdType = stdType;
    }

    @Override
    public Set<Course> getOrigins() {
        return this.origins;
    }

    @Override
    public void setOrigins(Set<Course> origins) {
        this.origins = origins;
    }

    @Override
    public Set<Course> getSubstitutes() {
        return this.substitutes;
    }

    @Override
    public void setSubstitutes(Set<Course> substitutes) {
        this.substitutes = substitutes;
    }

    public Department getDepartment() {
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }
}

