/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.lang.time;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.beangle.commons.lang.Assert;
import org.beangle.commons.lang.Numbers;

public class HourMinute
implements Serializable,
Comparable<HourMinute> {
    private static final long serialVersionUID = 3782695973214593536L;
    public final short value;
    public static final HourMinute Zero = new HourMinute(0);

    public HourMinute(short value) {
        this.value = value;
    }

    public int getHour() {
        return this.value / 100;
    }

    public int getMinute() {
        return this.value % 100;
    }

    public HourMinute(String str) {
        this(HourMinute.convert(str));
    }

    @Override
    public int compareTo(HourMinute o) {
        return this.value - o.value;
    }

    public int toMinutes() {
        Object time = String.valueOf(this.value);
        if (this.value >= 6000) {
            throw new RuntimeException("Invalid time " + (String)time);
        }
        while (((String)time).length() < 4) {
            time = "0" + (String)time;
        }
        return Numbers.toInt((String)((String)time).substring(0, 2)) * 60 + Numbers.toInt((String)((String)time).substring(2, 4));
    }

    public int interval(HourMinute other) {
        return this.toMinutes() - other.toMinutes();
    }

    public boolean gt(HourMinute other) {
        return this.value > other.value;
    }

    public boolean lt(HourMinute other) {
        return this.value < other.value;
    }

    public boolean le(HourMinute other) {
        return this.value <= other.value;
    }

    public boolean ge(HourMinute other) {
        return this.value >= other.value;
    }

    public String toString() {
        Object time = String.valueOf(this.value);
        if (this.value >= 6000) {
            throw new RuntimeException("Invalid time " + (String)time);
        }
        while (((String)time).length() < 4) {
            time = "0" + (String)time;
        }
        return ((String)time).substring(0, 2) + ":" + ((String)time).substring(2, 4);
    }

    private static short convert(String time) {
        int index = time.indexOf(58);
        Assert.isTrue((index == 2 && time.length() == 5 ? 1 : 0) != 0, (String)"illegal time,it should with 00:00 format", (Object[])new Object[0]);
        Assert.isTrue((Numbers.toInt((String)time.substring(0, index)) < 60 && Numbers.toInt((String)time.substring(index + 1, index + 3)) < 60 ? 1 : 0) != 0, (String)("illegal time " + time + ",it should within 60:60."), (Object[])new Object[0]);
        return (short)Numbers.toInt((String)(time.substring(0, index) + time.substring(index + 1, index + 3)));
    }

    public static HourMinute of(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
        return new HourMinute(sdf.format(date));
    }

    public static HourMinute newHourMinute(String time) {
        int index = time.indexOf(58);
        Assert.isTrue((index == 2 && time.length() == 5 ? 1 : 0) != 0, (String)"illegal time,it should with 00:00 format", (Object[])new Object[0]);
        Assert.isTrue((Numbers.toInt((String)time.substring(0, index)) < 60 && Numbers.toInt((String)time.substring(index + 1, index + 3)) < 60 ? 1 : 0) != 0, (String)("illegal time " + time + ",it should within 60:60."), (Object[])new Object[0]);
        return new HourMinute((short)Numbers.toInt((String)(time.substring(0, index) + time.substring(index + 1, index + 3))));
    }

    public boolean equals(Object obj) {
        return this.value == ((HourMinute)obj).value;
    }

    public short getValue() {
        return this.value;
    }
}

