/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.base.model;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.openurp.base.model.Department;
import org.openurp.base.model.NumberIdTimeObject;
import org.openurp.edu.base.code.model.Education;
import org.openurp.edu.base.model.Direction;
import org.openurp.edu.base.model.MajorJournal;
import org.openurp.edu.base.model.Project;

@Entity(name="org.openurp.edu.base.model.Major")
@Cacheable
@Cache(region="eams.core", usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class Major
extends NumberIdTimeObject<Integer> {
    private static final long serialVersionUID = 7360406731828210066L;
    @Column(unique=true)
    @NotNull
    @Size(max=32)
    protected String code;
    @NotNull
    @Size(max=100)
    protected String name;
    @Size(max=255)
    protected String enName;
    @Size(max=500)
    protected String remark;
    @NotNull
    protected Date beginOn;
    protected Date endOn;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Project project;
    @OneToMany(mappedBy="major", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<Direction> directions = CollectUtils.newHashSet();
    @OneToMany(mappedBy="major", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(region="eams.core", usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    private List<MajorJournal> journals = CollectUtils.newArrayList();
    @Size(max=30)
    private String shortName;

    public Major() {
    }

    public Major(Integer id) {
        super(id);
    }

    public Float getDuration() {
        Iterator<MajorJournal> iterator = this.journals.iterator();
        if (iterator.hasNext()) {
            MajorJournal j = iterator.next();
            return j.getDuration();
        }
        return Float.valueOf(0.0f);
    }

    public Set<Direction> getDirections() {
        return this.directions;
    }

    public void setDirections(Set<Direction> directions) {
        this.directions = directions;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public List<MajorJournal> getJournals() {
        return this.journals;
    }

    public void setJournals(List<MajorJournal> journals) {
        this.journals = journals;
    }

    public List<Education> getEducations() {
        HashSet<Education> educations = new HashSet<Education>();
        for (MajorJournal j : this.journals) {
            educations.add(j.getEducation());
        }
        return new ArrayList<Education>(educations);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEnName() {
        return this.enName;
    }

    public void setEnName(String enName) {
        this.enName = enName;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Date getBeginOn() {
        return this.beginOn;
    }

    public void setBeginOn(Date beginOn) {
        this.beginOn = beginOn;
    }

    public Date getEndOn() {
        return this.endOn;
    }

    public void setEndOn(Date endOn) {
        this.endOn = endOn;
    }

    public Set<Department> getDepartments() {
        Set departs = CollectUtils.newHashSet();
        for (MajorJournal md : this.getJournals()) {
            departs.add(md.getDepart());
        }
        return departs;
    }

    public Set<Department> getValidDepartments() {
        Set departs = CollectUtils.newHashSet();
        java.util.Date now = new java.util.Date();
        for (MajorJournal md : this.getJournals()) {
            if (!now.after(md.getBeginOn()) || (md.getEndOn() == null || !now.before(md.getEndOn())) && md.getEndOn() != null) continue;
            departs.add(md.getDepart());
        }
        return departs;
    }

    public Set<Department> getValidDepartments(java.util.Date time) {
        Set departs = CollectUtils.newHashSet();
        for (MajorJournal md : this.getJournals()) {
            if (!time.after(md.getBeginOn()) || (md.getEndOn() == null || !time.before(md.getEndOn())) && md.getEndOn() != null) continue;
            departs.add(md.getDepart());
        }
        return departs;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }
}

