/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.exam.model;

import java.sql.Date;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.beangle.commons.lang.time.HourMinute;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.Type;
import org.openurp.edu.base.code.model.ExamType;
import org.openurp.edu.base.model.Classroom;
import org.openurp.edu.base.model.Semester;
import org.openurp.edu.base.model.Teacher;
import org.openurp.edu.exam.model.ExamRoom;
import org.openurp.edu.exam.model.ExamStudent;
import org.openurp.edu.exam.model.PublishState;
import org.openurp.edu.lesson.model.Lesson;

@Entity(name="org.openurp.edu.exam.model.ExamActivity")
public class ExamActivity
extends LongIdObject {
    private static final long serialVersionUID = -6748665397101838909L;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @NaturalId
    protected Lesson lesson;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    protected Semester semester;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @NaturalId
    private ExamType examType;
    private Date examOn;
    @Type(type="org.beangle.commons.lang.time.hibernate.HourMinuteType")
    private HourMinute beginAt;
    @Type(type="org.beangle.commons.lang.time.hibernate.HourMinuteType")
    private HourMinute endAt;
    @Size(max=255)
    private String remark;
    private int stdCount;
    @ManyToMany
    private Set<ExamRoom> rooms = CollectUtils.newHashSet();
    @NotNull
    @Enumerated(value=EnumType.ORDINAL)
    private PublishState state = PublishState.None;
    @OneToMany(mappedBy="activity", targetEntity=ExamStudent.class)
    private List<ExamStudent> examStudents = CollectUtils.newArrayList();

    public Semester getSemester() {
        return this.semester;
    }

    public void setSemester(Semester semester) {
        this.semester = semester;
    }

    public Lesson getLesson() {
        return this.lesson;
    }

    public Object clone() {
        ExamActivity activity = new ExamActivity();
        activity.setExamOn(this.getExamOn());
        activity.setBeginAt(this.getBeginAt());
        activity.setEndAt(this.getEndAt());
        activity.setExamType(this.getExamType());
        activity.setLesson(this.getLesson());
        activity.setSemester(this.getSemester());
        activity.setRemark(this.getRemark());
        activity.setState(this.getState());
        for (ExamRoom examRoom : activity.getRooms()) {
            activity.getRooms().add((ExamRoom)((Object)examRoom.clone()));
        }
        return activity;
    }

    public ExamType getExamType() {
        return this.examType;
    }

    public void setExamType(ExamType examType) {
        this.examType = examType;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setLesson(Lesson lesson) {
        this.lesson = lesson;
    }

    public void setExamStudents(List<ExamStudent> examStudents) {
        this.examStudents = examStudents;
    }

    public List<ExamStudent> getExamStudents() {
        return this.examStudents;
    }

    public List<Classroom> getClassrooms() {
        if (null == this.rooms || this.rooms.isEmpty()) {
            return Collections.emptyList();
        }
        List classrooms = CollectUtils.newArrayList();
        for (ExamRoom er : this.getRooms()) {
            classrooms.add(er.getRoom());
        }
        return classrooms;
    }

    public List<Teacher> getExaminers() {
        if (null == this.rooms || this.rooms.isEmpty()) {
            return Collections.emptyList();
        }
        Set teachers = CollectUtils.newHashSet();
        for (ExamRoom er : this.getRooms()) {
            if (null == er.getExaminer()) continue;
            teachers.add(er.getExaminer());
        }
        return CollectUtils.newArrayList((Collection)teachers);
    }

    public PublishState getState() {
        return this.state;
    }

    public void setState(PublishState state) {
        this.state = state;
    }

    public Date getExamOn() {
        return this.examOn;
    }

    public void setExamOn(Date examOn) {
        this.examOn = examOn;
    }

    public HourMinute getBeginAt() {
        return this.beginAt;
    }

    public void setBeginAt(HourMinute beginAt) {
        this.beginAt = beginAt;
    }

    public HourMinute getEndAt() {
        return this.endAt;
    }

    public void setEndAt(HourMinute endAt) {
        this.endAt = endAt;
    }

    public Set<ExamRoom> getRooms() {
        return this.rooms;
    }

    public void setRooms(Set<ExamRoom> rooms) {
        this.rooms = rooms;
    }

    public int getStdCount() {
        return this.stdCount;
    }

    public void setStdCount(int stdCount) {
        this.stdCount = stdCount;
    }
}

