/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.grade;

import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.NaturalId;
import org.openurp.base.model.NumberIdTimeObject;
import org.openurp.edu.base.code.model.ScoreMarkStyle;
import org.openurp.edu.base.model.Project;
import org.openurp.edu.base.model.Semester;
import org.openurp.edu.base.model.Student;
import org.openurp.edu.grade.Grade;

@MappedSuperclass
public abstract class AbstractGrade
extends NumberIdTimeObject<Long>
implements Grade {
    private static final long serialVersionUID = -5413230219080754536L;
    @NaturalId
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    protected Student std;
    @NaturalId
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    protected Semester semester;
    @NaturalId
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Project project;
    protected Float score;
    protected String scoreText;
    protected boolean passed;
    protected int status;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    protected ScoreMarkStyle markStyle;
    @Size(max=50)
    protected String operator;

    @Override
    public int compareTo(Grade grade) {
        if (null == this.getScore()) {
            return 1;
        }
        if (null == grade.getScore()) {
            return -1;
        }
        return grade.getScore().compareTo(this.getScore());
    }

    public Semester getSemester() {
        return this.semester;
    }

    public void setSemester(Semester semester) {
        this.semester = semester;
    }

    @Override
    public boolean isConfirmed() {
        return (this.getStatus() & 1) > 0;
    }

    @Override
    public boolean isPassed() {
        return this.passed;
    }

    @Override
    public boolean isPublished() {
        return (this.getStatus() & 2) > 0;
    }

    @Override
    public ScoreMarkStyle getMarkStyle() {
        return this.markStyle;
    }

    @Override
    public Float getScore() {
        return this.score;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public Student getStd() {
        return this.std;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    @Override
    public void setPassed(boolean passed) {
        this.passed = passed;
    }

    @Override
    public void setMarkStyle(ScoreMarkStyle markStyle) {
        this.markStyle = markStyle;
    }

    @Override
    public void setScore(Float score) {
        this.score = score;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    public void setStd(Student std) {
        this.std = std;
    }

    @Override
    public String getScoreText() {
        return this.scoreText;
    }

    @Override
    public void setScoreText(String scoreText) {
        this.scoreText = scoreText;
    }

    @Override
    public String getOperator() {
        return this.operator;
    }

    @Override
    public void setOperator(String operator) {
        this.operator = operator;
    }
}

