/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.plan.model;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.validation.constraints.NotNull;
import org.beangle.commons.collection.CollectUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.openurp.edu.base.model.Program;
import org.openurp.edu.program.plan.model.AbstractCoursePlan;
import org.openurp.edu.program.plan.model.CourseGroup;
import org.openurp.edu.program.plan.model.MajorCourseGroup;
import org.openurp.edu.program.plan.model.MajorPlanComment;

@Entity(name="org.openurp.edu.program.plan.model.MajorPlan")
@Cacheable
@Cache(region="eams.teach", usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class MajorPlan
extends AbstractCoursePlan {
    private static final long serialVersionUID = 7084539759992691314L;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    protected Program program;
    @OneToMany(orphanRemoval=true, targetEntity=MajorCourseGroup.class, cascade={CascadeType.ALL})
    @JoinColumn(name="plan_id", nullable=false)
    @OrderBy(value="indexno")
    @Cache(region="eams.teach", usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    private List<CourseGroup> groups = CollectUtils.newArrayList();
    @OneToMany(mappedBy="majorPlan", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<MajorPlanComment> comments = CollectUtils.newArrayList();
    @NotNull
    private Date beginOn;
    private Date endOn;

    @Override
    public List<CourseGroup> getGroups() {
        return this.groups;
    }

    @Override
    public void setGroups(List<CourseGroup> groups) {
        this.groups = groups;
    }

    public Object clone() throws CloneNotSupportedException {
        MajorPlan copy = (MajorPlan)super.clone();
        copy.setGroups(new ArrayList<CourseGroup>());
        copy.setId(null);
        return copy;
    }

    public Program getProgram() {
        return this.program;
    }

    public void setProgram(Program program) {
        this.program = program;
    }

    @Override
    public Date getBeginOn() {
        return this.beginOn;
    }

    public void setBeginOn(Date beginOn) {
        this.beginOn = beginOn;
    }

    @Override
    public Date getEndOn() {
        return this.endOn;
    }

    public void setEndOn(Date endOn) {
        this.endOn = endOn;
    }

    public List<MajorPlanComment> getComments() {
        return this.comments;
    }

    public void setComments(List<MajorPlanComment> comments) {
        this.comments = comments;
    }

    public String toString() {
        return "MajorPlanBean [program=" + this.program + ", startTerm=" + this.getStartTerm() + ", endTerm=" + this.getEndTerm() + "]";
    }
}

