/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.lang.time;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.beangle.commons.entity.pojo.NumberIdObject;

public class WeekDay
extends NumberIdObject<Integer>
implements Comparable<WeekDay> {
    private static final long serialVersionUID = -7003967188245072343L;
    private String name;
    private String enName;
    public static final WeekDay Mon = new WeekDay(new Integer(1), "\u661f\u671f\u4e00", "Mon");
    public static final WeekDay Tue = new WeekDay(new Integer(2), "\u661f\u671f\u4e8c", "Tue");
    public static final WeekDay Wed = new WeekDay(new Integer(3), "\u661f\u671f\u4e09", "Wed");
    public static final WeekDay Thu = new WeekDay(new Integer(4), "\u661f\u671f\u56db", "Thu");
    public static final WeekDay Fri = new WeekDay(new Integer(5), "\u661f\u671f\u4e94", "Fri");
    public static final WeekDay Sat = new WeekDay(new Integer(6), "\u661f\u671f\u516d", "Sat");
    public static final WeekDay Sun = new WeekDay(new Integer(7), "\u661f\u671f\u65e5", "Sun");
    public static WeekDay[] All = new WeekDay[]{Mon, Tue, Wed, Thu, Fri, Sat, Sun};
    public static WeekDay[] All_SUNDAY_FIRST = new WeekDay[]{Sun, Mon, Tue, Wed, Thu, Fri, Sat};

    public WeekDay(Integer id, String name, String enName) {
        this.id = id;
        this.name = name;
        this.enName = enName;
    }

    public String getEnName() {
        return this.enName;
    }

    public void setEnName(String enName) {
        this.enName = enName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getIndex() {
        if ((Integer)this.id == 7) {
            return 1;
        }
        return (Integer)this.id + 1;
    }

    public WeekDay previous() {
        int preDayId = (Integer)this.getId() - 1;
        if (preDayId <= 0) {
            return Sun;
        }
        return WeekDay.get(preDayId);
    }

    public WeekDay next() {
        int nextDayId = (Integer)this.getId() + 1;
        if (nextDayId > 7) {
            return Mon;
        }
        return WeekDay.get(nextDayId);
    }

    public static WeekDay get(int weekId) {
        return All[weekId - 1];
    }

    public static WeekDay[] getWeekdayArray(boolean firstDayOnSunday) {
        if (firstDayOnSunday) {
            return All_SUNDAY_FIRST;
        }
        return All;
    }

    public static WeekDay getDayByJdkIndex(int jdkWeekdayIndex) {
        int id = 0;
        id = jdkWeekdayIndex == 1 ? 7 : jdkWeekdayIndex - 1;
        return WeekDay.get(id);
    }

    public static List<WeekDay> getWeekdayList(boolean firstDayOnSunday) {
        return Arrays.asList(WeekDay.getWeekdayArray(firstDayOnSunday));
    }

    public static WeekDay of(Date d) {
        return WeekDay.get(LocalDateTime.from(d.toInstant()).getDayOfWeek().getValue());
    }

    @Override
    public int compareTo(WeekDay other) {
        return (Integer)this.id - (Integer)other.id;
    }
}

