/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.plan.model;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.MappedSuperclass;
import javax.validation.constraints.NotNull;
import org.beangle.commons.entity.pojo.LongIdObject;
import org.openurp.edu.base.code.model.CourseType;
import org.openurp.edu.program.plan.model.CourseGroup;
import org.openurp.edu.program.plan.model.CoursePlan;

@MappedSuperclass
public abstract class AbstractCoursePlan
extends LongIdObject
implements CoursePlan {
    private static final long serialVersionUID = 1606351182470625309L;
    @NotNull
    private float credits;
    private Integer startTerm;
    private Integer endTerm;

    public Integer getStartTerm() {
        return this.startTerm;
    }

    public void setStartTerm(Integer startTerm) {
        this.startTerm = startTerm;
    }

    public Integer getEndTerm() {
        return this.endTerm;
    }

    public void setEndTerm(Integer endTerm) {
        this.endTerm = endTerm;
    }

    @Override
    public void setTermsCount(Integer count) {
        this.startTerm = 1;
        this.endTerm = count;
    }

    @Override
    public Integer getTermsCount() {
        return this.endTerm - this.startTerm + 1;
    }

    @Override
    public float getCredits() {
        return this.credits;
    }

    @Override
    public void setCredits(float credits) {
        this.credits = credits;
    }

    public void addGroup(CourseGroup group) {
        if (null == this.getGroups()) {
            this.setGroups(new ArrayList());
        }
        this.getGroups().add(group);
        group.updateCoursePlan(this);
    }

    @Override
    public List<CourseGroup> getTopCourseGroups() {
        if (this.getGroups() == null) {
            return new ArrayList<CourseGroup>();
        }
        ArrayList<CourseGroup> res = new ArrayList<CourseGroup>();
        for (CourseGroup group : this.getGroups()) {
            if (group == null || group.getParent() != null) continue;
            res.add(group);
        }
        return res;
    }

    @Override
    public CourseGroup getGroup(CourseType type) {
        if (null == this.getGroups()) {
            return null;
        }
        for (CourseGroup group : this.getGroups()) {
            if (!group.getCourseType().equals((Object)type)) continue;
            return group;
        }
        return null;
    }

    public boolean isNumericTerm() {
        return true;
    }
}

