/*
 * Decompiled with CFR 0.152.
 */
package org.openurp.edu.program.plan.model;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.beangle.commons.collection.CollectUtils;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.openurp.code.edu.model.AcademicLevel;
import org.openurp.edu.base.model.Project;
import org.openurp.edu.program.plan.model.AbstractCoursePlan;
import org.openurp.edu.program.plan.model.CourseGroup;
import org.openurp.edu.program.plan.model.ShareCourseGroup;

@Entity(name="org.openurp.edu.program.plan.model.SharePlan")
public class SharePlan
extends AbstractCoursePlan
implements Cloneable {
    private static final long serialVersionUID = -9012605313915822262L;
    @NotNull
    @Size(max=255)
    private String name;
    @NotNull
    @Size(max=10)
    private String fromGrade;
    @NotNull
    @Size(max=10)
    private String toGrade;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    private Project project;
    @ManyToOne(fetch=FetchType.LAZY)
    private AcademicLevel level;
    @OneToMany(mappedBy="plan", targetEntity=ShareCourseGroup.class)
    @OrderBy(value="indexno")
    @Cascade(value={CascadeType.ALL})
    protected List<CourseGroup> groups = CollectUtils.newArrayList();
    @NotNull
    private Date beginOn;
    private Date endOn;
    protected java.util.Date createdAt;
    protected java.util.Date updatedAt;

    public java.util.Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(java.util.Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Object clone() throws CloneNotSupportedException {
        SharePlan shareCoursePlan = (SharePlan)super.clone();
        shareCoursePlan.setGroups(new ArrayList<CourseGroup>());
        shareCoursePlan.setId(null);
        for (CourseGroup cg : this.getGroups()) {
            if (null != cg.getParent()) continue;
            CourseGroup cgClone = (CourseGroup)cg.clone();
            cgClone.setPlan(shareCoursePlan);
            shareCoursePlan.addGroup(cgClone);
        }
        return shareCoursePlan;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AcademicLevel getLevel() {
        return this.level;
    }

    public void setLevel(AcademicLevel level) {
        this.level = level;
    }

    @Override
    public List<CourseGroup> getGroups() {
        return this.groups;
    }

    @Override
    public void setGroups(List<CourseGroup> groups) {
        this.groups = groups;
    }

    @Override
    public Date getBeginOn() {
        return this.beginOn;
    }

    public void setBeginOn(Date beginOn) {
        this.beginOn = beginOn;
    }

    @Override
    public Date getEndOn() {
        return this.endOn;
    }

    public void setEndOn(Date endOn) {
        this.endOn = endOn;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public java.util.Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(java.util.Date createdAt) {
        this.createdAt = createdAt;
    }

    public String getFromGrade() {
        return this.fromGrade;
    }

    public void setFromGrade(String fromGrade) {
        this.fromGrade = fromGrade;
    }

    public String getToGrade() {
        return this.toGrade;
    }

    public void setToGrade(String toGrade) {
        this.toGrade = toGrade;
    }
}

